/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.persistence.manager.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.hotent.base.context.BaseContext;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.portal.model.PortalBizSystem;
import com.hotent.portal.model.PortalBizSystemAuth;
import com.hotent.portal.persistence.dao.PortalBizSystemAuthDao;
import com.hotent.portal.persistence.manager.PortalBizSystemAuthManager;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PortalBizSystemAuthManagerImpl
extends BaseManagerImpl<PortalBizSystemAuthDao, PortalBizSystemAuth>
implements PortalBizSystemAuthManager {
    private Logger logger = LoggerFactory.getLogger(PortalBizSystemAuthManagerImpl.class);
    @Autowired
    private BaseContext baseContext;
    @Autowired
    private PortalBizSystemAuthDao portalBizSystemAuthDao;

    @Override
    public PortalBizSystemAuth getDetail(String id) {
        PortalBizSystemAuth portalBizSystemAuth = (PortalBizSystemAuth)this.get((Serializable)((Object)id));
        return portalBizSystemAuth;
    }

    @Override
    @Transactional
    public void createOrUpdate(PortalBizSystemAuth portalBizSystemAuth) {
        this.saveOrUpdate((Object)portalBizSystemAuth);
    }

    @Override
    public void batchSave(PortalBizSystem portalBizSystem) {
        UCFeignService ucFeignService = (UCFeignService)AppUtil.getBean(UCFeignService.class);
        if (BeanUtils.isEmpty(portalBizSystem.getManagerList())) {
            return;
        }
        for (PortalBizSystemAuth manager : portalBizSystem.getManagerList()) {
            PortalBizSystemAuth auth = new PortalBizSystemAuth();
            auth.setCreateBy(this.baseContext.getCurrentUserId());
            auth.setManagerId(manager.getManagerId());
            auth.setManagerName(manager.getManagerName());
            auth.setIsDele("0");
            auth.setSysName(portalBizSystem.getSysName());
            auth.setSysCode(portalBizSystem.getSysCode());
            auth.setCreateOrgId(this.baseContext.getCurrentOrgId());
            CommonResult user = ucFeignService.getUserById(manager.getManagerId());
            auth.setAccount(((JsonNode)user.getValue()).get("account").asText());
            try {
                this.portalBizSystemAuthDao.insert((Object)auth);
            }
            catch (Exception e) {
                if (e instanceof DuplicateKeyException) {
                    this.logger.error("\u63d2\u5165\u7ba1\u7406\u5458\u6388\u6743\u65f6\uff0c\u51fa\u73b0\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                    continue;
                }
                throw e;
            }
        }
    }
}

