/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.persistence.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.SQLUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.portal.model.MessageReceiver;
import com.hotent.portal.model.SysExecutor;
import com.hotent.portal.model.SysMessage;
import com.hotent.portal.params.MessaboxVo;
import com.hotent.portal.persistence.dao.SysMessageDao;
import com.hotent.portal.persistence.manager.MessageReceiverManager;
import com.hotent.portal.persistence.manager.SysMessageManager;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import com.hotent.uc.api.service.IUserService;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="sysMessageManager")
public class SysMessageManagerImpl
extends BaseManagerImpl<SysMessageDao, SysMessage>
implements SysMessageManager {
    @Resource
    MessageReceiverManager messageReceiverManager;
    @Resource
    IUserService iUserService;

    @Override
    public PageList<SysMessage> getMsgByUserId(QueryFilter queryFilter) {
        Set ids;
        Map map = queryFilter.getInitParams();
        Map params = queryFilter.getParams();
        map.putAll(params);
        IPage<SysMessage> page = ((SysMessageDao)this.baseMapper).getMsgByUserId((IPage<SysMessage>)this.convert2IPage(queryFilter.getPageBean()), map, (Wrapper<SysMessage>)Wrappers.emptyWrapper());
        if (BeanUtils.isNotEmpty((Object)page.getRecords()) && BeanUtils.isNotEmpty(ids = page.getRecords().stream().filter(item -> "0".equals(String.valueOf(item.getIsPublic()))).map(SysMessage::getRid).collect(Collectors.toSet()))) {
            List list = this.messageReceiverManager.list((Wrapper)Wrappers.lambdaQuery().select(new SFunction[]{MessageReceiver::getId, MessageReceiver::getMsgId}).in(MessageReceiver::getMsgId, ids));
            Map<String, String> collect = list.stream().collect(Collectors.toMap(MessageReceiver::getMsgId, MessageReceiver::getId, (oldValue, newValue) -> oldValue));
            for (SysMessage sysMessage : page.getRecords()) {
                if (!collect.containsKey(sysMessage.getRid())) continue;
                sysMessage.setRid(collect.get(sysMessage.getRid()));
            }
        }
        return new PageList(page);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResult<String> sendMsg(String subject, String content, String messageType, String senderId, String senderName, List<SysExecutor> receivers) {
        String id = UniqueIdUtil.getSuid();
        SysMessage sysMessage = new SysMessage();
        sysMessage.setId(id);
        sysMessage.setSubject(subject);
        sysMessage.setContent(content);
        sysMessage.setOwnerId(StringUtil.isEmpty((String)senderId) ? "-1" : senderId);
        sysMessage.setOwner(StringUtil.isEmpty((String)senderName) ? "x8\u7cfb\u7edf" : senderName);
        sysMessage.setMessageType(messageType);
        sysMessage.setCanReply((short)0);
        sysMessage.setIsPublic((short)0);
        sysMessage.setCreateTime(LocalDateTime.now());
        this.create((Model)sysMessage);
        for (SysExecutor sysExecutor : receivers) {
            MessageReceiver receiver = new MessageReceiver();
            receiver.setId(UniqueIdUtil.getSuid());
            receiver.setMsgId(id);
            receiver.setReceiverId(sysExecutor.getId());
            receiver.setReceiver(sysExecutor.getName());
            receiver.setReceiverType(sysExecutor.getType());
            this.messageReceiverManager.create((Model)receiver);
        }
        return new CommonResult(true, "\u53d1\u9001\u6d88\u606f\u6210\u529f!");
    }

    @Override
    public MessaboxVo getMessBoxInfo(String account) {
        IUser user = this.iUserService.getUserByAccount(account);
        int messCount = 0;
        int noReadMessCount = 0;
        if (BeanUtils.isNotEmpty((Object)user)) {
            QueryFilter queryFilter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
            queryFilter.addFilter("receiverId", (Object)ContextUtil.getCurrentUserId(), QueryOP.EQUAL);
            PageList<SysMessage> sysMessageList = this.getMsgByUserId(queryFilter);
            messCount = (int)sysMessageList.getTotal();
            if (messCount > 0) {
                for (SysMessage message : sysMessageList.getRows()) {
                    if (!BeanUtils.isEmpty((Object)message.getReceiveTime())) continue;
                    ++noReadMessCount;
                }
            }
        }
        return new MessaboxVo(messCount, noReadMessCount);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addMessageSend(SysMessage sysMessage) {
        MessageReceiver receiver;
        String name;
        String id;
        int i;
        String receiverIds = sysMessage.getReceiverId();
        String receiverNames = sysMessage.getReceiverName();
        String receiverOrgIds = sysMessage.getReceiverOrgId();
        String receiverOrgNames = sysMessage.getReceiverOrgName();
        IUser sender = ContextUtil.getCurrentUser();
        String messageId = UniqueIdUtil.getSuid();
        sysMessage.setId(messageId);
        sysMessage.setOwnerId(sender.getUserId());
        sysMessage.setOwner(sender.getFullname());
        sysMessage.setCreateTime(LocalDateTime.now());
        if (SysMessage.iS_PUBLIC_YES.equals(sysMessage.getIsPublic())) {
            this.create((Model)sysMessage);
            return;
        }
        String receriver = "";
        if (StringUtil.isNotEmpty((String)receiverNames) && StringUtil.isNotEmpty((String)receiverOrgNames)) {
            receriver = receiverNames + "," + receiverOrgNames;
        } else if (StringUtil.isNotEmpty((String)receiverNames) && StringUtil.isEmpty((String)receiverOrgNames)) {
            receriver = receiverNames;
        } else if (StringUtil.isEmpty((String)receiverNames) && StringUtil.isNotEmpty((String)receiverOrgNames)) {
            receriver = receiverOrgNames;
        }
        sysMessage.setReceiverName(receriver);
        this.create((Model)sysMessage);
        if (StringUtil.isNotEmpty((String)receiverIds)) {
            String[] idArr = receiverIds.split(",");
            String[] nameArr = receiverNames.split(",");
            for (i = 0; i < idArr.length; ++i) {
                id = idArr[i];
                if (StringUtil.isEmpty((String)id)) continue;
                name = "";
                if (nameArr.length > i) {
                    name = nameArr[i];
                }
                receiver = new MessageReceiver();
                receiver.setId(UniqueIdUtil.getSuid());
                receiver.setMsgId(messageId);
                receiver.setReceiverType(MessageReceiver.TYPE_USER);
                receiver.setReceiverId(id);
                receiver.setReceiver(name);
                this.messageReceiverManager.create((Model)receiver);
            }
        }
        if (StringUtil.isNotEmpty((String)receiverOrgIds)) {
            String[] orgIdArr = receiverOrgIds.split(",");
            String[] orgNameArr = receiverOrgNames.split(",");
            for (i = 0; i < orgIdArr.length; ++i) {
                id = orgIdArr[i];
                if (StringUtil.isEmpty((String)id)) continue;
                name = "";
                if (orgNameArr.length > i) {
                    name = orgNameArr[i];
                }
                receiver = new MessageReceiver();
                receiver.setId(UniqueIdUtil.getSuid());
                receiver.setMsgId(messageId);
                receiver.setReceiverType(MessageReceiver.TYPE_GROUP);
                receiver.setReceiverId(id);
                receiver.setReceiver(name);
                this.messageReceiverManager.create((Model)receiver);
            }
        }
    }

    @Override
    public SysMessage getNotReadMsg(String userId) {
        String dbtype = SQLUtil.getDbType();
        if (dbtype.equals("db2")) {
            return ((SysMessageDao)this.baseMapper).getOneNotReadMsgByUserIdDb2(userId);
        }
        if (dbtype.equals("oracle")) {
            return ((SysMessageDao)this.baseMapper).getOneNotReadMsgByUserIdOracl(userId);
        }
        if (dbtype.equals("mssql")) {
            return ((SysMessageDao)this.baseMapper).getOneNotReadMsgByUserIdMssql(userId);
        }
        return ((SysMessageDao)this.baseMapper).getOneNotReadMsgByUserIdMysql(userId);
    }

    @Override
    public int getNotReadMsgNum(String userId) {
        return ((SysMessageDao)this.baseMapper).getNotReadMsgNum(userId);
    }

    @Override
    public int getMsgSize(String receiverId) {
        return ((SysMessageDao)this.baseMapper).getMsgSize(receiverId);
    }
}

