/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.collect.Lists;
import com.hotent.base.aop.OpenApiProcessor;
import com.hotent.base.cache.annotation.Cacheable;
import com.hotent.base.context.BaseContext;
import com.hotent.base.entity.URIEntity;
import com.hotent.base.enums.ResponseErrorEnums;
import com.hotent.base.exception.BaseException;
import com.hotent.base.feign.BpmModelFeignService;
import com.hotent.base.feign.BpmRuntimeFeignService;
import com.hotent.base.feign.FormFeignService;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.handler.MultiTenantHandler;
import com.hotent.base.handler.MultiTenantIgnoreResult;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.FieldSort;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.portal.model.PortalBizSystem;
import com.hotent.portal.model.PortalBizSystemAuth;
import com.hotent.portal.model.PortalUrlPermission;
import com.hotent.portal.persistence.dao.PortalBizSystemAuthDao;
import com.hotent.portal.persistence.dao.PortalBizSystemDao;
import com.hotent.portal.persistence.dao.PortalUrlPermissionDao;
import com.hotent.portal.persistence.manager.PortalBizSystemAuthManager;
import com.hotent.portal.persistence.manager.PortalMsgSendLogManager;
import com.hotent.portal.service.PortalBizSystemManager;
import com.hotent.portal.service.PortalUrlPermissionManager;
import com.hotent.sys.persistence.manager.SysPropertiesManager;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PortalBizSystemManagerImpl
extends BaseManagerImpl<PortalBizSystemDao, PortalBizSystem>
implements PortalBizSystemManager {
    private final String Prefix = "openApi:";
    private final Logger logger = LoggerFactory.getLogger(PortalBizSystemManagerImpl.class);
    @Value(value="${spring.application.name:base}")
    private String applicationName;
    @Autowired
    PortalBizSystemDao portalBizSystemDao;
    @Autowired
    BaseContext baseContext;
    @Autowired
    PortalUrlPermissionManager portalUrlPermissionManager;
    @Autowired
    PortalMsgSendLogManager portalMsgSendLogManager;
    @Autowired
    SysPropertiesManager sysPropertiesManager;
    @Autowired
    UCFeignService ucFeignService;
    @Autowired
    PortalBizSystemAuthDao portalBizSystemAuthDao;
    @Autowired
    PortalBizSystemAuthManager portalBizSystemAuthManager;
    @Autowired
    PortalUrlPermissionDao portalUrlPermissionDao;
    @Autowired
    BpmModelFeignService bpmModelFeignService;
    @Autowired
    BpmRuntimeFeignService bpmRuntimeFeignService;
    @Autowired
    FormFeignService formFeignService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResult<String> savePortalBizSystem(PortalBizSystem portalBizSystem) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"SYS_CODE_", (Object)portalBizSystem.getSysCode());
        PortalBizSystem bizSystem = null;
        try (MultiTenantIgnoreResult result = MultiTenantHandler.setThreadLocalIgnore();){
            bizSystem = (PortalBizSystem)((Object)this.portalBizSystemDao.selectOne((Wrapper)wrapper));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (BeanUtils.isNotEmpty(bizSystem)) {
            return new CommonResult(false, "\u8be5\u7cfb\u7edf\u7f16\u7801\u5728\u672c\u79df\u6237\u6216\u8005\u5176\u4ed6\u79df\u6237\u5e73\u53f0\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0", (Object)"");
        }
        portalBizSystem.setCreateBy(this.baseContext.getCurrentUserId());
        portalBizSystem.setEnabled("0");
        portalBizSystem.setIsDele("0");
        portalBizSystem.setCreateOrgId(this.baseContext.getCurrentOrgId());
        int insert = this.portalBizSystemDao.insert((Object)portalBizSystem);
        this.portalBizSystemAuthManager.batchSave(portalBizSystem);
        if (insert != 1) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult(ResponseErrorEnums.SUCCESS_OPTION, null);
    }

    @Transactional
    public CommonResult updatePortalBizSystem(PortalBizSystem portalBizSystem) {
        if ("true".equals(portalBizSystem.getEnabled())) {
            portalBizSystem.setEnabled("0");
        } else {
            portalBizSystem.setEnabled("1");
        }
        portalBizSystem.setUpdateBy(this.baseContext.getCurrentUserId());
        this.portalBizSystemDao.updateById((Object)portalBizSystem);
        QueryWrapper authQueryWrapper = new QueryWrapper();
        ((QueryWrapper)authQueryWrapper.eq((Object)"SYS_CODE_", (Object)portalBizSystem.getSysCode())).eq((Object)"CREATE_BY_", (Object)this.baseContext.getCurrentUserId());
        this.portalBizSystemAuthDao.delete((Wrapper)authQueryWrapper);
        this.portalBizSystemAuthManager.batchSave(portalBizSystem);
        return new CommonResult(true, ResponseErrorEnums.SUCCESS_OPTION.getMessage(), null);
    }

    @Override
    public CommonResult searchById(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"ID_", (Object)id)).eq((Object)"IS_DELE_", (Object)"0");
        PortalBizSystem portalBizSystem = (PortalBizSystem)((Object)this.portalBizSystemDao.selectOne((Wrapper)queryWrapper));
        QueryWrapper authQueryWrapper = new QueryWrapper();
        ((QueryWrapper)authQueryWrapper.eq((Object)"SYS_CODE_", (Object)portalBizSystem.getSysCode())).eq((Object)"IS_DELE_", (Object)"0");
        List auths = this.portalBizSystemAuthDao.selectList((Wrapper)authQueryWrapper);
        portalBizSystem.setManagerList(auths);
        return new CommonResult().value((Object)portalBizSystem);
    }

    @Override
    public CommonResult getOpenApiList() {
        PortalBizSystemManagerImpl bean = (PortalBizSystemManagerImpl)AppUtil.getBean(this.getClass());
        Set<URIEntity> openApiList = bean.getOpenApiListFromCache("openApi");
        HashMap map = new HashMap();
        openApiList.stream().forEach(item -> {
            if (map.get(item.getModuleName()) == null) {
                ArrayList<URIEntity> descriptionList = new ArrayList<URIEntity>();
                HashMap<String, ArrayList<URIEntity>> functionMap = new HashMap<String, ArrayList<URIEntity>>();
                descriptionList.add((URIEntity)item);
                functionMap.put(item.getFunction(), descriptionList);
                map.put(item.getModuleName(), functionMap);
            } else {
                Map treeMap = (Map)map.get(item.getModuleName());
                ArrayList<URIEntity> descriptionList = (ArrayList<URIEntity>)treeMap.get(item.getFunction());
                if (descriptionList == null || descriptionList.size() == 0) {
                    descriptionList = new ArrayList<URIEntity>();
                }
                descriptionList.add((URIEntity)item);
                treeMap.put(item.getFunction(), descriptionList);
                map.put(item.getModuleName(), treeMap);
            }
        });
        return new CommonResult().value(map);
    }

    @Override
    public CommonResult checkSysCode(String sysCode, String secretKey) throws Exception {
        QueryWrapper wrapper = new QueryWrapper();
        if (StringUtil.isNotEmpty((String)secretKey)) {
            wrapper.eq((Object)"SECRET_KEY_", (Object)secretKey);
        }
        wrapper.eq((Object)"SYS_CODE_", (Object)sysCode);
        PortalBizSystem res = null;
        try (MultiTenantIgnoreResult result = MultiTenantHandler.setThreadLocalIgnore();){
            res = (PortalBizSystem)((Object)this.portalBizSystemDao.selectOne((Wrapper)wrapper));
        }
        if (res == null) {
            return new CommonResult(false, "\u7cfb\u7edf\u7f16\u7801\u6216\u7cfb\u7edf\u5bc6\u5319\u4e0d\u6b63\u786e", null);
        }
        if ("1".equals(res.getEnabled())) {
            return new CommonResult(false, "\u8be5\u5916\u90e8\u7cfb\u7edf\u5df2\u7981\u7528\uff0c\u8ba4\u8bc1\u5931\u8d25", null);
        }
        return new CommonResult(true, "\u8ba4\u8bc1\u4fe1\u606f\u6b63\u786e", (Object)res.getRobotId());
    }

    @Override
    public CommonResult getPortalBizSystemBySysCode(String sysCode) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"SYS_CODE_", (Object)sysCode);
        PortalBizSystem portalBizSystem = (PortalBizSystem)((Object)this.portalBizSystemDao.selectOne((Wrapper)wrapper));
        if (portalBizSystem == null) {
            return new CommonResult(false, "\u67e5\u65e0\u6b64\u7cfb\u7edf\u7f16\u7801", null);
        }
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", (Object)portalBizSystem.getBpmMsgQueue());
    }

    @Override
    public CommonResult getPortalBizSystemByCode(String code) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"SYS_CODE_", (Object)code);
        PortalBizSystem portalBizSystem = (PortalBizSystem)((Object)this.portalBizSystemDao.selectOne((Wrapper)wrapper));
        if (portalBizSystem == null) {
            return new CommonResult(false, "\u67e5\u65e0\u6b64\u7cfb\u7edf\u7f16\u7801", null);
        }
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", (Object)portalBizSystem);
    }

    @Override
    public CommonResult checkSysCodeAndUri(String sysCode, String secretKey, String uri, String tenantId) {
        QueryWrapper wrapper = new QueryWrapper();
        if (StringUtil.isNotEmpty((String)secretKey)) {
            wrapper.eq((Object)"SECRET_KEY_", (Object)secretKey);
        }
        wrapper.eq((Object)"SYS_CODE_", (Object)sysCode);
        PortalBizSystem res = (PortalBizSystem)((Object)this.portalBizSystemDao.selectOne((Wrapper)wrapper));
        if (res == null) {
            return new CommonResult(false, "\u7cfb\u7edf\u7f16\u7801\u6216\u7cfb\u7edf\u5bc6\u5319\u4e0d\u6b63\u786e", null);
        }
        QueryWrapper portalUrlWrapper = new QueryWrapper();
        ((QueryWrapper)portalUrlWrapper.eq((Object)"SYS_ID_", (Object)res.getSysCode())).eq((Object)"AUTH_URL_", (Object)uri);
        PortalUrlPermission one = (PortalUrlPermission)((Object)this.portalUrlPermissionManager.getOne((Wrapper)portalUrlWrapper));
        if (one == null) {
            return new CommonResult(false, "\u5f53\u524d\u8def\u5f84\uff0c\u60a8\u65e0\u8bbf\u95ee\u6743\u9650", null);
        }
        return new CommonResult(true, "\u8ba4\u8bc1\u4fe1\u606f\u6b63\u786e", (Object)res.getRobotId());
    }

    @Override
    public List<PortalBizSystem> getList() {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"ENABLED_", (Object)"0");
        return ((PortalBizSystemDao)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    public List<PortalBizSystem> getServiceList() throws JsonProcessingException {
        ArrayList serviceList = Lists.newArrayList();
        String arrayString = this.sysPropertiesManager.getByAlias("service.address");
        if (StringUtils.isNotBlank((CharSequence)arrayString)) {
            arrayString = arrayString.replace("\\\"", "\"");
            ObjectMapper mapper = JsonUtil.getMapper();
            JsonNode jsonNode = mapper.readTree(arrayString);
            if (!Objects.isNull(jsonNode) && jsonNode.isArray()) {
                PortalBizSystem tmp = null;
                ArrayNode arrayNode = (ArrayNode)jsonNode;
                for (JsonNode jn : arrayNode) {
                    tmp = new PortalBizSystem();
                    tmp.setSysName(jn.get("code").asText());
                    tmp.setSysCode(jn.get("code").asText());
                    tmp.setRootAddress(jn.get("value").asText());
                    serviceList.add(tmp);
                }
            }
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"ENABLED_", (Object)"0");
        wrapper.select(new String[]{"SYS_CODE_", "SYS_NAME_,ROOT_ADDRESS_"});
        List portalBizSystemList = ((PortalBizSystemDao)this.baseMapper).selectList((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)portalBizSystemList)) {
            serviceList.addAll(portalBizSystemList);
        }
        return serviceList;
    }

    @Override
    public CommonResult getAuthUserBySystemCode(QueryFilter queryFilter) {
        String sysCode = (String)queryFilter.getParams().get("sysCode");
        boolean isAdmin = ContextUtil.getCurrentUser().isAdmin();
        String curUserId = null;
        if (!isAdmin) {
            curUserId = ContextUtil.getCurrentUser().getUserId();
        }
        String managerName = null;
        String account = null;
        if (BeanUtils.isNotEmpty((Object)queryFilter.getQuerys())) {
            QueryField managerField = (QueryField)queryFilter.getQuerys().get(0);
            QueryField accountField = (QueryField)queryFilter.getQuerys().get(1);
            managerName = (String)managerField.getValue();
            account = (String)accountField.getValue();
        }
        Page page = new Page((long)queryFilter.getPageBean().getPage().intValue(), (long)queryFilter.getPageBean().getPageSize().intValue());
        IPage<PortalBizSystemAuth> iPage = this.portalBizSystemAuthDao.selectBizSystemAuth((IPage<PortalBizSystemAuth>)page, sysCode, managerName, account, isAdmin, curUserId);
        return CommonResult.ok().value((Object)new PageList(iPage));
    }

    @Override
    public CommonResult deleteAuthByIds(String userIds) {
        String[] ids = userIds.split(",");
        this.portalBizSystemAuthDao.deleteBatchIds(Arrays.asList(ids));
        return CommonResult.ok();
    }

    @Override
    @Transactional
    public CommonResult addAuthByUserIdAndSysCode(String userIds, String sysCode) {
        String[] ids = userIds.split(",");
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"SYS_CODE_", (Object)sysCode);
        PortalBizSystem portalBizSystem = (PortalBizSystem)((Object)this.portalBizSystemDao.selectOne((Wrapper)wrapper));
        List auths = this.portalBizSystemAuthDao.selectList((Wrapper)Wrappers.lambdaQuery().eq(PortalBizSystemAuth::getSysCode, (Object)sysCode));
        Set oldAuthAccounts = auths.stream().map(PortalBizSystemAuth::getAccount).collect(Collectors.toSet());
        for (String userId : ids) {
            PortalBizSystemAuth auth = new PortalBizSystemAuth();
            auth.setSysCode(sysCode);
            auth.setManagerId(userId);
            CommonResult user = this.ucFeignService.getUserById(userId);
            String account = ((JsonNode)user.getValue()).get("account").asText();
            if (StringUtil.isNotEmpty((String)account) && oldAuthAccounts.contains(account)) continue;
            String username = ((JsonNode)user.getValue()).get("fullname").asText();
            auth.setManagerName(username);
            auth.setIsDele("0");
            auth.setCreateBy(ContextUtil.getCurrentUserId());
            auth.setSysName(portalBizSystem.getSysName());
            auth.setAccount(account);
            try {
                this.portalBizSystemAuthDao.insert((Object)auth);
            }
            catch (Exception e) {
                this.logger.error("\u63d2\u5165\u7ba1\u7406\u5458\u65f6\u5f02\u5e38:{}", (Object)e.getMessage());
            }
        }
        return CommonResult.ok();
    }

    @Override
    @Transactional
    public CommonResult deleteBySysCode(String sysCodes) {
        String[] sysCodeArray;
        for (String sysCode : sysCodeArray = sysCodes.split(",")) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"SYS_CODE_", (Object)sysCode);
            PortalBizSystem portalBizSystem = (PortalBizSystem)((Object)this.portalBizSystemDao.selectOne((Wrapper)wrapper));
            if (portalBizSystem == null) continue;
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"SYS_ID_", (Object)sysCode);
            List urlPermissions = this.portalUrlPermissionDao.selectList((Wrapper)queryWrapper);
            if (BeanUtils.isNotEmpty((Object)urlPermissions)) {
                throw new BaseException("\u8bf7\u5148\u5220\u9664 " + portalBizSystem.getSysName() + " \u7cfb\u7edf\u6388\u6743\u7684\u5916\u90e8\u63a5\u53e3");
            }
            QueryWrapper systemAuthQueryWrapper = new QueryWrapper();
            systemAuthQueryWrapper.eq((Object)"sys_code_", (Object)sysCode);
            this.portalBizSystemAuthDao.delete((Wrapper)systemAuthQueryWrapper);
            LambdaQueryWrapper portalBizSystemWrapper = Wrappers.lambdaQuery();
            portalBizSystemWrapper.eq(PortalBizSystem::getSysCode, (Object)sysCode);
            this.portalBizSystemDao.delete((Wrapper)portalBizSystemWrapper);
        }
        return CommonResult.ok().message(ResponseErrorEnums.SUCCESS_OPTION.getMessage());
    }

    @Override
    public PageList queryData(QueryFilter queryFilter) {
        IUser user = ContextUtil.getCurrentUser();
        boolean isAdmin = user.isAdmin();
        PageBean pageBean = queryFilter.getPageBean();
        String sysCode = null;
        String orderFields = "";
        if (queryFilter.getQuerys().size() != 0) {
            List querys = queryFilter.getQuerys();
            QueryField queryField = (QueryField)querys.get(0);
            sysCode = (String)queryField.getValue();
        }
        if (queryFilter.getSorter().size() > 0) {
            List fieldSorts = queryFilter.getSorter();
            for (FieldSort fieldSort : fieldSorts) {
                if (fieldSort.getProperty().equalsIgnoreCase("ENABLED")) {
                    orderFields = orderFields + ", " + fieldSort.getProperty() + "_  " + fieldSort.getDirection();
                    continue;
                }
                orderFields = orderFields + ", " + fieldSort.getProperty() + " " + fieldSort.getDirection();
            }
            orderFields = orderFields.substring(2);
        }
        IPage<PortalBizSystem> result = this.portalBizSystemDao.selectData((IPage<PortalBizSystem>)this.convert2IPage(pageBean), isAdmin, user.getUserId(), sysCode, orderFields);
        result.getRecords().forEach(t -> {
            CommonResult userNode = this.ucFeignService.getUserById(t.getCreateBy());
            if (userNode.getState().booleanValue()) {
                t.setCreatorName(((JsonNode)userNode.getValue()).get("fullname").asText());
            }
        });
        return new PageList(result);
    }

    @Override
    public Set<String> getTodoTopicKeys() {
        Set<String> topicKeys = new HashSet<String>();
        List systems = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PortalBizSystem::getEnabled, (Object)"0")).like(PortalBizSystem::getAccessServices, (Object)"todo")).isNotNull(PortalBizSystem::getTodoMsgQueue));
        if (BeanUtils.isNotEmpty((Object)systems)) {
            topicKeys = systems.stream().map(PortalBizSystem::getTodoMsgQueue).collect(Collectors.toSet());
        }
        return topicKeys;
    }

    @Cacheable(value={"SYS_UC_OPEN_API"}, key="#openApi", shortExpire=true)
    public Set<URIEntity> getOpenApiListFromCache(String openApi) {
        if (!"base".equals(this.applicationName)) {
            CopyOnWriteArraySet<URIEntity> result = new CopyOnWriteArraySet<URIEntity>();
            Set bpmModelURIEntity = this.bpmModelFeignService.getMicroURIEntity();
            Set bpmRuntimeURIEntity = this.bpmRuntimeFeignService.getMicroURIEntity();
            Set formFeignURIEntity = this.formFeignService.getMicroURIEntity();
            Set portalURIEntity = OpenApiProcessor.uriEntitySet;
            Set ucURIEntity = this.ucFeignService.getMicroURIEntity();
            result.addAll(bpmModelURIEntity);
            result.addAll(bpmRuntimeURIEntity);
            result.addAll(formFeignURIEntity);
            result.addAll(portalURIEntity);
            result.addAll(ucURIEntity);
            return result;
        }
        return OpenApiProcessor.uriEntitySet;
    }
}

