/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.hotent.base.context.BaseContext;
import com.hotent.base.entity.URIEntity;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.portal.model.PortalBizSystem;
import com.hotent.portal.model.PortalUrlPermission;
import com.hotent.portal.model.dto.PortalUrlPermissionDto;
import com.hotent.portal.persistence.dao.PortalBizSystemDao;
import com.hotent.portal.persistence.dao.PortalUrlPermissionDao;
import com.hotent.portal.service.PortalUrlPermissionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PortalUrlPermissionManagerImpl
extends BaseManagerImpl<PortalUrlPermissionDao, PortalUrlPermission>
implements PortalUrlPermissionManager {
    private Logger logger = LoggerFactory.getLogger(PortalUrlPermissionManagerImpl.class);
    @Autowired
    PortalUrlPermissionDao portalUrlPermissionDao;
    @Autowired
    PortalBizSystemDao portalBizSystemDao;
    @Autowired
    BaseContext baseContext;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResult saveData(PortalUrlPermissionDto dto) {
        QueryWrapper wrapper = new QueryWrapper();
        PortalBizSystem portalBizSystem = (PortalBizSystem)((Object)this.portalBizSystemDao.selectOne((Wrapper)wrapper.eq((Object)"SYS_CODE_", (Object)dto.getSysId())));
        if (portalBizSystem == null) {
            return new CommonResult(false, "\u6dfb\u52a0\u5931\u8d25\uff0c\u65e0\u6b64\u7cfb\u7edf\u7f16\u7801", null);
        }
        int errorCount = 0;
        StringBuilder msg = new StringBuilder("\u8def\u5f84\uff1a");
        String returnMsg = "";
        for (URIEntity item : dto.getUriList()) {
            PortalUrlPermission portalUrlPermission = new PortalUrlPermission();
            portalUrlPermission.setCreateBy(this.baseContext.getCurrentUserId());
            portalUrlPermission.setCreateOrgId(this.baseContext.getCurrentOrgId());
            portalUrlPermission.setAuthUrl(item.getMethodURI().replaceAll("//", "/"));
            portalUrlPermission.setFunction(item.getFunction());
            portalUrlPermission.setModule(item.getModuleName());
            portalUrlPermission.setDescription(item.getDescription());
            portalUrlPermission.setSysId(portalBizSystem.getSysCode());
            try {
                int n = this.portalUrlPermissionDao.insert((Object)portalUrlPermission);
            }
            catch (Exception e) {
                ++errorCount;
                msg.append(item.getMethodURI()).append("\u3001");
                this.logger.error("\u8def\u5f84\uff1a{}\uff0c\u5df2\u6dfb\u52a0\uff0c\u65e0\u9700\u518d\u6b21\u6dfb\u52a0", (Object)item.getMethodURI());
            }
            returnMsg = "\u64cd\u4f5c\u6210\u529f\uff0c\u6210\u529f\u63d2\u5165" + (dto.getUriList().size() - errorCount) + "\u6761\uff0c\u5931\u8d25" + errorCount + "\u6761\u3002";
            if (errorCount <= 0) continue;
            msg.append("\u5df2\u6dfb\u52a0\uff0c\u65e0\u9700\u518d\u6b21\u6dfb\u52a0");
            returnMsg = returnMsg + "\u5176\u4e2d\uff0c" + msg;
        }
        return new CommonResult().message(returnMsg);
    }
}

