/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.util;

import com.hotent.base.util.StringUtil;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CookieUitl {
    public static void addCookie(String name, String value, boolean httpOnly, HttpServletRequest req, HttpServletResponse response) {
        CookieUitl.addCookie(name, value, -1, httpOnly, "", req.getContextPath(), req, response);
    }

    public static void addCookie(String name, String value, int maxAge, boolean httpOnly, String domain, String path, HttpServletRequest req, HttpServletResponse response) {
        if (response == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        sb.append('=');
        sb.append(value.trim() + "; ");
        if (maxAge != -1) {
            sb.append("max-age=");
            sb.append(maxAge + "; ");
        }
        if (StringUtil.isNotEmpty((String)domain)) {
            sb.append("domain=");
            sb.append(domain + "; ");
        }
        if (StringUtil.isNotEmpty((String)path)) {
            sb.append("path=");
            sb.append(path + ";");
        }
        if (httpOnly) {
            sb.append("HttpOnly");
        }
        response.addHeader("Set-Cookie", sb.toString());
    }

    public static void delCookie(String name, HttpServletRequest request, HttpServletResponse response) {
        CookieUitl.addCookie(name, "", 0, true, "", request.getContextPath(), request, response);
    }

    public static String getValueByName(String name, HttpServletRequest request) {
        if (request == null) {
            return "";
        }
        Cookie[] cookies = request.getCookies();
        Cookie sCookie = null;
        String svalue = null;
        String sname = null;
        if (cookies == null) {
            return null;
        }
        for (int i = 0; i < cookies.length; ++i) {
            sCookie = cookies[i];
            sname = sCookie.getName();
            if (!sname.equals(name)) continue;
            svalue = sCookie.getValue();
            break;
        }
        return svalue;
    }

    public static boolean isExistByName(String name, HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        Cookie sCookie = null;
        String sname = null;
        boolean isExist = false;
        if (cookies == null) {
            return false;
        }
        for (int i = 0; i < cookies.length; ++i) {
            sCookie = cookies[i];
            sname = sCookie.getName();
            if (!sname.equals(name)) continue;
            isExist = true;
            break;
        }
        return isExist;
    }
}

