/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;

public class HttpClientUtil {
    public static ObjectNode executeRestfulApi(String restApi, JsonNode params) throws Exception {
        ObjectMapper mapper = JsonUtil.getMapper();
        ObjectNode responseMsg = mapper.createObjectNode();
        try {
            if (BeanUtils.isNotEmpty((Object)params)) {
                HttpClientUtil.postHttp(restApi, params);
            } else {
                responseMsg = HttpClientUtil.getHttp(restApi);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (ObjectNode)JsonUtil.toJsonNode((Object)responseMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectNode getHttp(String url) throws Exception {
        String responseMsg = "";
        HttpClient httpClient = new HttpClient();
        GetMethod getMethod = new GetMethod(url);
        getMethod.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler());
        try {
            httpClient.executeMethod((HttpMethod)getMethod);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            InputStream in = getMethod.getResponseBodyAsStream();
            int len = 0;
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) != -1) {
                out.write(buf, 0, len);
            }
            responseMsg = out.toString("UTF-8");
        }
        catch (HttpException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            getMethod.releaseConnection();
        }
        return (ObjectNode)JsonUtil.toJsonNode((String)responseMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonNode postHttp(String url, JsonNode params) throws Exception {
        String responseMsg = "";
        HttpClient httpClient = new HttpClient();
        httpClient.getParams().setContentCharset("GBK");
        PostMethod postMethod = new PostMethod(url);
        try {
            if (BeanUtils.isNotEmpty((Object)params)) {
                ObjectMapper mapper = JsonUtil.getMapper();
                ObjectNode obj = mapper.createObjectNode();
                for (Object object : params) {
                    JsonNode jsonObj = JsonUtil.toJsonNode(object);
                    obj.put(jsonObj.get("name").asText(), jsonObj.get("value").asText());
                }
                postMethod.setRequestEntity((RequestEntity)new StringRequestEntity(obj.toString(), "application/json", "UTF-8"));
            }
            httpClient.executeMethod((HttpMethod)postMethod);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            InputStream in = postMethod.getResponseBodyAsStream();
            int len = 0;
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) != -1) {
                out.write(buf, 0, len);
            }
            responseMsg = out.toString("UTF-8");
        }
        catch (HttpException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            postMethod.releaseConnection();
        }
        return JsonUtil.toJsonNode((String)responseMsg);
    }
}

