/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.util;

import com.hotent.base.cache.annotation.CacheEvict;
import com.hotent.base.cache.annotation.CachePut;
import com.hotent.base.cache.annotation.Cacheable;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component
public class RedisCachUtil {
    protected static final Logger logger = LoggerFactory.getLogger(RedisCachUtil.class);
    @Resource
    JdbcTemplate jdbcTemplate;

    @Cacheable(value={"eip:sys:commonFlow"}, key="#flowKey")
    public String getFlowState(String flowKey) {
        try {
            String sql = "SELECT\n\tportal_common_flow.state_ as 'state' \nFROM\n\tportal_common_flow\n\tLEFT JOIN portal_common_flow_detail ON portal_common_flow.ID_ = portal_common_flow_detail.REF_ID_ \nWHERE\t (portal_common_flow.FLOW_CODE_ = ? \n\t OR portal_common_flow_detail.FLOW_CODE_ = ? )\n\t LIMIT 1";
            Object[] objects = new Object[]{flowKey, flowKey};
            List maps = this.jdbcTemplate.queryForList(sql, objects);
            if (maps != null && !maps.isEmpty()) {
                String state = ((Map)maps.get(0)).get("state").toString();
                return state;
            }
        }
        catch (Exception e) {
            logger.error(String.format("\u83b7\u53d6\u5f85\u529e\u3001\u5df2\u529e\u7d27\u6025\u7c7b\u578b\u5931\u8d25\uff1a%s", e.getMessage()));
        }
        return null;
    }

    @CachePut(value={"eip:sys:commonFlow"}, key="#flowKey+'_'+#systemCode")
    public String setFlowState(String flowKey, String value) {
        return value;
    }

    @CacheEvict(value={"eip:sys:commonFlow"}, key="#flowKey")
    public void delFlowState(String flowKey) {
    }

    public static void main(String[] args) {
        String sql = "SELECT\n\tportal_common_flow.state_ as 'state' \nFROM\n\tportal_common_flow\n\tLEFT JOIN portal_common_flow_detail ON portal_common_flow.ID_ = portal_common_flow_detail.REF_ID_ \nWHERE\t (portal_common_flow.FLOW_CODE_ = ? \n\t OR portal_common_flow_detail.FLOW_CODE_ = ? )\n\t LIMIT 1";
        System.out.println(sql);
    }
}

