/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal;

import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceAutoConfigure;
import com.hotent.base.typefilter.CustomTypeFilter;
import com.hotent.base.util.StringUtil;
import javax.servlet.MultipartConfigElement;
import org.mybatis.spring.annotation.MapperScan;
import org.redisson.spring.starter.RedissonAutoConfiguration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.servlet.MultipartConfigFactory;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;
import org.springframework.util.unit.DataSize;
import org.springframework.util.unit.DataUnit;

@SpringBootApplication(exclude={DruidDataSourceAutoConfigure.class, RedissonAutoConfiguration.class})
@Configuration
@MapperScan(basePackages={"com.hotent.**.dao"})
@ComponentScan(basePackages={"com.hotent.*", "cn.keking.*"}, excludeFilters={@ComponentScan.Filter(type=FilterType.CUSTOM, value={CustomTypeFilter.class})})
@EnableFeignClients(basePackages={"com.hotent.*"})
public class Application {
    @Value(value="${spring.servlet.multipart.maxFileSize:'1024MB'}")
    private String maxFileSize;
    @Value(value="${spring.servlet.multipart.maxRequestSize:'1024MB'}")
    private String maxRequestSize;

    public static void main(String[] args) {
        try {
            SpringApplication.run(Application.class, (String[])args);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Bean
    public MultipartConfigElement multipartConfigElement() {
        MultipartConfigFactory factory = new MultipartConfigFactory();
        factory.setMaxFileSize(StringUtil.isEmpty((String)this.maxFileSize) ? DataSize.of((long)10L, (DataUnit)DataUnit.MEGABYTES) : DataSize.parse((CharSequence)this.maxFileSize));
        factory.setMaxRequestSize(StringUtil.isEmpty((String)this.maxRequestSize) ? DataSize.of((long)100L, (DataUnit)DataUnit.MEGABYTES) : DataSize.parse((CharSequence)this.maxRequestSize));
        return factory.createMultipartConfig();
    }
}

