/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.controller;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.jms.JmsActor;
import com.hotent.base.jms.JmsProducer;
import com.hotent.base.jms.Notice;
import com.hotent.base.jms.NoticeMessageType;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.AppUtil;
import com.hotent.portal.service.TemplateService;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/portal/jms/v1"})
@Api(tags={"\u961f\u5217\u6d88\u606f\u53d1\u9001"})
@ApiGroup(group={"group_portal"})
public class JmsProducerController {
    @Resource
    TemplateService templateService;

    @RequestMapping(value={"sendNoticeToQueue"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d1\u9001\u6d88\u606f", httpMethod="POST", notes="\u53d1\u9001\u6d88\u606f")
    public CommonResult<String> sendNoticeToQueue(@ApiParam(name="notice", value="\u901a\u77e5(\u901a\u8fc7\u6a21\u677f\u6765\u53d1\u9001\u7684\u6d88\u606f)") @RequestBody Notice notice) throws Exception {
        this.templateService.sendNotice2Jms(notice);
        return new CommonResult(true, "\u53d1\u9001\u6d88\u606f\u6210\u529f\uff01");
    }

    @RequestMapping(value={"sendToQueue"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d1\u9001\u6d88\u606f\u5230\u961f\u5217\u4e2d", httpMethod="POST", notes="\u53d1\u9001\u6d88\u606f\u5230\u961f\u5217\u4e2d")
    public CommonResult<String> sendToQueue(@ApiParam(name="notice", value="\u901a\u77e5(\u901a\u8fc7\u6a21\u677f\u6765\u53d1\u9001\u7684\u6d88\u606f)") @RequestBody ObjectNode model) throws Exception {
        JmsProducer jmsProducer = (JmsProducer)AppUtil.getBean(JmsProducer.class);
        jmsProducer.sendToQueue((Object)model);
        return new CommonResult(true, "\u6210\u529f\u53d1\u9001\u6d88\u606f\u5230\u961f\u5217\uff01");
    }

    @RequestMapping(value={"sendMsg"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d1\u9001\u6d88\u606f\u5230\u961f\u5217\u4e2d", httpMethod="GET", notes="\u53d1\u9001\u6d88\u606f\u5230\u961f\u5217\u4e2d")
    public CommonResult<String> sendMsg(@ApiParam(name="accounts", value="\u88ab\u901a\u77e5\u4eba\u8d26\u53f7,\u53f7\u9694\u5f00") @RequestParam String accounts, @ApiParam(name="subject", value="\u901a\u77e5\u4e3b\u9898") @RequestParam String subject, @ApiParam(name="content", value="\u5185\u5bb9") @RequestParam String content, @ApiParam(name="msgTypeKeys", value="\u901a\u77e5\u7c7b\u578b(sms,voice,inner,mail,wxEnterprise,flyBook,dingTalk)") @RequestParam String msgTypeKeys) throws Exception {
        String[] split = accounts.split(",");
        ArrayList<JmsActor> reciever = new ArrayList<JmsActor>();
        Notice notice = new Notice();
        for (String account : split) {
            IUser user = ContextUtil.getUserByAccount((String)account);
            JmsActor actor = new JmsActor();
            actor.setId(user.getUserId());
            actor.setAccount(user.getAccount());
            actor.setName(user.getFullname());
            actor.setEmail(user.getEmail());
            actor.setMobile(user.getMobile());
            actor.setWeixin(user.getWeixin());
            actor.setClientId(user.getClientId());
            actor.setClientToken(user.getClientToken());
            reciever.add(actor);
        }
        notice.setSubject(subject);
        notice.setReceiver(reciever);
        notice.setContent(content);
        NoticeMessageType[] parseNotifyType = this.parseNotifyType(msgTypeKeys);
        notice.setMessageTypes(parseNotifyType);
        notice.setVars(null);
        notice.setUseTemplate(false);
        this.templateService.sendNotice2Jms(notice);
        return new CommonResult(true, "\u53d1\u9001\u6d88\u606f\u6210\u529f\uff01");
    }

    private NoticeMessageType[] parseNotifyType(String typeStr) {
        String[] split = typeStr.split(",");
        List<String> nofifyTypes = Arrays.asList(split);
        ArrayList<NoticeMessageType> messageTypeArrays = new ArrayList<NoticeMessageType>();
        EnumSet<NoticeMessageType> it = EnumSet.allOf(NoticeMessageType.class);
        for (NoticeMessageType type : it) {
            if (nofifyTypes.indexOf(type.key()) <= -1) continue;
            messageTypeArrays.add(type);
        }
        NoticeMessageType[] messageTypes = new NoticeMessageType[messageTypeArrays.size()];
        messageTypeArrays.toArray(messageTypes);
        return messageTypes;
    }
}

