/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.controller;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.controller.BaseController2;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.StringUtil;
import com.hotent.portal.model.MessageRead;
import com.hotent.portal.model.SysMessage;
import com.hotent.portal.params.MessaboxVo;
import com.hotent.portal.persistence.manager.MessageReadManager;
import com.hotent.portal.persistence.manager.SysMessageManager;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import com.hotent.uc.api.service.IUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/innermsg/messageReceiver/v2"})
@Api(tags={"\u5185\u90e8\u6d88\u606f\u63a5\u65362"})
public class MessageReceiverController2
extends BaseController2 {
    @Resource
    MessageReadManager messageReadManager;
    @Resource
    SysMessageManager sysMessageManager;
    @Resource
    IUserService iUserService;

    @RequestMapping(value={"list"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d88\u606f\u5217\u8868", httpMethod="POST", notes="\u6d88\u606f\u5217\u8868")
    public CommonResult<PageList<SysMessage>> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        queryFilter.addFilter("receiverId", (Object)ContextUtil.getCurrentUserId(), QueryOP.EQUAL);
        PageList<SysMessage> sysMessageList = this.sysMessageManager.getMsgByUserId(queryFilter);
        List list = sysMessageList.getRows();
        PageList newSysMessageList = new PageList();
        newSysMessageList.setRows(list);
        newSysMessageList.setPage(sysMessageList.getPage());
        newSysMessageList.setPageSize(sysMessageList.getPageSize());
        newSysMessageList.setTotal(sysMessageList.getTotal());
        return CommonResult.ok().value((Object)newSysMessageList);
    }

    @RequestMapping(value={"edit"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d88\u606f\u7f16\u8f91\u9875\u9762\u4fe1\u606f", httpMethod="GET", notes="\u6d88\u606f\u7f16\u8f91\u9875\u9762\u4fe1\u606f")
    public CommonResult<MessageRead> edit(@ApiParam(name="id", value="\u4e3b\u952e", required=false) @RequestParam String id) throws Exception {
        MessageRead messageRead = null;
        if (StringUtil.isNotEmpty((String)id)) {
            messageRead = (MessageRead)this.messageReadManager.get((Serializable)((Object)id));
        }
        return CommonResult.ok().value(messageRead);
    }

    @RequestMapping(value={"get"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d88\u606f\u660e\u7ec6\u9875\u9762", httpMethod="GET", notes="\u6d88\u606f\u660e\u7ec6\u9875\u9762")
    public CommonResult<SysMessage> get(@ApiParam(name="id", value="\u4e3b\u952e", required=false) @RequestParam String id) throws Exception {
        SysMessage sysMessage = (SysMessage)this.sysMessageManager.get((Serializable)((Object)id));
        IUser user = ContextUtil.getCurrentUser();
        this.messageReadManager.addMessageRead(id, user);
        this.sysMessageManager.update((Model)sysMessage);
        return CommonResult.ok().value((Object)sysMessage);
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5220\u9664\u6d88\u606f\u8bb0\u5f55", httpMethod="DELETE", notes="\u5220\u9664\u6d88\u606f\u8bb0\u5f55")
    public CommonResult<String> remove(@ApiParam(name="ids", value="\u4efb\u52a1\u8bb0\u5f55ID\uff0c\u591a\u4e2a\u7528\u201c,\u201d\u53f7\u5206\u9694", required=true) @RequestParam String ids) throws Exception {
        String[] aryIds = null;
        if (!StringUtil.isEmpty((String)ids)) {
            aryIds = ids.split(",");
        }
        this.sysMessageManager.removeByIds(Arrays.asList(aryIds));
        return CommonResult.ok().message("\u5220\u9664\u6d88\u606f\u6210\u529f");
    }

    @RequestMapping(value={"getMessBoxInfo"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u5df2\u8bfb\u672a\u8bfb\u6d88\u606f", httpMethod="GET", notes="\u83b7\u53d6\u7528\u6237\u5df2\u8bfb\u672a\u8bfb\u6d88\u606f")
    public CommonResult<MessaboxVo> getMessBoxInfo(@ApiParam(name="account", value="\u7528\u6237\u8d26\u53f7", required=true) @RequestParam String account) throws Exception {
        MessaboxVo messBoxInfo = this.sysMessageManager.getMessBoxInfo(account);
        return CommonResult.ok().value((Object)messBoxInfo);
    }

    @RequestMapping(value={"mark"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6807\u8bb0\u4e3a\u5df2\u8bfb", httpMethod="GET", notes="\u6807\u8bb0\u4e3a\u5df2\u8bfb")
    public CommonResult<String> mark(@ApiParam(name="ids", value="\u4efb\u52a1\u8bb0\u5f55ID\uff0c\u591a\u4e2a\u7528\u201c,\u201d\u53f7\u5206\u9694", required=true) @RequestParam String ids) throws Exception {
        String[] aryIds = null;
        if (!StringUtil.isEmpty((String)ids)) {
            aryIds = ids.split(",");
        }
        IUser user = ContextUtil.getCurrentUser();
        for (String string : aryIds) {
            this.messageReadManager.addMessageRead(string, user);
        }
        return CommonResult.ok().message("\u6807\u8bb0\u6210\u529f");
    }

    @RequestMapping(value={"getMsgbadge"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u672a\u8bfb\u6d88\u606f\u6570\u91cf", httpMethod="GET", notes="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u672a\u8bfb\u6d88\u606f\u6570\u91cf")
    public CommonResult<Integer> getMsgbadge() throws Exception {
        int badge = this.sysMessageManager.getNotReadMsgNum(ContextUtil.getCurrentUserId());
        return CommonResult.ok().message("\u83b7\u53d6\u6210\u529f").value((Object)badge);
    }
}

