/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.controller;

import com.hotent.base.controller.BaseController;
import com.hotent.base.exception.BaseException;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.StringUtil;
import com.hotent.portal.service.appio.IAppIOService;
import com.hotent.sys.persistence.manager.AppTagsRelationManager;
import com.hotent.sys.persistence.manager.SysAppManager;
import com.hotent.sys.persistence.model.AppTagsRelation;
import com.hotent.sys.persistence.model.SysApp;
import com.hotent.sys.persistence.param.AppTenantPublishDTO;
import com.hotent.sys.persistence.param.SysAppCopyDTO;
import com.hotent.uc.api.impl.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/portal/sysApp/v1"})
@Api(tags={"sysAppController"})
public class SysAppController
extends BaseController<SysAppManager, SysApp> {
    @Resource
    AppTagsRelationManager appTagsRelationManager;
    @Resource
    IAppIOService appIOService;

    @PostMapping(value={"/query"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7ed3\u679c")
    public PageList<SysApp> query(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<SysApp> queryFilter) {
        return ((SysAppManager)this.baseService).query(queryFilter);
    }

    @PostMapping(value={"/authList"})
    @ApiOperation(value="\u83b7\u53d6\u5df2\u6388\u6743\u7684\u5e94\u7528", httpMethod="POST", notes="\u83b7\u53d6\u5df2\u6388\u6743\u7684\u5e94\u7528")
    public List<SysApp> authList(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody SysApp sysApp) throws Exception {
        return ((SysAppManager)this.baseService).queryByAuth(sysApp);
    }

    @PostMapping(value={"/queryByFilter"})
    @ApiOperation(value="\u67e5\u8be2\u5df2\u6388\u6743\u7684\u5e94\u7528", httpMethod="POST", notes="\u67e5\u8be2\u5df2\u6388\u6743\u7684\u5e94\u7528")
    public PageList<SysApp> queryByFilter(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<SysApp> queryFilter) throws Exception {
        return ((SysAppManager)this.baseService).queryByFilter(queryFilter);
    }

    @GetMapping(value={"/app/{id}"})
    @ApiOperation(value="\u67e5\u8be2\u5df2\u6388\u6743\u7684\u5e94\u7528", httpMethod="GET", notes="\u67e5\u8be2\u5df2\u6388\u6743\u7684\u5e94\u7528")
    public SysApp getAuthById(@ApiParam(name="id", value="\u5e94\u7528id") @PathVariable String id) {
        return ((SysAppManager)this.baseService).getAuthById(id);
    }

    @PostMapping(value={"/queryByTagIds/{menuId}"})
    @ApiOperation(value="\u901a\u8fc7\u6807\u7b7eID\u67e5\u8be2\u83b7\u53d6\u5df2\u6388\u6743\u7684\u5e94\u7528", httpMethod="POST", notes="\u901a\u8fc7\u6807\u7b7eID\u67e5\u8be2\u83b7\u53d6\u5df2\u6388\u6743\u5e94\u7528")
    public List<SysApp> queryByTagIds(@ApiParam(name="menuId", value="\u83dc\u5355ID") @PathVariable String menuId, @ApiParam(name="tagMaps", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody List<Map<String, String>> tagMaps) throws Exception {
        return ((SysAppManager)this.baseService).queryByTagIds(menuId, tagMaps);
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u65b0\u589e,\u66f4\u65b0\u5e94\u7528\u4fe1\u606f\u6570\u636e", httpMethod="POST", notes="\u65b0\u589e,\u66f4\u65b0portal_sys_app\u6570\u636e")
    public CommonResult<SysApp> save(@ApiParam(name="sysApp", value="\u5e94\u7528\u4fe1\u606f\u4e1a\u52a1\u5bf9\u8c61", required=true) @Validated @RequestBody SysApp sysApp) throws Exception {
        ((SysAppManager)this.baseService).createOrUpdate(sysApp);
        return new CommonResult(true, "\u4fdd\u5b58\u5e94\u7528\u4fe1\u606f\u6210\u529f", (Object)sysApp);
    }

    @PostMapping(value={"saveAndPublish"})
    @ApiOperation(value="\u65b0\u589e\u5e94\u7528\u5e76\u53d1\u5e03", httpMethod="POST", notes="\u65b0\u589e\u5e94\u7528\u5e76\u53d1\u5e03")
    public CommonResult<String> saveAndPublish(@ApiParam(name="sysApp", value="\u5e94\u7528\u4fe1\u606f\u4e1a\u52a1\u5bf9\u8c61", required=true) @RequestBody SysApp sysApp) throws Exception {
        if (StringUtil.isEmpty((String)sysApp.getMenuId())) {
            throw new BaseException("\u8bf7\u9009\u62e9\u53d1\u5e03\u7684\u83dc\u5355");
        }
        sysApp.setIsPublish(SysApp.IS_PUBLISH);
        ((SysAppManager)this.baseService).saveAndPublish(sysApp);
        return new CommonResult(true, "\u53d1\u5e03pc\u5e94\u7528\u6a21\u5757\u6210\u529f");
    }

    @DeleteMapping(value={"/remove"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5e94\u7528\u4fe1\u606f\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u5e94\u7528\u4fe1\u606f\u8bb0\u5f55")
    public CommonResult<String> removes(String ... ids) throws Exception {
        ((SysAppManager)this.baseService).removeApp(ids);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/publish"})
    @ApiOperation(value="\u53d1\u5e03\u5e94\u7528", httpMethod="POST", notes="\u53d1\u5e03\u5e94\u7528")
    public CommonResult<String> publish(@ApiParam(name="id", value="\u5e94\u7528ID", required=true) @RequestBody SysApp sysApp) throws Exception {
        String message = SysApp.IS_PUBLISH.equals(sysApp.getIsPublish()) ? "\u53d1\u5e03\u6210\u529f" : "\u53d6\u6d88\u53d1\u5e03\u6210\u529f";
        ((SysAppManager)this.baseService).publish(sysApp);
        return new CommonResult(true, message);
    }

    @PostMapping(value={"/saveAppTags/{appId}"})
    @ApiOperation(value="\u4fdd\u5b58\u5e94\u7528\u6807\u7b7e", httpMethod="POST", notes="\u4fdd\u5b58\u5e94\u7528\u6807\u7b7e")
    public CommonResult<String> saveAppTags(@ApiParam(name="appId", value="\u5e94\u7528ID", required=true) @PathVariable String appId, @ApiParam(name="tagIds", value="\u6807\u7b7eID\u96c6", required=true) @RequestBody String tagIds) {
        try {
            this.appTagsRelationManager.saveAppTags(appId, tagIds);
            return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u4fdd\u5b58\u5931\u8d25");
        }
    }

    @GetMapping(value={"/getAppTagsById/{appId}"})
    @ApiOperation(value="\u6839\u636e\u5e94\u7528ID\u83b7\u53d6\u5e94\u7528\u6807\u7b7e", httpMethod="GET", notes="\u6839\u636e\u5e94\u7528ID\u83b7\u53d6\u5e94\u7528\u6807\u7b7e")
    public CommonResult<List<AppTagsRelation>> getAppTagsById(@ApiParam(name="appId", value="\u5e94\u7528Id", required=true) @PathVariable String appId) throws Exception {
        List byAppId = this.appTagsRelationManager.getByAppId(appId);
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f", (Object)byAppId);
    }

    @GetMapping(value={"/validMenu"})
    @ApiOperation(value="\u83b7\u53d6APP\u9996\u4e2a\u6709\u5185\u5bb9\u7684\u83dc\u5355", httpMethod="GET", notes="\u83b7\u53d6APP\u9996\u4e2a\u6709\u5185\u5bb9\u7684\u83dc\u5355")
    public List<String> validMenu() throws Exception {
        return ((SysAppManager)this.baseService).getValidMenu(ContextUtil.getCurrentUserId());
    }

    @GetMapping(value={"export"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u5e94\u7528", httpMethod="GET", notes="\u5bfc\u51fa\u5e94\u7528")
    public void export(HttpServletResponse response, @ApiParam(name="ids", value="\u5e94\u7528id", required=true) @RequestParam List<String> ids, @ApiParam(name="check", value="\u68c0\u67e5\u662f\u5426\u5b58\u5728", required=true) @RequestParam String status) throws Exception {
        this.appIOService.exportApp(response, ids, status);
    }

    @RequestMapping(value={"import"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5e94\u7528\u5bfc\u5165", httpMethod="POST", notes="\u5e94\u7528\u5bfc\u5165")
    public CommonResult<String> importData(MultipartHttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.appIOService.importApp(request, response);
    }

    @RequestMapping(value={"importCheck"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5e94\u7528\u5bfc\u5165", httpMethod="POST", notes="\u5e94\u7528\u5bfc\u5165")
    public CommonResult<String> importCheck(MultipartHttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.appIOService.importCheck(request);
    }

    @PostMapping(value={"update"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u66f4\u65b0\u5e94\u7528", httpMethod="POST", notes="\u66f4\u65b0\u5e94\u7528")
    public CommonResult<String> updateApp(@RequestParam String id) {
        ((SysAppManager)this.baseService).updateApp(id);
        return new CommonResult(true, "\u66f4\u65b0\u6210\u529f");
    }

    @GetMapping(value={"hasRight"})
    @ApiOperation(value="\u662f\u5426\u62e5\u6709\u5e94\u7528\u4e2d\u5fc3\u6743\u9650", httpMethod="GET", notes="\u662f\u5426\u62e5\u6709\u5e94\u7528\u6743\u9650")
    public CommonResult<Boolean> hasRight() {
        return new CommonResult(true, "\u83b7\u53d6\u5e94\u7528\u4e2d\u5fc3\u6743\u9650", (Object)((SysAppManager)this.baseService).hasRight());
    }

    @RequestMapping(value={"batchSaveUserApp"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u66f4\u65b0\u6211\u7684\u5e94\u7528\u4fe1\u606f", httpMethod="POST", notes="\u6279\u91cf\u66f4\u65b0\u6211\u7684\u5e94\u7528\u4fe1\u606f")
    public CommonResult<String> batchSaveUserApp(@RequestBody @ApiParam(name="sysApps", value="\u5e94\u7528\u4fe1\u606f\u5217\u8868", required=true) List<SysApp> sysApps, @RequestParam @ApiParam(name="isDefault", value="\u662f\u5426\u6062\u590d\u9ed8\u8ba4", required=true) Boolean isDefault, @RequestParam @ApiParam(name="columnAlias", value="\u662f\u5426\u6062\u590d\u9ed8\u8ba4", required=true) String columnAlias) throws Exception {
        return ((SysAppManager)this.baseService).batchSaveUserApp(sysApps, isDefault, columnAlias);
    }

    @PostMapping(value={"copy"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u590d\u5236\u5e94\u7528", httpMethod="POST", notes="\u590d\u5236\u5e94\u7528")
    public CommonResult<String> updateApp(@RequestBody SysAppCopyDTO sysAppCopyDTO) {
        ((SysAppManager)this.baseService).copyApp(sysAppCopyDTO);
        return new CommonResult(true, "\u590d\u5236\u6210\u529f");
    }

    @PostMapping(value={"tenant/publish"})
    public CommonResult<String> tenantPublish(@RequestBody @Validated AppTenantPublishDTO appTenantPublish) throws Exception {
        this.appIOService.tenantPublish(appTenantPublish);
        return new CommonResult(true, "\u4e0b\u53d1\u6210\u529f");
    }

    @PostMapping(value={"tenant/publish/check"})
    public CommonResult<String> tenantPublishCheck(@RequestBody @Validated AppTenantPublishDTO appTenantPublish) throws Exception {
        return this.appIOService.tenantPublishCheck(appTenantPublish);
    }
}

