/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.controller;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.sys.persistence.manager.SysDataSourceManager;
import com.hotent.sys.persistence.model.SysDataSource;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/sys/sysDataSource/v1"})
@Api(tags={"\u6570\u636e\u6e90\u7ba1\u7406"})
@ApiGroup(group={"group_portal"})
public class SysDataSourceController
extends BaseController<SysDataSourceManager, SysDataSource> {
    @Resource
    SysDataSourceManager sysDataSourceManager;

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6570\u636e\u6e90\u5217\u8868", httpMethod="POST", notes="\u6570\u636e\u6e90\u5217\u8868")
    public PageList<SysDataSource> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<SysDataSource> queryFilter) throws Exception {
        return this.sysDataSourceManager.query(queryFilter);
    }

    @RequestMapping(value={"getJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6570\u636e\u6e90\u4fe1\u606f", httpMethod="GET", notes="\u6570\u636e\u6e90\u4fe1\u606f")
    @ResponseBody
    public SysDataSource getJson(@ApiParam(name="id", value="\u4e3b\u952e", required=true) @RequestParam String id) throws Exception {
        if (StringUtil.isEmpty((String)id)) {
            return new SysDataSource();
        }
        SysDataSource sysDataSource = (SysDataSource)this.sysDataSourceManager.get((Serializable)((Object)id));
        return sysDataSource;
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u6570\u636e\u6e90\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u6570\u636e\u6e90\u4fe1\u606f")
    public CommonResult<String> save(@ApiParam(name="sysDataSource", value="\u6570\u636e\u6e90\u5bf9\u8c61", required=true) @RequestBody SysDataSource sysDataSource) throws Exception {
        return this.sysDataSourceManager.saveSysDataSource(sysDataSource);
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u6570\u636e\u6e90", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u6570\u636e\u6e90")
    public CommonResult<String> remove(@ApiParam(name="id", value="\u4e3b\u952e", required=true) @RequestParam String ids) throws Exception {
        String[] aryIds = StringUtil.getStringAryByStr((String)ids);
        this.sysDataSourceManager.removeByIds(Arrays.asList(aryIds));
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"checkConnection"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d4b\u8bd5\u8fde\u63a5", httpMethod="POST", notes="\u6d4b\u8bd5\u8fde\u63a5")
    public CommonResult<String> checkConnection(@ApiParam(name="sysDataSource", value="\u6570\u636e\u6e90\u5bf9\u8c61", required=true) @RequestBody SysDataSource sysDataSource) throws Exception {
        boolean b = this.sysDataSourceManager.checkConnection(sysDataSource);
        String resultMsg = "";
        resultMsg = b ? sysDataSource.getName() + ":\u8fde\u63a5\u6210\u529f" : sysDataSource.getName() + ":\u8fde\u63a5\u5931\u8d25";
        return new CommonResult(b, resultMsg);
    }

    @RequestMapping(value={"getDataSources"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u6e90", httpMethod="GET", notes="\u83b7\u53d6\u6570\u636e\u6e90")
    public List<SysDataSource> getDataSources() throws Exception {
        boolean localExists;
        PageBean pageBean = new PageBean();
        pageBean.setPageSize(PageBean.WITHOUT_PAGE.intValue());
        QueryFilter queryFilter = QueryFilter.build().withPage(pageBean).withQuery(new QueryField("enabled_", (Object)1, QueryOP.EQUAL));
        PageList query = this.sysDataSourceManager.query(queryFilter);
        List result = query.getRows();
        boolean bl = localExists = CollectionUtils.isNotEmpty((Collection)result) && result.stream().anyMatch(d -> "LOCAL".equalsIgnoreCase(d.getAlias()));
        if (!localExists) {
            result.add(this.sysDataSourceManager.getDefaultDataSource());
        }
        return result;
    }

    @RequestMapping(value={"getBeanByAlias"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u522b\u540d\uff0c\u83b7\u53d6\u6570\u636e\u5e93\u7c7b\u578b", httpMethod="GET", notes="\u6839\u636e\u522b\u540d\uff0c\u83b7\u53d6\u6570\u636e\u5e93\u7c7b\u578b")
    public JsonNode getBeanByAlias(@ApiParam(name="alias", value="\u6570\u636e\u6e90\u522b\u540d", required=true) @RequestParam String alias) throws Exception {
        return JsonUtil.toJsonNode((Object)this.sysDataSourceManager.getByAlias(alias));
    }

    @RequestMapping(value={"export"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u6570\u636e\u6e90", httpMethod="GET", notes="\u5bfc\u51fa\u6570\u636e\u6e90")
    public void export(HttpServletResponse response, HttpServletRequest request, @ApiParam(name="ids", value="ids", required=true) @RequestParam String ids) throws Exception {
        String[] idList = ids.split(",");
        String fileName = "sysDataSource_" + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy_MMdd_HHmm");
        String json = ((SysDataSourceManager)this.baseService).export(idList);
        HttpUtil.downLoadFile((HttpServletRequest)request, (HttpServletResponse)response, (String)json, (String)"sysDataSource.json", (String)fileName);
    }

    @RequestMapping(value={"import"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165\u6570\u636e\u6e90", httpMethod="POST", notes="\u5bfc\u5165\u6570\u636e\u6e90")
    public CommonResult<String> importIdentity(MultipartHttpServletRequest request, HttpServletResponse response) throws Exception {
        CommonResult res = this.sysDataSourceManager.importIdentity(request, response);
        return res;
    }
}

