/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.portal.model.SysIndexLayoutManage;
import com.hotent.portal.params.IndexLayoutVo;
import com.hotent.portal.persistence.manager.SysIndexLayoutManageManager;
import io.jsonwebtoken.lang.Assert;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/portal/sysIndexLayoutManage/sysIndexLayoutManage/v1"})
@Api(tags={"\u95e8\u6237\u5e03\u5c40\u7ba1\u7406"})
@ApiGroup(group={"group_portal"})
public class SysIndexLayoutManageController
extends BaseController<SysIndexLayoutManageManager, SysIndexLayoutManage> {
    @Resource
    private SysIndexLayoutManageManager sysIndexLayoutManageService;
    @Value(value="${system.saas.enable:false}")
    Boolean saasEnable;

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d6\u5f97\u5e03\u5c40\u7ba1\u7406\u5206\u9875\u5217\u8868", httpMethod="POST", notes="\u53d6\u5f97\u5e03\u5c40\u7ba1\u7406\u5206\u9875\u5217\u8868")
    public PageList<SysIndexLayoutManage> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<SysIndexLayoutManage> queryFilter) throws Exception {
        return this.sysIndexLayoutManageService.listJson(queryFilter);
    }

    @RequestMapping(value={"getSysDefaultLayout"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7cfb\u7edf\u9ed8\u8ba4\u7684\u5e03\u5c40", httpMethod="POST", notes="\u83b7\u53d6\u7cfb\u7edf\u9ed8\u8ba4\u7684\u5e03\u5c40")
    public PageList<SysIndexLayoutManage> getSysDefaultLayout(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<SysIndexLayoutManage> queryFilter) throws Exception {
        queryFilter.addFilter("IS_DEF", (Object)1, QueryOP.EQUAL);
        return this.sysIndexLayoutManageService.query(queryFilter);
    }

    @RequestMapping(value={"getByAlias"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7\u522b\u540d\u83b7\u53d6\u5e03\u5c40\u4fe1\u606f", httpMethod="GET", notes="\u901a\u8fc7\u522b\u540d\u83b7\u53d6\u5e03\u5c40\u4fe1\u606f")
    @ResponseBody
    public List<SysIndexLayoutManage> getByAlias(@ApiParam(name="alias", value="\u5e03\u5c40\u522b\u540d") @RequestParam List<String> alias) throws Exception {
        Assert.isTrue((boolean)BeanUtils.isNotEmpty(alias), (String)"\u5e03\u5c40\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        SysIndexLayoutManage defaultFront = this.sysIndexLayoutManageService.getDataByAlias("default_front", (Boolean)true);
        List<SysIndexLayoutManage> layoutByAlias = this.sysIndexLayoutManageService.getDataByAlias(alias, (Boolean)false);
        if (BeanUtils.isNotEmpty((Object)((Object)defaultFront)) && !layoutByAlias.isEmpty()) {
            layoutByAlias.get(0).setAdminLayout(defaultFront.getLayoutConfig());
        }
        return layoutByAlias;
    }

    @RequestMapping(value={"getJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7id\u53d6\u5f97\u5e03\u5c40\u7ba1\u7406\u5206\u9875\u5217\u8868", httpMethod="GET", notes="\u901a\u8fc7id\u53d6\u5f97\u5e03\u5c40\u7ba1\u7406\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SysIndexLayoutManage getJson(@ApiParam(name="id", value="\u4e3b\u952eid") @RequestParam String id) throws Exception {
        return (SysIndexLayoutManage)this.sysIndexLayoutManageService.get((Serializable)((Object)id));
    }

    @RequestMapping(value={"getLayoutManageAliasByIds"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636eids\u83b7\u53d6\u522b\u540d\u5217\u8868", httpMethod="POST", notes="\u6839\u636eids\u83b7\u53d6\u522b\u540d\u5217\u8868")
    public List<String> getLayoutManageAliasByIds(@ApiParam(name="ids", value="ids") @RequestBody List<String> ids) throws Exception {
        return this.sysIndexLayoutManageService.getAliasByIds(ids);
    }

    @RequestMapping(value={"getDisabledLayoutManageAlias"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u505c\u7528\u7684\u95e8\u6237\u522b\u540d", httpMethod="GET", notes="\u83b7\u53d6\u505c\u7528\u7684\u95e8\u6237\u522b\u540d")
    public List<String> getDisabledLayoutManageAlias() throws Exception {
        return this.sysIndexLayoutManageService.getDisabledLayoutManageAlias();
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5220\u9664\u5e03\u5c40\u7ba1\u7406", httpMethod="DELETE", notes="\u5220\u9664\u5e03\u5c40\u7ba1\u7406")
    public CommonResult<String> remove(@ApiParam(name="ids", value="\u4e3b\u952e", required=true) @RequestParam String ids) throws Exception {
        CommonResult<String> res = this.sysIndexLayoutManageService.delete(ids);
        return res;
    }

    @RequestMapping(value={"design"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8bbe\u8ba1\u9996\u9875\u5e03\u5c40", httpMethod="GET", notes="\u8bbe\u8ba1\u9996\u9875\u5e03\u5c40")
    public Map<String, Object> design(@ApiParam(name="id", value="\u4e3b\u952e", required=false) @RequestParam String id, @ApiParam(name="layoutType", value="\u90e8\u95e8id", required=false) @RequestParam short layoutType) throws Exception {
        Map<String, Object> res = this.sysIndexLayoutManageService.design(id, layoutType);
        return res;
    }

    @RequestMapping(value={"saveLayout"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u9996\u9875\u5e03\u5c40", httpMethod="POST", notes="\u4fdd\u5b58\u9996\u9875\u5e03\u5c40")
    public CommonResult<String> saveLayout(@ApiParam(name="indexLayout", value="\u6570\u636e\u6e90\u5bf9\u8c61", required=true) @RequestBody SysIndexLayoutManage indexLayout) throws Exception {
        CommonResult<String> res = this.sysIndexLayoutManageService.saveLayout(indexLayout);
        return res;
    }

    @RequestMapping(value={"setShareToSub"}, method={RequestMethod.GET})
    @ApiOperation(value="\u8bbe\u7f6e\u662f\u5426\u5171\u4eab\u7ed9\u5b50\u90e8\u95e8", httpMethod="GET", notes="\u8bbe\u7f6e\u662f\u5426\u5171\u4eab\u7ed9\u5b50\u90e8\u95e8")
    public CommonResult<String> setShareToSub(@ApiParam(name="id", value="\u4e3b\u952e", required=true) @RequestParam String id, @ApiParam(name="shareToSub", required=true) @RequestParam Short shareToSub) throws Exception {
        try {
            SysIndexLayoutManage layout = (SysIndexLayoutManage)this.sysIndexLayoutManageService.get((Serializable)((Object)id));
            layout.setShareToSub(shareToSub);
            this.sysIndexLayoutManageService.update((Model)layout);
            return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", null);
        }
        catch (Exception ex) {
            return new CommonResult(false, "\u64cd\u4f5c\u5931\u8d25" + ex.getMessage(), null);
        }
    }

    @RequestMapping(value={"enable"}, method={RequestMethod.GET})
    @ApiOperation(value="\u8bbe\u7f6e\u542f\u7528/\u505c\u7528", httpMethod="GET", notes="\u8bbe\u7f6e\u542f\u7528/\u505c\u7528")
    public CommonResult<String> enable(@ApiParam(name="id", value="\u4e3b\u952e", required=true) @RequestParam String id, @ApiParam(name="enable", required=true) @RequestParam Short enable) throws Exception {
        this.sysIndexLayoutManageService.setEnable(id, enable);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", null);
    }

    @RequestMapping(value={"asTemplate"}, method={RequestMethod.GET})
    @ApiOperation(value="", httpMethod="GET", notes="\u8bbe\u7f6e\u542f\u7528/\u505c\u7528")
    public CommonResult<String> asTemplate(@ApiParam(name="id", value="\u4e3b\u952e", required=true) @RequestParam String id, @ApiParam(name="asTemplate", required=true) @RequestParam Short asTemplate) throws Exception {
        this.sysIndexLayoutManageService.setAsTemplate(id, asTemplate);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", null);
    }

    @PostMapping(value={"exportDefaultLayout"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636eid\u96c6\u5408\u5bfc\u51fa\u5e03\u5c40", httpMethod="POST", notes="\u6839\u636eid\u96c6\u5408\u5bfc\u51fa\u5e03\u5c40")
    public void exportDefaultLayout(@ApiParam(name="ids", value="id\u96c6\u5408") @RequestBody List<String> ids, HttpServletRequest request, HttpServletResponse response, @RequestParam(required=false) boolean isDefault) throws Exception {
        String filePrefix = isDefault ? "defaultLayout" : "orgLayout";
        String fileName = filePrefix + "_" + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy_MM_dd_HHmm");
        Map<String, Object> map = ((SysIndexLayoutManageManager)this.baseService).exportDefaultLayout(ids, isDefault);
        HttpUtil.downLoadFile((HttpServletResponse)response, map, (String)fileName);
    }

    @PostMapping(value={"importDefaultLayout"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165\u5e03\u5c40", httpMethod="POST", notes="\u5bfc\u5165\u5e03\u5c40")
    public CommonResult<String> importDefaultLayout(@RequestParam String cacheFileId) throws Exception {
        return this.sysIndexLayoutManageService.importDefaultLayout(cacheFileId);
    }

    @PostMapping(value={"importDefaultLayoutCheck"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u68c0\u67e5\u5bfc\u5165\u5e03\u5c40\u662f\u5426\u91cd\u590d", httpMethod="POST", notes="\u68c0\u67e5\u5bfc\u5165\u5e03\u5c40\u662f\u5426\u91cd\u590d")
    public CommonResult<String> importDefaultLayoutCheck(MultipartHttpServletRequest request) {
        return this.sysIndexLayoutManageService.importDefaultLayoutCheck(request);
    }

    @RequestMapping(value={"checkKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u68c0\u67e5\u522b\u540d\u662f\u5426\u5b58\u5728", httpMethod="GET", notes="\u68c0\u67e5\u522b\u540d\u662f\u5426\u5b58\u5728")
    public boolean checkKey(@ApiParam(name="key", value="\u8868\u5355key") @RequestParam String key) throws Exception {
        List<SysIndexLayoutManage> layouts = ((SysIndexLayoutManageManager)this.baseService).getByAlias(key);
        return layouts.size() > 0;
    }

    @RequestMapping(value={"saveCopy"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u590d\u5236\u5e03\u5c40\u4fe1\u606f", httpMethod="POST", notes="\u590d\u5236\u5e03\u5c40\u4fe1\u606f")
    public CommonResult saveCopy(@ApiParam(name="layout", value="\u5e03\u5c40\u6570\u636e\u5bf9\u8c61") @RequestBody SysIndexLayoutManage layout) throws Exception {
        CommonResult res = this.sysIndexLayoutManageService.saveCopy(layout);
        return res;
    }

    @RequestMapping(value={"getCurrentAuthLayout"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u6709\u6743\u9650\u95e8\u6237(\u5305\u542b\u7cfb\u7edf\u9ed8\u8ba4\u95e8\u6237)", httpMethod="GET", notes="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u6709\u6743\u9650\u95e8\u6237(\u5305\u542b\u7cfb\u7edf\u9ed8\u8ba4\u95e8\u6237)")
    public List<IndexLayoutVo> getCurrentAuthLayout(@ApiParam(name="from", value="\u6765\u6e90\uff08manage\u3001front\u3001mobile\uff09", required=true) @RequestParam Optional<String> from) {
        List<IndexLayoutVo> res = this.sysIndexLayoutManageService.getCurrentAuthLayout(from);
        return res;
    }

    @PostMapping(value={"importDatav"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165\u5927\u5c4f", httpMethod="POST", notes="\u5bfc\u5165\u5927\u5c4f")
    public CommonResult importDatav(MultipartHttpServletRequest request, @RequestParam String orgId, @RequestParam boolean isDefault) throws Exception {
        CommonResult<String> res = this.sysIndexLayoutManageService.importDatav(request, orgId, isDefault);
        return res;
    }

    @RequestMapping(value={"confirmImportData"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165\u5927\u5c4f", httpMethod="POST", notes="\u5bfc\u5165\u5927\u5c4f")
    public CommonResult<String> confirmImportData(@ApiParam(name="unZipFilePath", value="unZipFilePath", required=true) @RequestParam String unZipFilePath, @ApiParam(name="status", value="status", required=true) @RequestParam String status) throws Exception {
        CommonResult<String> res = this.sysIndexLayoutManageService.confirmImportData(unZipFilePath, status);
        return res;
    }

    @GetMapping(value={"/saveManager"})
    @ApiOperation(value="\u4fdd\u5b58\u7ba1\u7406\u5458", httpMethod="GET", notes="saveManager")
    public CommonResult<String> saveManager(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @RequestParam String id, @ApiParam(name="userId", value="\u7ba1\u7406\u5458userId", required=true) @RequestParam String userId, @ApiParam(name="fullname", value="\u7ba1\u7406\u5458\u540d\u79f0", required=true) @RequestParam String fullname) throws Exception {
        ((SysIndexLayoutManageManager)this.baseService).update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(SysIndexLayoutManage::getManagerId, (Object)userId)).set(SysIndexLayoutManage::getManagerName, (Object)fullname)).eq(SysIndexLayoutManage::getId, (Object)id));
        return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f");
    }
}

