/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.controller;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.cache.annotation.CacheEvict;
import com.hotent.base.controller.BaseController;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.sys.persistence.manager.SysSignetManager;
import com.hotent.sys.persistence.model.SysSignet;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.time.LocalDateTime;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/sys/sysSignet/v1"})
@Api(tags={"\u5370\u7ae0\u7ba1\u7406"})
@ApiGroup(group={"group_portal"})
public class SysSignetController
extends BaseController<SysSignetManager, SysSignet> {
    @Resource
    SysSignetManager sysSignetManager;

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5370\u7ae0\u5217\u8868", httpMethod="POST", notes="\u5370\u7ae0\u5217\u8868")
    public PageList<SysSignet> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<SysSignet> queryFilter) throws Exception {
        return this.sysSignetManager.query(queryFilter);
    }

    @RequestMapping(value={"getJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5370\u7ae0\u660e\u7ec6\u9875\u9762", httpMethod="GET", notes="\u5370\u7ae0\u660e\u7ec6\u9875\u9762")
    @ResponseBody
    public SysSignet getJson(@ApiParam(name="id", value="\u4e3b\u952e", required=true) @RequestParam String id) throws Exception {
        SysSignet sysSignet = new SysSignet();
        if (StringUtil.isNotEmpty((String)id)) {
            sysSignet = (SysSignet)this.sysSignetManager.get((Serializable)((Object)id));
        }
        return sysSignet;
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u5370\u7ae0\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u5370\u7ae0\u4fe1\u606f")
    public CommonResult<String> save(@ApiParam(name="sysSignet", value="\u5370\u7ae0", required=true) @RequestBody @Valid SysSignet sysSignet) throws Exception {
        String resultMsg = "";
        if (StringUtil.isEmpty((String)sysSignet.getId())) {
            if (BeanUtils.isNotEmpty((Object)this.sysSignetManager.getByAlias(sysSignet.getAlias()))) {
                return new CommonResult(false, "\u522b\u540d\u3010" + sysSignet.getAlias() + "\u3011\u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u522b\u540d\u3002");
            }
            sysSignet.setId(UniqueIdUtil.getSuid());
            this.sysSignetManager.create((Model)sysSignet);
            resultMsg = "\u6dfb\u52a0\u5370\u7ae0\u6210\u529f";
        } else {
            this.sysSignetManager.update((Model)sysSignet);
            resultMsg = "\u66f4\u65b0\u5370\u7ae0\u6210\u529f";
        }
        return new CommonResult(true, resultMsg);
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5370\u7ae0\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u5370\u7ae0\u8bb0\u5f551,2,3")
    @CacheEvict(value={"eip:sys:props"}, allEntries=true)
    public CommonResult<String> remove(@ApiParam(name="id", value="\u4e3b\u952e", required=true) @RequestParam String ids) throws Exception {
        String[] aryIds = StringUtil.getStringAryByStr((String)ids);
        this.sysSignetManager.removeByIds(aryIds);
        return new CommonResult(true, "\u5220\u9664\u5370\u7ae0\u6210\u529f");
    }

    @RequestMapping(value={"getByAlias"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u522b\u540d\u83b7\u53d6\u5370\u7ae0\u4fe1\u606f\u3002", httpMethod="GET", notes="\u6839\u636e\u522b\u540d\u83b7\u53d6\u5370\u7ae0\u4fe1\u606f")
    public SysSignet getByAlias(@ApiParam(name="alias", value="\u5370\u7ae0\u522b\u540d", required=true) @RequestParam String alias) throws Exception {
        return this.sysSignetManager.getByAlias(alias);
    }

    @RequestMapping(value={"export"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u6570\u636e", httpMethod="GET", notes="\u5bfc\u51fa\u6570\u636e")
    public void export(HttpServletResponse response, HttpServletRequest request, @ApiParam(name="ids", value="ids", required=true) @RequestParam String ids) throws Exception {
        String[] idList = ids.split(",");
        String fileName = "signet_" + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy_MMdd_HHmm");
        String json = this.sysSignetManager.export(idList);
        HttpUtil.downLoadFile((HttpServletRequest)request, (HttpServletResponse)response, (String)json, (String)"signet.json", (String)fileName);
    }

    @RequestMapping(value={"import"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165\u5370\u7ae0", httpMethod="POST", notes="\u5bfc\u5165\u5370\u7ae0")
    public CommonResult<String> importIdentity(MultipartHttpServletRequest request, HttpServletResponse response) throws Exception {
        CommonResult res = this.sysSignetManager.importIdentity(request, response);
        return res;
    }

    @RequestMapping(value={"confirmImport"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165\u5370\u7ae0", httpMethod="POST", notes="\u786e\u8ba4\u5bfc\u5165\u5370\u7ae0\u7684\u884c\u4e3a")
    public CommonResult<String> confirmImportIdentity(@RequestParam String unZipFilePath, @RequestParam String status) throws Exception {
        CommonResult res = this.sysSignetManager.confirmImportIdentity(unZipFilePath, status);
        return res;
    }
}

