/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.jms.impl;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.jms.JmsHandler;
import com.hotent.base.jms.JmsMessage;
import com.hotent.base.jms.NoticeMessageType;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.portal.model.MsgTemplate;
import com.hotent.portal.persistence.manager.MessageLogManager;
import com.hotent.portal.persistence.manager.MsgTemplateManager;
import com.hotent.portal.service.impl.TemplateServiceImpl;
import com.hotent.portal.util.FlyBookUtil;
import com.hotent.portal.util.JmsHandlerUtil;
import com.hotent.system.model.SysExternalUnite;
import com.hotent.system.persistence.manager.ContactHttpManager;
import com.hotent.system.persistence.manager.SysExternalUniteManager;
import com.hotent.system.util.ExtUniUtil;
import com.hotent.uc.api.service.IUserService;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FlyBookHandler
implements JmsHandler {
    private static final Logger logger = LoggerFactory.getLogger(FlyBookHandler.class);
    @Resource
    MessageLogManager messageLogManager;
    @Resource
    SysExternalUniteManager sysExternalUniteManager;
    @Resource
    MsgTemplateManager msgTemplateManager;
    @Resource
    TemplateServiceImpl templateServiceImpl;
    @Resource
    UCFeignService ucFeignService;
    @Resource
    ContactHttpManager contactHttpManager;
    @Resource
    IUserService userService;

    public String getType() {
        return NoticeMessageType.FLYBOOK.key();
    }

    public String getTitle() {
        return "\u98de\u4e66\u6d88\u606f";
    }

    public boolean getIsDefault() {
        return false;
    }

    public boolean getSupportHtml() {
        return true;
    }

    public boolean send(JmsMessage jmsMessage) {
        try {
            SysExternalUnite dingtalkUnite;
            List receivers = jmsMessage.getReceivers();
            String content = jmsMessage.getContent();
            content = content.replace("<p>", "");
            content = content.replace("</p>", "");
            jmsMessage.setContent(content);
            MsgTemplate msgTemplate = this.msgTemplateManager.getByKey(jmsMessage.getTemplateAlias());
            if (BeanUtils.isNotEmpty((Object)((Object)msgTemplate))) {
                jmsMessage.getExtendVars().put("templateType", msgTemplate.getTypeKey());
            }
            if (BeanUtils.isEmpty((Object)(dingtalkUnite = this.sysExternalUniteManager.getFlyBook()))) {
                this.messageLogManager.handLogByMsgHander(jmsMessage, false, "\u96c6\u6210\u4e2d\u5fc3\u65e0\u76f8\u5173\u914d\u7f6e");
                return false;
            }
            List<String> users = JmsHandlerUtil.jmsActor2UserId(receivers);
            if (CollectionUtils.isEmpty(users)) {
                this.messageLogManager.handLogByMsgHander(jmsMessage, false, "\u65e0\u6d88\u606f\u63a5\u6536\u4eba");
                return false;
            }
            List userIds = this.ucFeignService.getFlyBookIdsByUserIds(String.join((CharSequence)",", users));
            if (CollectionUtils.isEmpty((Collection)userIds)) {
                this.messageLogManager.handLogByMsgHander(jmsMessage, false, "\u7528\u6237\u6570\u636e\u672a\u7ed1\u5b9a\uff0c\u8bf7\u5148\u540c\u6b65\u901a\u8baf\u5f55");
                return false;
            }
            String cardContent = msgTemplate == null ? jmsMessage.getContent() : MessageFormat.format(" **{0}** \\r\\n {1}", msgTemplate.getSubject().replace("\n", "\\r\\n"), this.templateServiceImpl.parsePlainContent(msgTemplate, jmsMessage.getExtendVars()).replace("\n", "\\r\\n"));
            cardContent = ExtUniUtil.takeOutHtmlTab((String)cardContent);
            String url = FlyBookUtil.renderMobileUrl(jmsMessage);
            String title = StringUtil.isEmpty((String)jmsMessage.getSubject()) ? "EIP\u6d88\u606f" : jmsMessage.getSubject();
            String contentJson = this.renderMessage(title, cardContent, url);
            ObjectNode response = this.contactHttpManager.sendCardMessage(userIds, contentJson);
            if (response == null || !response.has("code") || response.get("code").asInt() != 0) {
                logger.error("\u53d1\u9001\u98de\u4e66\u5361\u7247\u4fe1\u606f\u5931\u8d25\uff01" + response);
                this.messageLogManager.handLogByMsgHander(jmsMessage, false, JsonUtil.toJson((Object)response));
                return false;
            }
            this.messageLogManager.handLogByMsgHander(jmsMessage, true, JsonUtil.toJson((Object)response));
            return true;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            this.messageLogManager.handLogByMsgHander(jmsMessage, false, ex.getMessage());
            return false;
        }
    }

    private String renderMessage(String title, String content, String url) throws Exception {
        String result = "{  \"config\": {    \"wide_screen_mode\": true  },  \"header\": {    \"template\": \"blue\",    \"title\": {      \"tag\": \"plain_text\",      \"content\": \"" + title + "\"    }  },  \"elements\": [    {      \"tag\": \"div\",      \"fields\": [        {          \"is_short\": true,          \"text\": {            \"tag\": \"lark_md\",            \"content\": \"" + content + "\"          }        }      ]    }";
        if (StringUtil.isNotEmpty((String)url)) {
            result = result + ",    {      \"actions\": [        {          \"tag\": \"button\",          \"text\": {            \"content\": \"\u67e5\u770b\u8be6\u60c5\",            \"tag\": \"plain_text\"          },          \"type\": \"primary\",          \"url\": \"" + url + "\"        }      ],      \"tag\": \"action\"    }";
        }
        result = result + "  ]}";
        return result;
    }
}

