/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.jms.impl;

import com.hotent.base.jms.JmsActor;
import com.hotent.base.jms.JmsHandler;
import com.hotent.base.jms.JmsMessage;
import com.hotent.base.jms.NoticeMessageType;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.base.vo.ClientInfo;
import com.hotent.portal.jms.impl.AppPushHandler;
import com.hotent.portal.model.AppPushContent;
import com.hotent.portal.model.MsgTemplate;
import com.hotent.portal.model.SysExecutor;
import com.hotent.portal.persistence.manager.MessageLogManager;
import com.hotent.portal.persistence.manager.MsgTemplateManager;
import com.hotent.portal.persistence.manager.SysMessageManager;
import com.hotent.portal.service.impl.TemplateServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class InnerHandler
implements JmsHandler {
    private static final Logger logger = LoggerFactory.getLogger(InnerHandler.class);
    @Resource
    SysMessageManager sysMessageManager;
    @Resource
    MessageLogManager messageLogManager;
    @Resource
    AppPushHandler appPushHandler;
    @Resource
    MsgTemplateManager msgTemplateManager;
    @Resource
    TemplateServiceImpl templateServiceImpl;

    public String getType() {
        return NoticeMessageType.INNER.key();
    }

    public boolean send(JmsMessage jmsMessage) {
        try {
            List receivers = jmsMessage.getReceivers();
            ArrayList<SysExecutor> list = new ArrayList<SysExecutor>();
            for (JmsActor actor : receivers) {
                SysExecutor executor = new SysExecutor(actor.getId(), actor.getName(), SysExecutor.TYPE_USER);
                list.add(executor);
            }
            if (BeanUtils.isEmpty(list)) {
                return false;
            }
            String senderId = null;
            String senderName = null;
            JmsActor sender = jmsMessage.getSender();
            if (BeanUtils.isNotEmpty((Object)sender)) {
                senderId = sender.getId();
                senderName = sender.getName();
            }
            this.sysMessageManager.sendMsg(jmsMessage.getSubject(), jmsMessage.getContent(), jmsMessage.getType(), senderId, senderName, list);
            String content = jmsMessage.getContent();
            if (StringUtil.isNotEmpty((String)jmsMessage.getTemplateAlias())) {
                MsgTemplate msgTemplate = this.msgTemplateManager.getByKey(jmsMessage.getTemplateAlias());
                if (BeanUtils.isNotEmpty((Object)((Object)msgTemplate))) {
                    jmsMessage.getExtendVars().put("templateType", msgTemplate.getTypeKey());
                }
                this.templateServiceImpl.parsePlainContent(msgTemplate, jmsMessage.getExtendVars());
            }
            Map vars = jmsMessage.getExtendVars();
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (vars != null && vars.size() > 0) {
                params.put("taskId", vars.getOrDefault("taskId", ""));
                params.put("instId", vars.getOrDefault("instId", ""));
                params.put("templateType", vars.getOrDefault("templateType", ""));
                params.put("templateAlias", jmsMessage.getTemplateAlias());
            }
            for (JmsActor actor : receivers) {
                if (!BeanUtils.isNotEmpty((Object)actor.getClientId())) continue;
                this.appPushHandler.pushIndexMsgToSingle(new ClientInfo(actor.getClientId(), actor.getClientToken()), new AppPushContent(jmsMessage.getSubject(), content, params));
            }
            this.messageLogManager.handLogByMsgHander(jmsMessage, true, "");
            return true;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            this.messageLogManager.handLogByMsgHander(jmsMessage, false, ex.getMessage());
            return false;
        }
    }

    public String getTitle() {
        return "\u5185\u90e8\u6d88\u606f";
    }

    public boolean getIsDefault() {
        return true;
    }

    public boolean getSupportHtml() {
        return false;
    }
}

