/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.jms.impl;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.dyvmsapi.model.v20170525.SingleCallByTtsRequest;
import com.aliyuncs.dyvmsapi.model.v20170525.SingleCallByTtsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.hotent.base.jms.JmsActor;
import com.hotent.base.jms.JmsHandler;
import com.hotent.base.jms.JmsMessage;
import com.hotent.base.jms.NoticeMessageType;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.portal.model.AlidayuSetting;
import com.hotent.portal.model.MsgTemplate;
import com.hotent.portal.persistence.manager.MessageLogManager;
import com.hotent.portal.persistence.manager.MsgTemplateManager;
import com.hotent.portal.util.TaoBaoUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VoiceHandler
implements JmsHandler {
    private static final Logger logger = LoggerFactory.getLogger(VoiceHandler.class);
    @Autowired
    AlidayuSetting alidayuSetting;
    @Resource
    MessageLogManager messageLogManager;
    @Resource
    MsgTemplateManager msgTemplateManager;

    public String getType() {
        return NoticeMessageType.VOICE.key();
    }

    public boolean send(JmsMessage jmsMessage) {
        try {
            List recievers = jmsMessage.getReceivers();
            String content = jmsMessage.getContent();
            String templateCode = jmsMessage.getVoiceTemplateNo();
            if (StringUtil.isEmpty((String)templateCode) && StringUtil.isNotEmpty((String)jmsMessage.getTemplateAlias())) {
                MsgTemplate msgTemplate = this.msgTemplateManager.getByKey(jmsMessage.getTemplateAlias());
                templateCode = msgTemplate.getSmsTemplateNo();
            }
            String calledShowNum = this.alidayuSetting.getCalledShowNum();
            if (StringUtil.isEmpty((String)content) || BeanUtils.isEmpty((Object)recievers)) {
                return false;
            }
            System.setProperty("sun.net.client.defaultConnectTimeout", "10000");
            System.setProperty("sun.net.client.defaultReadTimeout", "10000");
            DefaultProfile profile = DefaultProfile.getProfile((String)"cn-hangzhou", (String)this.alidayuSetting.getAppkey(), (String)this.alidayuSetting.getSecret());
            DefaultProfile.addEndpoint((String)"cn-hangzhou", (String)"cn-hangzhou", (String)"Dysmsapi", (String)this.alidayuSetting.getUrl());
            DefaultAcsClient acsClient = new DefaultAcsClient((IClientProfile)profile);
            for (JmsActor user : recievers) {
                if (StringUtil.isEmpty((String)user.getMobile())) continue;
                SingleCallByTtsRequest request = new SingleCallByTtsRequest();
                request.setCalledShowNumber(calledShowNum);
                request.setCalledNumber(user.getMobile());
                request.setTtsCode(templateCode);
                jmsMessage.getExtendVars().remove("baseUrl");
                ArrayList parms = new ArrayList(jmsMessage.getExtendVars().keySet());
                jmsMessage.setParms(parms);
                String parmString = TaoBaoUtil.buildParams(jmsMessage);
                request.setTtsParam(parmString);
                request.setVolume(Integer.valueOf(100));
                request.setPlayTimes(Integer.valueOf(3));
                SingleCallByTtsResponse singleCallByTtsResponse = (SingleCallByTtsResponse)acsClient.getAcsResponse((AcsRequest)request);
                if (singleCallByTtsResponse.getCode() == null || !singleCallByTtsResponse.getCode().equals("OK")) continue;
                logger.debug(String.format("\u8bed\u97f3\u6587\u672c\u5916\u547c: RequestId=%s, Code=%s, Message=%s, CallId=%s", singleCallByTtsResponse.getRequestId(), singleCallByTtsResponse.getCode(), singleCallByTtsResponse.getMessage(), singleCallByTtsResponse.getCallId()));
            }
            this.messageLogManager.handLogByMsgHander(jmsMessage, true, "");
            return true;
        }
        catch (ClientException e) {
            logger.error(e.getMessage());
            this.messageLogManager.handLogByMsgHander(jmsMessage, false, e.getMessage());
            return false;
        }
    }

    public String getTitle() {
        return "\u7535\u8bdd\u8bed\u97f3";
    }

    public boolean getIsDefault() {
        return false;
    }

    public boolean getSupportHtml() {
        return false;
    }
}

