/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.job;

import cn.hutool.core.collection.CollUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.exception.BaseException;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.jms.JmsActor;
import com.hotent.base.jms.JmsHandler;
import com.hotent.base.jms.JmsMessage;
import com.hotent.base.jms.NoticeMessageType;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.job.model.BaseJob;
import com.hotent.portal.jms.impl.MailHandler;
import com.hotent.portal.model.MsgTemplate;
import com.hotent.portal.model.dto.MailJobParamDTO;
import com.hotent.portal.persistence.manager.MsgTemplateManager;
import com.hotent.portal.service.TemplateService;
import com.hotent.sys.persistence.manager.SysPropertiesManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;

public class MailJob
extends BaseJob {
    private static final NoticeMessageType NOTICE_MESSAGE_TYPE = NoticeMessageType.MAIL;
    @Resource
    MsgTemplateManager msgTemplateManager;
    @Resource
    TemplateService templateService;
    @Resource
    SysPropertiesManager sysPropertiesManager;
    @Resource
    UCFeignService ucFeignService;

    public void executeJob(JobExecutionContext context) throws Exception {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        String templateAlias = jobDataMap.getString("\uff01\u90ae\u4ef6\u6a21\u677f\u522b\u540d");
        if (StringUtil.isEmpty((String)templateAlias)) {
            throw new BaseException("\u6a21\u677f\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        MsgTemplate msgTemplate = this.msgTemplateManager.getByKey(templateAlias);
        if (msgTemplate == null) {
            throw new BaseException(String.format("\u6a21\u677f\u522b\u540d[%s]\u627e\u4e0d\u5230\uff01", templateAlias));
        }
        MailJobParamDTO mailJobParamDTO = this.convertParams(jobDataMap);
        if (CollUtil.isEmpty(mailJobParamDTO.getToActors())) {
            throw new BaseException("\u63a5\u6536\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Map<String, Object> vars = this.getVars(mailJobParamDTO.getToActors());
        String subject = this.templateService.parseSubject(msgTemplate, vars);
        String content = this.templateService.parseHtmlContent(msgTemplate, vars);
        JmsMessage jmsMessage = new JmsMessage();
        jmsMessage.setTemplateAlias(templateAlias);
        jmsMessage.setType(NOTICE_MESSAGE_TYPE.key());
        jmsMessage.setSubject(subject);
        jmsMessage.setContent(content);
        jmsMessage.setReceivers(mailJobParamDTO.getToActors());
        jmsMessage.setCcUsers(mailJobParamDTO.getCcActors());
        JmsHandler mailHandler = (JmsHandler)AppUtil.getBean(MailHandler.class);
        mailHandler.send(jmsMessage);
    }

    private MailJobParamDTO convertParams(JobDataMap jobDataMap) {
        ArrayNode usersTemp;
        MailJobParamDTO paramDTO;
        String orgCodesData = jobDataMap.getString("\u63a5\u6536\u4eba\u7ec4\u7ec7\u7f16\u53f7");
        String postCodesData = jobDataMap.getString("\u63a5\u6536\u4eba\u5c97\u4f4d\u7f16\u53f7");
        String roleCodesData = jobDataMap.getString("\u63a5\u6536\u4eba\u89d2\u8272\u7f16\u53f7");
        String mailsData = jobDataMap.getString("\u63a5\u6536\u4eba\u90ae\u7bb1\u5730\u5740");
        String accountsData = jobDataMap.getString("\u63a5\u6536\u4eba\u8d26\u53f7");
        ArrayNode users = JsonUtil.createArrayNode();
        ArrayNode usersCc = JsonUtil.createArrayNode();
        if (StringUtil.isNotEmpty((String)accountsData)) {
            paramDTO = this.parseJobParam(accountsData);
            if (StringUtil.isNotEmpty((String)paramDTO.getTo()) && BeanUtils.isNotEmpty((Object)(usersTemp = this.ucFeignService.getUserByAccounts(paramDTO.getTo())))) {
                users.addAll(usersTemp);
            }
            if (StringUtil.isNotEmpty((String)paramDTO.getCc()) && BeanUtils.isNotEmpty((Object)(usersTemp = this.ucFeignService.getUserByAccounts(paramDTO.getCc())))) {
                usersCc.addAll(usersTemp);
            }
        }
        if (StringUtil.isNotEmpty((String)orgCodesData)) {
            List usersByOrgs;
            paramDTO = this.parseJobParam(orgCodesData);
            if (StringUtil.isNotEmpty((String)paramDTO.getTo()) && CollUtil.isNotEmpty((Collection)(usersByOrgs = this.ucFeignService.getUsersByOrgCodes(paramDTO.getTo(), Boolean.valueOf(true))))) {
                users.addAll((Collection)usersByOrgs);
            }
            if (StringUtil.isNotEmpty((String)paramDTO.getCc()) && CollUtil.isNotEmpty((Collection)(usersByOrgs = this.ucFeignService.getUsersByOrgCodes(paramDTO.getCc(), Boolean.valueOf(true))))) {
                usersCc.addAll((Collection)usersByOrgs);
            }
        }
        if (StringUtil.isNotEmpty((String)roleCodesData)) {
            paramDTO = this.parseJobParam(roleCodesData);
            if (StringUtil.isNotEmpty((String)paramDTO.getTo()) && BeanUtils.isNotEmpty((Object)(usersTemp = this.ucFeignService.getUsersByRoleCode(paramDTO.getTo())))) {
                users.addAll(usersTemp);
            }
            if (StringUtil.isNotEmpty((String)paramDTO.getCc()) && BeanUtils.isNotEmpty((Object)(usersTemp = this.ucFeignService.getUsersByRoleCode(paramDTO.getCc())))) {
                usersCc.addAll(usersTemp);
            }
        }
        if (StringUtil.isNotEmpty((String)postCodesData)) {
            paramDTO = this.parseJobParam(postCodesData);
            if (StringUtil.isNotEmpty((String)paramDTO.getTo()) && BeanUtils.isNotEmpty((Object)(usersTemp = this.ucFeignService.getUserByPost(paramDTO.getTo())))) {
                users.addAll(usersTemp);
            }
            if (StringUtil.isNotEmpty((String)paramDTO.getCc()) && BeanUtils.isNotEmpty((Object)(usersTemp = this.ucFeignService.getUserByPost(paramDTO.getCc())))) {
                usersCc.addAll(usersTemp);
            }
        }
        ArrayList<JmsActor> toActors = new ArrayList<JmsActor>();
        ArrayList<JmsActor> ccActors = new ArrayList<JmsActor>();
        this.users2Actors(users, toActors);
        this.users2Actors(usersCc, ccActors);
        if (StringUtil.isNotEmpty((String)mailsData)) {
            String[] arrMail;
            MailJobParamDTO paramDTO2 = this.parseJobParam(mailsData);
            if (StringUtil.isNotEmpty((String)paramDTO2.getTo())) {
                for (String mail : arrMail = paramDTO2.getTo().split(",")) {
                    if (!StringUtil.isNotEmpty((String)mail)) continue;
                    toActors.add(new JmsActor(mail));
                }
            }
            if (StringUtil.isNotEmpty((String)paramDTO2.getCc())) {
                for (String mail : arrMail = paramDTO2.getCc().split(",")) {
                    if (!StringUtil.isNotEmpty((String)mail)) continue;
                    ccActors.add(new JmsActor(mail));
                }
            }
        }
        MailJobParamDTO result = new MailJobParamDTO();
        result.setToActors(toActors);
        result.setCcActors(ccActors);
        return result;
    }

    private void users2Actors(ArrayNode users, List<JmsActor> actors) {
        if (BeanUtils.isNotEmpty((Object)users)) {
            for (JsonNode j : users) {
                JmsActor actor = this.convertUserObject2JmsActor(j);
                if (!BeanUtils.isNotEmpty((Object)actor)) continue;
                actors.add(actor);
            }
        }
    }

    private MailJobParamDTO parseJobParam(String jobParam) {
        String[] arr = jobParam.split(";");
        String to = arr[0];
        String cc = arr.length > 1 ? arr[1] : "";
        to = to.startsWith("to:") ? to.substring(3) : to;
        cc = cc.startsWith("cc:") ? cc.substring(3) : cc;
        to = to.trim();
        cc = cc.trim();
        MailJobParamDTO mailJobParamDTO = new MailJobParamDTO();
        mailJobParamDTO.setTo(to);
        mailJobParamDTO.setCc(cc);
        return mailJobParamDTO;
    }

    private Map<String, Object> getVars(List<JmsActor> receivers) {
        HashMap<String, Object> vars = new HashMap<String, Object>(8);
        String baseUrl = this.sysPropertiesManager.getByAlias("baseUrl");
        String front = this.sysPropertiesManager.getByAlias("frontBaseUrl");
        String manage = this.sysPropertiesManager.getByAlias("manageBaseUrl");
        String mobile = this.sysPropertiesManager.getByAlias("mobileBaseUrl");
        vars.put("baseUrl", baseUrl);
        vars.put("manageBaseUrl", manage);
        vars.put("frontBaseUrl", front);
        vars.put("mobileBaseUrl", mobile);
        vars.put("sender", "\u7cfb\u7edf\u6267\u884c\u4eba");
        vars.put("senderId", "-1");
        if (CollUtil.isNotEmpty(receivers)) {
            vars.put("receiverId", receivers.get(0).getId());
            vars.put("receiver", receivers.get(0).getName());
        }
        return vars;
    }

    private JmsActor convertUserObject2JmsActor(JsonNode jsonNode) {
        if (BeanUtils.isEmpty((Object)jsonNode) || !jsonNode.isObject()) {
            return null;
        }
        ObjectNode userNode = (ObjectNode)jsonNode;
        String userId = JsonUtil.getString((JsonNode)userNode, (String)"userId");
        if (StringUtil.isEmpty((String)userId)) {
            userId = JsonUtil.getString((JsonNode)userNode, (String)"id");
        }
        String account = JsonUtil.getString((JsonNode)userNode, (String)"account");
        String fullname = JsonUtil.getString((JsonNode)userNode, (String)"fullname");
        String email = JsonUtil.getString((JsonNode)userNode, (String)"email");
        String mobile = JsonUtil.getString((JsonNode)userNode, (String)"mobile");
        String weixin = JsonUtil.getString((JsonNode)userNode, (String)"weixin");
        String clientId = JsonUtil.getString((JsonNode)userNode, (String)"clientId");
        String clientToken = JsonUtil.getString((JsonNode)userNode, (String)"clientToken");
        return new JmsActor(userId, account, fullname, email, mobile, weixin, clientId, clientToken);
    }
}

