/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.persistence.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.portal.model.CommonFlow;
import com.hotent.portal.model.Type;
import com.hotent.portal.persistence.dao.CommonFlowMapper;
import com.hotent.portal.persistence.manager.ICommonFlowService;
import com.hotent.portal.persistence.manager.IPermissionService;
import com.hotent.portal.persistence.manager.ITypeService;
import com.hotent.uc.api.impl.util.ContextUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CommonFlowServiceImpl
extends BaseManagerImpl<CommonFlowMapper, CommonFlow>
implements ICommonFlowService {
    @Resource
    ITypeService iTypeService;
    @Resource
    IPermissionService iPermissionService;

    @Override
    public List<Type> getMoreFlows(String flowName, String postCode) {
        List<Type> types = this.iTypeService.getValidTypes(1);
        List<Object> authorizeIds = new ArrayList();
        Map<String, Object> rights = this.iPermissionService.getRightMap(postCode);
        authorizeIds = this.iPermissionService.getAuthorizeId(rights, "common-flow");
        String ids = "'" + String.join((CharSequence)"','", authorizeIds) + "'";
        List<CommonFlow> rightFlows = ((CommonFlowMapper)this.baseMapper).getRightFlowsByAuthId(ids, flowName);
        List<CommonFlow> addFlows = ((CommonFlowMapper)this.baseMapper).getAddedFlowOwn(ContextUtil.getCurrentUserId(), ids);
        if (BeanUtils.isNotEmpty(addFlows)) {
            HashMap<String, CommonFlow> addFlowMap = new HashMap<String, CommonFlow>();
            for (CommonFlow addFlow : addFlows) {
                addFlowMap.put(addFlow.getId(), addFlow);
            }
            rightFlows.parallelStream().forEach(item -> {
                if (addFlowMap.containsKey(item.getId())) {
                    item.setAdd(true);
                    item.setRelId(((CommonFlow)((Object)((Object)addFlowMap.get(item.getId())))).getRelId());
                    item.setRelSort(((CommonFlow)((Object)((Object)addFlowMap.get(item.getId())))).getRelSort());
                }
            });
        }
        HashMap map = new HashMap();
        rightFlows.forEach(item -> {
            if (!map.containsKey(item.getTypeCode())) {
                map.put(item.getTypeCode(), new ArrayList());
            }
            ((List)map.get(item.getTypeCode())).add(item);
        });
        types.forEach(item -> {
            if (map.containsKey(item.getCode())) {
                item.setFlows((List)map.get(item.getCode()));
            }
        });
        return types.parallelStream().filter(item -> BeanUtils.isNotEmpty(item.getFlows())).collect(Collectors.toList());
    }

    @Override
    public List<CommonFlow> getAddedFlow(String userId, String id) {
        return ((CommonFlowMapper)this.baseMapper).getAddedFlow(userId, id);
    }

    @Override
    public List<CommonFlow> getCommonFlow(String account, String authorizeId, String createTime) {
        return ((CommonFlowMapper)this.baseMapper).getCommonFlow(account, authorizeId, createTime);
    }

    @Override
    public List<CommonFlow> getHomeFlows() {
        String userId = ContextUtil.getCurrentUserId();
        List<String> authorizeId = this.iPermissionService.getAuthorizeId(this.iPermissionService.getRightMap(), "common-flow");
        String ids = String.join((CharSequence)"','", authorizeId);
        List<CommonFlow> addedSystem = this.getAddedFlow(userId, "'" + ids + "'");
        Set addIds = addedSystem.stream().map(CommonFlow::getId).collect(Collectors.toSet());
        LocalDateTime before2Month = LocalDateTime.now().minusDays(60L);
        List<CommonFlow> commonFlow = this.getCommonFlow(userId, "'" + ids + "'", DateFormatUtil.formaDateTime((LocalDateTime)before2Month));
        for (CommonFlow flow : commonFlow) {
            if (!addIds.contains(flow.getId())) {
                addedSystem.add(flow);
            }
            if (addedSystem.size() != 10) continue;
            break;
        }
        return addedSystem;
    }

    @Override
    public List<CommonFlow> getHomeFlowsV1(Integer count) {
        List<CommonFlow> addedFlow;
        block2: {
            LocalDateTime before2Month;
            String ids;
            String userId;
            block3: {
                userId = ContextUtil.getCurrentUserId();
                List<String> authorizeId = this.iPermissionService.getAuthorizeId(this.iPermissionService.getRightMap(), "common-flow");
                addedFlow = new ArrayList<CommonFlow>();
                if (!BeanUtils.isNotEmpty(authorizeId)) break block2;
                ids = String.join((CharSequence)"','", authorizeId);
                addedFlow = ((CommonFlowMapper)this.baseMapper).getAddedFlowOwn(userId, "'" + ids + "'");
                if (BeanUtils.isNotEmpty(addedFlow) && addedFlow.size() >= count) break block2;
                before2Month = LocalDateTime.now().minusDays(60L);
                if (!BeanUtils.isNotEmpty(addedFlow)) break block3;
                List addIdList = addedFlow.stream().map(CommonFlow::getId).collect(Collectors.toList());
                String addIds = String.join((CharSequence)"','", addIdList);
                List<CommonFlow> commonFlows = ((CommonFlowMapper)this.baseMapper).getCommonFlowNoAdd(userId, "'" + ids + "'", "'" + addIds + "'", DateFormatUtil.formaDateTime((LocalDateTime)before2Month));
                int difCount = count - addedFlow.size();
                if (!BeanUtils.isNotEmpty(commonFlows)) break block2;
                for (CommonFlow commonFlow : commonFlows) {
                    addedFlow.add(commonFlow);
                    if (--difCount != 0) continue;
                    break block2;
                }
                break block2;
            }
            List<CommonFlow> commonFlows = ((CommonFlowMapper)this.baseMapper).getCommonFlowNoAdd(userId, "'" + ids + "'", null, DateFormatUtil.formaDateTime((LocalDateTime)before2Month));
            for (CommonFlow commonFlow : commonFlows) {
                addedFlow.add(commonFlow);
                if (addedFlow.size() != count.intValue()) continue;
                break;
            }
        }
        return addedFlow;
    }

    @Override
    public PageList<CommonFlow> queryMobileCommonFlow(QueryFilter queryFilter) {
        List<String> authorizeIds = this.iPermissionService.getAuthorizeId(this.iPermissionService.getRightMap(), "common-flow");
        if (BeanUtils.isNotEmpty(authorizeIds)) {
            queryFilter.addFilter("pcf.ID_", authorizeIds, QueryOP.IN, FieldRelation.AND, "authGroup");
            queryFilter.addFilter("pcf.MOBILE_URL_", (Object)"", QueryOP.NOT_EQUAL, FieldRelation.AND, "mobileUrl");
            queryFilter.addFilter("pcf.MOBILE_URL_", (Object)"", QueryOP.NOTNULL, FieldRelation.AND, "mobileUrl");
            return super.query(queryFilter);
        }
        return new PageList(new ArrayList());
    }

    @Override
    public CommonFlow getByCode(String code) {
        List list = this.list((Wrapper)new LambdaQueryWrapper().eq(CommonFlow::getFlowCode, (Object)code));
        if (BeanUtils.isNotEmpty((Object)list)) {
            return (CommonFlow)((Object)list.get(0));
        }
        return null;
    }

    public void remove(Serializable id) {
        this.iPermissionService.removeByAuthorizeId("common-flow", id.toString());
        this.removeById(id);
    }

    public void removeByIds(String ... ids) {
        for (String id : ids) {
            this.iPermissionService.removeByAuthorizeId("common-flow", id);
        }
        this.removeByIds(Arrays.asList(ids));
    }
}

