/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.persistence.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.portal.model.MessageRead;
import com.hotent.portal.persistence.dao.MessageReadDao;
import com.hotent.portal.persistence.manager.MessageReadManager;
import com.hotent.uc.api.model.IUser;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="messageReadManager")
public class MessageReadManagerImpl
extends BaseManagerImpl<MessageReadDao, MessageRead>
implements MessageReadManager {
    @Override
    public void addMessageRead(String msgId, IUser sysUser) {
        this.batchAddMessageRead(Collections.singletonList(msgId), sysUser);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchAddMessageRead(List<String> msgIds, IUser user) {
        List messageReads = msgIds.parallelStream().filter(msgId -> {
            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(MessageRead::getReceiverId, (Object)user.getUserId())).eq(MessageRead::getMsgId, msgId);
            return this.count((Wrapper)wrapper) == 0;
        }).map(msgId -> {
            MessageRead messageRead = new MessageRead();
            messageRead.setId(UniqueIdUtil.getSuid());
            messageRead.setMsgId((String)msgId);
            messageRead.setReceiverId(user.getUserId());
            messageRead.setReceiver(user.getFullname());
            messageRead.setReceiverTime(LocalDateTime.now());
            return messageRead;
        }).collect(Collectors.toList());
        this.saveBatch(messageReads);
    }

    @Override
    public List<MessageRead> getByMessageId(String messageId) {
        return ((MessageReadDao)this.baseMapper).getByMessageId(messageId);
    }
}

