/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.persistence.manager.impl;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.cache.annotation.CacheEvict;
import com.hotent.base.cache.annotation.Cacheable;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.portal.model.MsgTemplate;
import com.hotent.portal.persistence.dao.MsgTemplateDao;
import com.hotent.portal.persistence.manager.MsgTemplateManager;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IGroup;
import java.io.Serializable;
import org.springframework.stereotype.Service;

@Service(value="msgTemplateManager")
public class MsgTemplateManagerImpl
extends BaseManagerImpl<MsgTemplateDao, MsgTemplate>
implements MsgTemplateManager {
    public void update(MsgTemplate msgTemplate) {
        super.update((Model)msgTemplate);
        MsgTemplateManager msgTemplateManager = (MsgTemplateManager)AppUtil.getBean(MsgTemplateManager.class);
        msgTemplateManager.delCacheByKey(msgTemplate.getKey());
    }

    @Override
    @Cacheable(value={"eip:protal:msg"}, key="#templateKey")
    public MsgTemplate getByKey(String templateKey) {
        return ((MsgTemplateDao)this.baseMapper).getByKey(templateKey);
    }

    @Override
    @Cacheable(value={"eip:protal:defaultMsg"}, key="#typeKey")
    public MsgTemplate getDefault(String typeKey) {
        return ((MsgTemplateDao)this.baseMapper).getDefault(typeKey);
    }

    @Override
    @CacheEvict(value={"eip:protal:msg"}, key="#templateKey")
    public void delCacheByKey(String templateKey) {
    }

    @Override
    @CacheEvict(value={"eip:protal:defaultMsg"}, key="#typeKey")
    public void delDefaultCacheByKey(String typeKey) {
    }

    @Override
    public void setDefault(String id) {
        MsgTemplate MsgTemplate2 = (MsgTemplate)this.get((Serializable)((Object)id));
        String typeKey = MsgTemplate2.getTypeKey();
        ((MsgTemplateDao)this.baseMapper).setNotDefaultByType(typeKey);
        ((MsgTemplateDao)this.baseMapper).setDefault(id);
        MsgTemplateManager msgTemplateManager = (MsgTemplateManager)AppUtil.getBean(MsgTemplateManager.class);
        msgTemplateManager.delDefaultCacheByKey(typeKey);
    }

    @Override
    public boolean isExistByKeyAndTypeKey(String key, String typeKey) {
        return ((MsgTemplateDao)this.baseMapper).isExistByKeyAndTypeKey(key, typeKey);
    }

    @Override
    public void setNotDefault(String id) {
        ((MsgTemplateDao)this.baseMapper).setNotDefaultById(id);
    }

    @Override
    public CommonResult<String> saveMsgTemplate(MsgTemplate msgTemplate) throws Exception {
        String resultMsg = null;
        String currentUserId = ContextUtil.getCurrentUserId();
        IGroup group = ContextUtil.getCurrentGroup();
        String currentGroupId = "0";
        if (group != null) {
            currentGroupId = group.getGroupId();
        }
        boolean isExist = false;
        if (StringUtil.isEmpty((String)msgTemplate.getId())) {
            QueryFilter queryFilter = QueryFilter.build().withDefaultPage();
            queryFilter.addFilter("KEY_", (Object)msgTemplate.getKey(), QueryOP.EQUAL);
            queryFilter.addFilter("TYPE_KEY_", (Object)msgTemplate.getTypeKey(), QueryOP.EQUAL);
            PageList query = this.query(queryFilter);
            boolean bl = isExist = query.getRows().size() > 0;
            if (isExist) {
                resultMsg = "\u6d88\u606f\u6a21\u7248\u4e1a\u52a1\u952e\u5df2\u7ecf\u5b58\u5728,\u6dfb\u52a0\u5931\u8d25!";
            } else {
                msgTemplate.setId(UniqueIdUtil.getSuid());
                msgTemplate.setCreateBy(currentUserId);
                msgTemplate.setCreateOrgId(currentGroupId);
                this.create((Model)msgTemplate);
                resultMsg = "\u6dfb\u52a0\u6d88\u606f\u6a21\u7248\u6210\u529f";
            }
        } else {
            MsgTemplate sysMsgTemplateTemp = (MsgTemplate)this.get((Serializable)((Object)msgTemplate.getId()));
            if (BeanUtils.isNotEmpty((Object)((Object)sysMsgTemplateTemp))) {
                if (!sysMsgTemplateTemp.getKey().equals(msgTemplate.getKey())) {
                    isExist = this.isExistByKeyAndTypeKey(msgTemplate.getKey(), msgTemplate.getTypeKey());
                }
            } else {
                isExist = this.isExistByKeyAndTypeKey(msgTemplate.getKey(), msgTemplate.getTypeKey());
            }
            if (isExist) {
                resultMsg = "\u6d88\u606f\u6a21\u7248\u4e1a\u52a1\u952e\u5df2\u7ecf\u5b58\u5728,\u66f4\u65b0\u5931\u8d25!";
            } else {
                msgTemplate.setUpdateBy(currentUserId);
                this.update(msgTemplate);
                resultMsg = "\u66f4\u65b0\u6d88\u606f\u6a21\u7248\u6210\u529f";
                MsgTemplateManager bean = (MsgTemplateManager)AppUtil.getBean(MsgTemplateManager.class);
                bean.delCacheByKey(msgTemplate.getKey());
                bean.delDefaultCacheByKey(msgTemplate.getTypeKey());
            }
        }
        return new CommonResult(resultMsg);
    }
}

