/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.persistence.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.hash.Hashing;
import com.hotent.base.conf.SaaSConfig;
import com.hotent.base.context.BaseContext;
import com.hotent.base.handler.MultiTenantHandler;
import com.hotent.base.handler.MultiTenantIgnoreResult;
import com.hotent.base.jwt.JwtTokenHandler;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.time.TimeUtil;
import com.hotent.portal.model.ShorturlManage;
import com.hotent.portal.persistence.dao.ShorturlManageDao;
import com.hotent.portal.persistence.manager.ShorturlManageManager;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import com.hotent.uc.api.service.IUserService;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import javax.annotation.Resource;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;

@Service
public class ShorturlManageManagerImpl
extends BaseManagerImpl<ShorturlManageDao, ShorturlManage>
implements ShorturlManageManager {
    @Resource
    JwtTokenHandler jwtTokenHandler;
    @Resource
    SaaSConfig saaSConfig;
    @Resource
    BaseContext baseContext;

    @Override
    public ShorturlManage getByShortUrl(String shortUrl) {
        return ((ShorturlManageDao)this.baseMapper).getByShortUrl(shortUrl);
    }

    @Override
    public CommonResult<ShorturlManage> getLongUrlByShortUrl(String shortUrl) throws Exception {
        ShorturlManage shortUrlManage = null;
        if (this.saaSConfig.isEnable()) {
            try (MultiTenantIgnoreResult multiTenantIgnoreResult = MultiTenantHandler.setThreadLocalIgnore();){
                QueryWrapper wrapper = new QueryWrapper();
                wrapper.eq((Object)"SHORT_URL_", (Object)shortUrl);
                shortUrlManage = (ShorturlManage)this.getOne((Wrapper)wrapper);
            }
        } else {
            shortUrlManage = this.getByShortUrl(shortUrl);
        }
        String errorMsg = "";
        if (BeanUtils.isEmpty((Object)shortUrlManage)) {
            errorMsg = "2";
        } else if ("2".equals(shortUrlManage.getEnabled())) {
            errorMsg = "3";
        } else if (BeanUtils.isNotEmpty((Object)shortUrlManage.getLoseTime()) && TimeUtil.getTimeMillis((LocalDateTime)shortUrlManage.getLoseTime()) < TimeUtil.getTimeMillis((LocalDateTime)LocalDateTime.now())) {
            errorMsg = "4";
        }
        if (StringUtil.isNotEmpty((String)errorMsg)) {
            return new CommonResult(false, errorMsg);
        }
        if (this.saaSConfig.isEnable()) {
            this.baseContext.setTempTenantId(shortUrlManage.getTenantId());
            IUserService userService = (IUserService)AppUtil.getBean(IUserService.class);
            IUser userByAccount = userService.getUserByAccount("guest");
            shortUrlManage.setGuestToken(this.jwtTokenHandler.generateToken((UserDetails)userByAccount));
        } else {
            shortUrlManage.setGuestToken(this.jwtTokenHandler.generateToken("guest"));
        }
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f", (Object)shortUrlManage);
    }

    @Override
    public CommonResult<ShorturlManage> getShortUrlByLong(ShorturlManage vo) {
        CommonResult rtn = null;
        try {
            String shourtUrl = "";
            shourtUrl = this.saaSConfig.isEnable() ? "surl/" + Hashing.murmur3_32().hashString((CharSequence)(vo.getUrl() + ContextUtil.getCurrentUser().getTenantId()), StandardCharsets.UTF_8).toString() : "surl/" + Hashing.murmur3_32().hashString((CharSequence)vo.getUrl(), StandardCharsets.UTF_8).toString();
            QueryFilter queryFilter = QueryFilter.build();
            queryFilter.withPage(new PageBean(Integer.valueOf(1), Integer.valueOf(-1)));
            queryFilter.addFilter("short_url_", (Object)shourtUrl, QueryOP.RIGHT_LIKE);
            PageList query = this.query(queryFilter);
            if (BeanUtils.isNotEmpty((Object)query) && BeanUtils.isNotEmpty((Object)query.getRows())) {
                for (ShorturlManage shorturlManage : query.getRows()) {
                    if (!vo.getUrl().equals(shorturlManage.getUrl())) continue;
                    return new CommonResult(true, "\u83b7\u53d6\u77ed\u94fe\u63a5\u6210\u529f", (Object)shorturlManage);
                }
                shourtUrl = shourtUrl + query.getRows().size();
            }
            vo.setShortUrl(shourtUrl);
            vo.setId(UniqueIdUtil.getSuid());
            this.save(vo);
            rtn = new CommonResult(true, "\u6839\u636e\u957f\u8fde\u63a5\u83b7\u53d6\uff01", (Object)vo);
        }
        catch (Exception e) {
            e.printStackTrace();
            rtn = new CommonResult(false, "\u6839\u636e\u957f\u8fde\u63a5\u83b7\u53d6!", null);
        }
        return rtn;
    }
}

