/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.persistence.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.cache.annotation.CacheEvict;
import com.hotent.base.cache.annotation.CachePut;
import com.hotent.base.cache.annotation.Cacheable;
import com.hotent.base.cache.annotation.FirstCache;
import com.hotent.base.cache.annotation.SecondaryCache;
import com.hotent.base.context.BaseContext;
import com.hotent.base.exception.BaseException;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.model.ImportCheckResult;
import com.hotent.base.query.Direction;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.FieldSort;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.Base64;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ThreadMsgUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.ZipUtil;
import com.hotent.base.util.time.DateUtil;
import com.hotent.column.model.PortalNewsNotice;
import com.hotent.column.model.SysIndexColumn;
import com.hotent.column.persistence.manager.AuthorityManager;
import com.hotent.column.persistence.manager.PortalNewsNoticeManager;
import com.hotent.column.persistence.manager.impl.SysIndexColumnManagerImpl;
import com.hotent.file.model.FileInfo;
import com.hotent.file.service.FileService;
import com.hotent.portal.model.PortalUserLayoutConfig;
import com.hotent.portal.model.SysIndexLayoutManage;
import com.hotent.portal.model.SysIndexMyLayout;
import com.hotent.portal.model.SysObjRights;
import com.hotent.portal.params.IndexLayoutVo;
import com.hotent.portal.persistence.dao.SysIndexLayoutManageDao;
import com.hotent.portal.persistence.manager.PortalUserLayoutConfigManager;
import com.hotent.portal.persistence.manager.SysIndexLayoutManageManager;
import com.hotent.portal.persistence.manager.SysIndexMyLayoutManager;
import com.hotent.sys.persistence.manager.SysAuthUserManager;
import com.hotent.sys.persistence.manager.SysMenuManager;
import com.hotent.sys.persistence.model.SysMenu;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="sysIndexLayoutManageManager")
public class SysIndexLayoutManageManagerImpl
extends BaseManagerImpl<SysIndexLayoutManageDao, SysIndexLayoutManage>
implements SysIndexLayoutManageManager {
    @Resource
    private SysIndexColumnManagerImpl sysIndexColumnService;
    @Resource
    private AuthorityManager authorityManager;
    @Resource
    SysIndexMyLayoutManager sysIndexMylayoutService;
    @Resource
    private SysAuthUserManager sysAuthUserManager;
    @Resource
    private PortalUserLayoutConfigManager portalUserLayoutConfigManager;
    @Resource
    private SysMenuManager sysMenuManager;
    @Resource
    BaseContext baseContext;
    @Value(value="${system.saas.enable:false}")
    Boolean saasEnable;
    @Resource
    PortalNewsNoticeManager portalNewsNoticeManager;
    @Resource
    FileService fileService;

    @Override
    public SysIndexLayoutManage getLayoutList(String id, List<SysIndexColumn> columnList, Short type) {
        SysIndexLayoutManage sysIndexLayoutManage = null;
        if (StringUtil.isNotEmpty((String)id)) {
            sysIndexLayoutManage = (SysIndexLayoutManage)this.get((Serializable)((Object)id));
        }
        if (BeanUtils.isEmpty(sysIndexLayoutManage)) {
            return this.getDefaultIndexLayout(type);
        }
        String designHtml = "";
        try {
            designHtml = Base64.getFromBase64((String)sysIndexLayoutManage.getDesignHtml());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        sysIndexLayoutManage.setDesignHtml(this.sysIndexColumnService.parserDesignHtml(designHtml, columnList));
        return sysIndexLayoutManage;
    }

    public String getDefaultMobileDesignHtml() {
        return "<div class=\"lyrow ui-draggable\" style=\"display: block;\"><div class=\"preview\"><input type=\"text\" value=\"\u4e00\u5217(12)\" readonly=\"readonly\" class=\"form-control\"></div><div class=\"view\"><div class=\"row clearfix\"><div class=\"col-md-12 column ui-sortable\"></div></div></div></div>";
    }

    @Override
    public String getDefaultDesignHtml() {
        return "<div class=\"lyrow ui-draggable\" style=\"display: block;\"><a href=\"#close\" class=\"remove label label-danger\"><i class=\"glyphicon-remove glyphicon\"></i> \u5220\u9664</a><span class=\"drag label label-default\"><i class=\"glyphicon glyphglyphicon glyphicon-move\"></i> \u62d6\u52a8</span><div class=\"preview\"><input type=\"text\" value=\"\u4e00\u5217(12)\" readonly=\"readonly\" class=\"form-control\"></div><div class=\"view\"><div class=\"row clearfix\"><div class=\"col-md-12 column ui-sortable\"></div></div></div></div>";
    }

    private SysIndexLayoutManage getDefaultIndexLayout(Short type) {
        String designHtml = this.getDefaultDesignHtml();
        if (type.equals((short)1)) {
            designHtml = this.getDefaultMobileDesignHtml();
        }
        SysIndexLayoutManage sysIndexLayoutManage = new SysIndexLayoutManage();
        sysIndexLayoutManage.setDesignHtml(designHtml);
        sysIndexLayoutManage.setIsDef((short)0);
        return sysIndexLayoutManage;
    }

    @Override
    public String getMyHasRightsLayout() {
        Map relationMap = this.authorityManager.getUserRightMap();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("relationMap", relationMap);
        params.put("objType", SysObjRights.RIGHT_TYPE_INDEX_MANAGE);
        List<SysIndexLayoutManage> list = ((SysIndexLayoutManageDao)this.baseMapper).getByUserIdFilter(params);
        if (BeanUtils.isNotEmpty(list)) {
            return list.get(0).getTemplateHtml();
        }
        return "";
    }

    @Override
    public String getManagerLayout() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgIds", null);
        params.put("isDef", 1);
        List<SysIndexLayoutManage> list = ((SysIndexLayoutManageDao)this.baseMapper).getManageLayout(params);
        if (BeanUtils.isNotEmpty(list)) {
            return list.get(0).getDesignHtml();
        }
        return null;
    }

    @Override
    public String obtainIndexManageData(String layoutId) {
        SysIndexLayoutManage sysIndexLayoutManage = (SysIndexLayoutManage)this.get((Serializable)((Object)layoutId));
        if (BeanUtils.isNotEmpty((Object)((Object)sysIndexLayoutManage))) {
            return sysIndexLayoutManage.getTemplateHtml();
        }
        String html = this.getMyHasRightsLayout();
        if (BeanUtils.isNotEmpty((Object)html)) {
            return html;
        }
        if (BeanUtils.isNotEmpty((Object)html)) {
            return html;
        }
        html = this.getManagerLayout();
        if (BeanUtils.isNotEmpty((Object)html)) {
            return html;
        }
        if (BeanUtils.isEmpty((Object)html)) {
            html = this.getDefaultDesignHtml();
        }
        return "";
    }

    @Override
    public SysIndexLayoutManage getEnableByOrgIdAndType(String orgId, Short layoutType) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", orgId);
        params.put("layoutType", layoutType);
        return ((SysIndexLayoutManageDao)this.baseMapper).getEnableByOrgIdAndType(params);
    }

    @Override
    public Boolean isExistName(String name) {
        Integer count = ((SysIndexLayoutManageDao)this.baseMapper).isExistName(name);
        return count > 0;
    }

    @Override
    public List<SysIndexLayoutManage> getByOrgIdAndLayoutType(String orgId, Short layoutType) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", orgId);
        params.put("layoutType", layoutType);
        return ((SysIndexLayoutManageDao)this.baseMapper).getByOrgIdAndLayoutType(params);
    }

    @Override
    public void cancelOrgIsDef(String orgId, Short layoutType) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", orgId);
        params.put("layoutType", layoutType);
        ((SysIndexLayoutManageDao)this.baseMapper).cancelOrgIsDef(params);
    }

    @Override
    public String obtainIndexManageMobileData(String layoutId) {
        SysIndexLayoutManage sysIndexLayoutManage = (SysIndexLayoutManage)this.get((Serializable)((Object)layoutId));
        return sysIndexLayoutManage.getTemplateHtml();
    }

    @Override
    public SysIndexLayoutManage getByIdAndType(String id, Short type) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        params.put("type", type);
        return ((SysIndexLayoutManageDao)this.baseMapper).getByIdAndType(params);
    }

    @Override
    public String getMobileManagerLayout() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("layoutType", (short)1);
        params.put("orgIds", null);
        params.put("isDef", 1);
        List<SysIndexLayoutManage> list = ((SysIndexLayoutManageDao)this.baseMapper).getManageLayout(params);
        if (BeanUtils.isNotEmpty(list)) {
            return list.get(0).getDesignHtml();
        }
        return null;
    }

    @Override
    public SysIndexLayoutManage getSharedByOrgIdAndType(String orgId, Short layoutType) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", orgId);
        params.put("layoutType", layoutType);
        return ((SysIndexLayoutManageDao)this.baseMapper).getSharedByOrgIdAndType(params);
    }

    @Override
    public SysIndexLayoutManage getSharedByOrgIds(List<String> orgIds, Short layoutType) {
        List<SysIndexLayoutManage> list = ((SysIndexLayoutManageDao)this.baseMapper).getSharedByOrgIds(orgIds, layoutType);
        if (BeanUtils.isNotEmpty(list)) {
            return list.get(0);
        }
        return null;
    }

    @Override
    @Transactional
    public void setEnable(String id, Short enable) {
        SysIndexLayoutManage layout = (SysIndexLayoutManage)this.get((Serializable)((Object)id));
        layout.setEnable(enable);
        this.update((Model)layout);
    }

    @Override
    @Transactional
    public void setAsTemplate(String id, Short asTemplate) {
        SysIndexLayoutManage layout = (SysIndexLayoutManage)this.get((Serializable)((Object)id));
        layout.setAsTemplate(asTemplate);
        this.update((Model)layout);
    }

    @Override
    public SysIndexLayoutManage getDefaultLayoutManageByLayoutType(String layoutType) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"LAYOUT_TYPE", (Object)Short.parseShort(layoutType))).eq((Object)"ENABLE", (Object)1)).eq((Object)"IS_DEF", (Object)1);
        SysIndexLayoutManage defaultLayout = (SysIndexLayoutManage)((Object)((SysIndexLayoutManageDao)this.baseMapper).selectOne((Wrapper)queryWrapper));
        return defaultLayout;
    }

    @Override
    public Map<String, Object> exportDefaultLayout(List<String> ids, boolean isDefault) throws Exception {
        if (BeanUtils.isEmpty(ids)) {
            throw new BaseException("\u8bf7\u5148\u9009\u62e9\u8981\u5bfc\u51fa\u7684\u9ed8\u8ba4\u5e03\u5c40");
        }
        String filePrefix = isDefault ? "defaultLayout" : "orgLayout";
        HashMap<String, Object> map = new HashMap<String, Object>();
        QueryFilter queryFilter = QueryFilter.build();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ids.size(); ++i) {
            sb.append(ids.get(i));
            if (i == ids.size() - 1) continue;
            sb.append(",");
        }
        queryFilter.addFilter("ID", (Object)sb.toString(), QueryOP.IN, FieldRelation.AND);
        PageList query = this.query(queryFilter);
        Assert.notEmpty((Collection)query.getRows(), (String)"\u4e0d\u5b58\u5728\u8be5\u5e03\u5c40");
        List list = query.getRows();
        if (BeanUtils.isNotEmpty((Object)list)) {
            for (SysIndexLayoutManage sysIndexLayoutManage : list) {
                String designHtml = sysIndexLayoutManage.getDesignHtml();
                String design = Base64.getFromBase64((String)designHtml);
                if (!StringUtil.isNotEmpty((String)design)) continue;
                JsonNode node = JsonUtil.toJsonNode((String)design);
                if (!node.isEmpty() && node.has("mobileList") && node.get("mobileList").size() > 0) {
                    this.setSnapshotIdFile((ArrayNode)node.get("mobileList"), map);
                }
                if (!node.isEmpty() && node.has("list") && node.get("list").size() > 0) {
                    ArrayNode arrayNode = (ArrayNode)node.get("list");
                    for (JsonNode jsonNode : arrayNode) {
                        ArrayNode columns = (ArrayNode)jsonNode.get("columns");
                        if (!BeanUtils.isNotEmpty((Object)columns)) continue;
                        for (JsonNode column : columns) {
                            this.setSnapshotIdFile((ArrayNode)column.get("list"), map);
                        }
                    }
                }
                sysIndexLayoutManage.setDesignHtml(Base64.getBase64((String)JsonUtil.toJsonString((Object)node)));
            }
            map.put(filePrefix + ".json", JsonUtil.toJson((Object)list));
            return map;
        }
        throw new BaseException("\u672a\u67e5\u627e\u5230\u4efb\u4f55\u8bb0\u5f55");
    }

    private void setSnapshotIdFile(ArrayNode arrayNode, Map<String, Object> map) throws Exception {
        if (BeanUtils.isNotEmpty((Object)arrayNode)) {
            for (JsonNode mobileNode : arrayNode) {
                FileInfo file;
                String snapshotId = JsonUtil.getString((JsonNode)mobileNode, (String)"snapshotId");
                if (!StringUtil.isNotEmpty((String)snapshotId) || !StringUtil.isNotEmpty((String)(file = this.fileService.get(snapshotId)).getId())) continue;
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                this.fileService.downloadFile(file.getId(), outputStream);
                ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
                map.put(file.getId() + "." + file.getExtensionName(), inputStream);
                ObjectNode objectNode = (ObjectNode)mobileNode;
                objectNode.put("extensionName", file.getExtensionName());
                file.setBytes(null);
                file.setStoreType(null);
                objectNode.put("file", JsonUtil.toJson((Object)file));
            }
        }
    }

    @Transactional
    public Boolean importDatavFile(String uzPath, String orgId, boolean isDefault) {
        try {
            String fileName = isDefault ? "defaultLayout.json" : "orgLayout.json";
            String fileJson = FileUtil.readFile((String)(uzPath + File.separator + fileName));
            List list = (List)JsonUtil.toBean((String)fileJson, List.class);
            ArrayList<SysIndexLayoutManage> sysIndexLayoutManageList = new ArrayList<SysIndexLayoutManage>();
            ArrayList<SysIndexLayoutManage> checkList = new ArrayList<SysIndexLayoutManage>();
            if (StringUtil.isEmpty((String)orgId)) {
                throw new BaseException("\u8bf7\u5148\u9009\u62e9\u90e8\u95e8");
            }
            for (Object o : list) {
                SysIndexLayoutManage layout = (SysIndexLayoutManage)((Object)JsonUtil.toBean((String)JsonUtil.toJson(o), SysIndexLayoutManage.class));
                if (StringUtil.isEmpty((String)layout.getName())) {
                    throw new BaseException("\u5927\u5c4f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (StringUtil.isEmpty((String)layout.getAlias())) {
                    throw new BaseException("\u5927\u5c4f\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (StringUtil.isEmpty((String)layout.getType())) {
                    throw new BaseException("\u5e03\u5c40type\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (!StringUtil.equals((String)layout.getType(), (String)"datav")) {
                    throw new BaseException("\u5e03\u5c40\u7c7b\u578b\u53ea\u80fd\u4e3adatav\uff01");
                }
                sysIndexLayoutManageList.add(layout);
                SysIndexLayoutManage checkLayout = ((SysIndexLayoutManageDao)this.baseMapper).getDatavByAlias(layout.getAlias());
                if (!BeanUtils.isNotEmpty((Object)((Object)checkLayout))) continue;
                checkList.add(checkLayout);
            }
            if (checkList.size() > 0) {
                return false;
            }
            for (SysIndexLayoutManage sysIndexLayoutManage : sysIndexLayoutManageList) {
                sysIndexLayoutManage.setId(UniqueIdUtil.getSuid());
                sysIndexLayoutManage.setEnable((short)1);
                ((SysIndexLayoutManageDao)this.baseMapper).insert((Object)sysIndexLayoutManage);
            }
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage());
        }
        return true;
    }

    public String isImportFileRepeat(String fileJson, String uzPath) throws IOException {
        List list = (List)JsonUtil.toBean((String)fileJson, List.class);
        ArrayList<SysIndexLayoutManage> tempList = new ArrayList<SysIndexLayoutManage>();
        for (Object o : list) {
            SysIndexLayoutManage layout = (SysIndexLayoutManage)((Object)JsonUtil.toBean((String)JsonUtil.toJson(o), SysIndexLayoutManage.class));
            this.setSnapshotId(uzPath, layout);
            tempList.add(layout);
            SysIndexLayoutManage byId = (SysIndexLayoutManage)((Object)this.getById((Serializable)((Object)layout.getId())));
            List<SysIndexLayoutManage> byAlias = this.getByAlias(layout.getAlias());
            if (!BeanUtils.isNotEmpty((Object)((Object)byId)) && !BeanUtils.isNotEmpty(byAlias)) continue;
            ThreadMsgUtil.addMapMsg2((String)"sysIndexLayoutRepeat", (String)String.format("<div style='margin-left:12px; margin-top:6px;'>%s [%s]</div>", layout.getName() + "", layout.getAlias() + ""));
        }
        return JsonUtil.toJson(tempList);
    }

    private void setSnapshotId(String uzPath, SysIndexLayoutManage sysIndexLayoutManage) throws IOException {
        String designHtml = sysIndexLayoutManage.getDesignHtml();
        String design = Base64.getFromBase64((String)designHtml);
        if (StringUtil.isNotEmpty((String)design)) {
            JsonNode node = JsonUtil.toJsonNode((String)design);
            if (!node.isEmpty() && node.has("mobileList")) {
                this.getSnapshotIdFile(uzPath, (ArrayNode)node.get("mobileList"));
            }
            if (!node.isEmpty() && node.has("list") && node.get("list").size() > 0) {
                ArrayNode arrayNode = (ArrayNode)node.get("list");
                for (JsonNode jsonNode : arrayNode) {
                    ArrayNode columns = (ArrayNode)jsonNode.get("columns");
                    for (JsonNode column : columns) {
                        this.getSnapshotIdFile(uzPath, (ArrayNode)column.get("list"));
                    }
                }
            }
            sysIndexLayoutManage.setDesignHtml(Base64.getBase64((String)JsonUtil.toJson((Object)node)));
        }
    }

    private void getSnapshotIdFile(String uzPath, ArrayNode arrayNode) {
        if (BeanUtils.isNotEmpty((Object)arrayNode)) {
            for (JsonNode jsonNode : arrayNode) {
                ObjectNode objectNode = (ObjectNode)jsonNode;
                String snapshotId = JsonUtil.getString((JsonNode)objectNode, (String)"snapshotId");
                if (!StringUtil.isNotEmpty((String)snapshotId)) continue;
                File file = new File(uzPath + File.separator + snapshotId + "." + JsonUtil.getString((JsonNode)objectNode, (String)"extensionName", (String)"jpg"));
                String suid = UniqueIdUtil.getSuid();
                if (!file.exists() || !file.isFile()) continue;
                try {
                    String fileInfoString = JsonUtil.getString((JsonNode)objectNode, (String)"file");
                    FileInfo fileInfo = (FileInfo)JsonUtil.toBean((String)fileInfoString, FileInfo.class);
                    fileInfo.setId(suid);
                    this.fileService.uploadFile(fileInfo, Files.newInputStream(file.toPath(), new OpenOption[0]));
                    objectNode.remove("file");
                    objectNode.put("snapshotId", suid);
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    @Transactional
    public void importFile(String fileJson) throws IOException {
        List list = (List)JsonUtil.toBean((String)fileJson, List.class);
        for (Object o : list) {
            SysIndexLayoutManage layout = (SysIndexLayoutManage)((Object)JsonUtil.toBean((String)JsonUtil.toJson(o), SysIndexLayoutManage.class));
            SysIndexLayoutManage byId = (SysIndexLayoutManage)((Object)this.getById((Serializable)((Object)layout.getId())));
            List<SysIndexLayoutManage> byAlias = this.getByAlias(layout.getAlias());
            if (BeanUtils.isNotEmpty((Object)((Object)byId))) {
                ((SysIndexLayoutManageDao)this.baseMapper).updateById((Object)layout);
                continue;
            }
            if (BeanUtils.isNotEmpty(byAlias)) {
                QueryWrapper wrapper = new QueryWrapper();
                wrapper.eq((Object)"ALIAS", (Object)layout.getAlias());
                ((SysIndexLayoutManageDao)this.baseMapper).update((Object)layout, (Wrapper)wrapper);
                continue;
            }
            layout.setEnable((short)1);
            ((SysIndexLayoutManageDao)this.baseMapper).insert((Object)layout);
        }
    }

    @Override
    public Map<String, String> importLayout(List<SysIndexLayoutManage> layouts, boolean isCover) {
        for (SysIndexLayoutManage layout : layouts) {
            List<SysIndexLayoutManage> byAlias = this.getByAlias(layout.getAlias());
            if (BeanUtils.isEmpty(byAlias)) {
                layout.setEnable((short)1);
                layout.setId(UniqueIdUtil.getSuid());
                ((SysIndexLayoutManageDao)this.baseMapper).insert((Object)layout);
                continue;
            }
            if (!isCover) continue;
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"ALIAS", (Object)layout.getAlias());
            ((SysIndexLayoutManageDao)this.baseMapper).update((Object)layout, (Wrapper)wrapper);
        }
        List alias = layouts.stream().map(SysIndexLayoutManage::getAlias).collect(Collectors.toList());
        return this.list((Wrapper)Wrappers.lambdaQuery().in(SysIndexLayoutManage::getAlias, alias)).stream().collect(Collectors.toMap(SysIndexLayoutManage::getAlias, SysIndexLayoutManage::getId, (k1, k2) -> k1));
    }

    @Override
    @CachePut(value={"eip:sys_index_layout:importFile"}, key="#fileId", firstCache=@FirstCache(expireTime=1, timeUnit=TimeUnit.HOURS))
    public String putImportFileInCache(String fileId, String fileJson) {
        return fileJson;
    }

    @Override
    @Cacheable(value={"eip:sys_index_layout:importFile"}, key="#fileId", firstCache=@FirstCache(expireTime=1, timeUnit=TimeUnit.HOURS))
    public String getImportFileFromCache(String fileId) {
        return null;
    }

    @Override
    @CacheEvict(value={"eip:sys_index_layout:importFile"}, key="#fileId")
    public void delImportFileFromCache(String fileId) {
    }

    @Override
    public List<SysIndexLayoutManage> getByAlias(String alias) {
        return ((SysIndexLayoutManageDao)this.baseMapper).getByAlias(alias);
    }

    @Override
    @CachePut(value={"eip:portal:indexLayout"}, key="#layoutType+'_'+#userId", ignoreException=false, firstCache=@FirstCache(expireTime=7, expireTimeExp="#expireTime", timeUnit=TimeUnit.DAYS), secondaryCache=@SecondaryCache(expireTime=7, expireTimeExp="#expireTime", preloadTime=7, forceRefresh=true, timeUnit=TimeUnit.DAYS))
    public String cacheUserLayout(String layoutId, String layoutType, String type, String userId) {
        return type + "_" + layoutId;
    }

    @Override
    @Cacheable(value={"eip:portal:indexLayout"}, key="#layoutType+'_'+#userId", ignoreException=false, firstCache=@FirstCache(expireTime=7, expireTimeExp="#expireTime", timeUnit=TimeUnit.DAYS), secondaryCache=@SecondaryCache(expireTime=7, expireTimeExp="#expireTime", preloadTime=7, forceRefresh=true, timeUnit=TimeUnit.DAYS))
    public String getCacheUserLayout(String layoutType, String userId) {
        return null;
    }

    @Override
    @CacheEvict(value={"eip:portal:indexLayout"}, key="#userId+'_'+#layoutType", ignoreException=false)
    public void removeCacheUserLayout(String layoutType, String userId) {
    }

    @Override
    public CommonResult<IndexLayoutVo> myHome() throws Exception {
        IndexLayoutVo vo = null;
        vo = this.getCacheLayout((short)0);
        if (BeanUtils.isNotEmpty((Object)vo)) {
            return new CommonResult(true, "\u83b7\u53d6\u6210\u529f\uff01", (Object)vo);
        }
        SysIndexLayoutManage layout = this.traceLayout((short)0);
        if (BeanUtils.isNotEmpty((Object)((Object)layout))) {
            vo = new IndexLayoutVo("sys", layout.getId(), layout.getName(), layout.getAlias(), layout.getDesignHtml(), layout.getIsDef(), (short)0, StringUtil.isNotEmpty((String)layout.getType()) ? layout.getType() : "column");
            vo.setBannerTypeIds(layout.getBannerTypeIds());
        } else {
            vo = new IndexLayoutVo();
            vo.setDesignHtml("");
        }
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public CommonResult<IndexLayoutVo> myVueFrontHome() throws Exception {
        IndexLayoutVo vo = null;
        vo = this.getCacheLayout((short)2);
        if (BeanUtils.isNotEmpty((Object)vo)) {
            return new CommonResult(true, "\u83b7\u53d6\u6210\u529f\uff01", (Object)vo);
        }
        QueryFilter query = QueryFilter.build();
        query.addFilter("USER_ID", (Object)ContextUtil.getCurrentUserId(), QueryOP.EQUAL);
        query.addFilter("VALID_", (Object)1, QueryOP.EQUAL);
        List SysIndexMyLayouts = this.sysIndexMylayoutService.queryNoPage(query);
        if (BeanUtils.isNotEmpty((Object)SysIndexMyLayouts) && SysIndexMyLayouts.size() > 0) {
            SysIndexMyLayout myLayout = (SysIndexMyLayout)((Object)SysIndexMyLayouts.get(0));
            vo = new IndexLayoutVo("personal", myLayout.getId(), myLayout.getName(), "", myLayout.getDesignHtml(), (short)0, (short)2, "column");
        } else {
            SysIndexLayoutManage layout = this.traceLayout((short)2);
            if (BeanUtils.isEmpty((Object)((Object)layout))) {
                vo = new IndexLayoutVo();
                vo.setDesignHtml("");
            } else {
                vo = new IndexLayoutVo("sys", layout.getId(), layout.getName(), layout.getAlias(), layout.getDesignHtml(), layout.getIsDef(), (short)2, StringUtil.isNotEmpty((String)layout.getType()) ? layout.getType() : "column");
            }
        }
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public CommonResult<IndexLayoutVo> myMobileHome() throws Exception {
        IndexLayoutVo vo = null;
        vo = this.getCacheLayout((short)1);
        if (BeanUtils.isNotEmpty((Object)vo)) {
            return new CommonResult(true, "\u83b7\u53d6\u6210\u529f\uff01", (Object)vo);
        }
        SysIndexLayoutManage layout = this.traceLayout((short)1);
        if (BeanUtils.isNotEmpty((Object)((Object)layout))) {
            vo = new IndexLayoutVo("sys", layout.getId(), layout.getName(), layout.getAlias(), layout.getDesignHtml(), layout.getIsDef(), (short)1, StringUtil.isNotEmpty((String)layout.getType()) ? layout.getType() : "column");
            vo.setBannerTypeIds(layout.getBannerTypeIds());
        } else {
            vo = new IndexLayoutVo();
            vo.setDesignHtml("");
        }
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public PageList<SysIndexLayoutManage> listJson(QueryFilter<SysIndexLayoutManage> queryFilter) {
        IUser user = ContextUtil.getCurrentUser();
        if (!user.isAdmin()) {
            List authIds = this.sysAuthUserManager.getAuthorizeIdsByUserMap("layoutManage");
            if (BeanUtils.isNotEmpty((Object)authIds)) {
                queryFilter.addFilter("portal_sys_layout_manage.id", (Object)authIds, QueryOP.IN, FieldRelation.AND, "auth");
                queryFilter.addFilter("portal_sys_layout_manage.create_by_", (Object)user.getUserId(), QueryOP.EQUAL, FieldRelation.OR, "auth");
            } else {
                queryFilter.addFilter("portal_sys_layout_manage.create_by_", (Object)user.getUserId(), QueryOP.EQUAL, FieldRelation.AND, "auth");
            }
            List sorter = queryFilter.getSorter();
            queryFilter.setSorter(new ArrayList());
            queryFilter.addFilter("portal_sys_layout_manage.create_by_", (Object)user.getUserId(), QueryOP.EQUAL, FieldRelation.OR, "manager");
            queryFilter.addFilter("auth.user_id_", (Object)user.getUserId(), QueryOP.EQUAL, FieldRelation.OR, "manager");
            IPage<String> idsPage = ((SysIndexLayoutManageDao)this.baseMapper).selectAuthIds((IPage<SysIndexLayoutManage>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<SysIndexLayoutManage>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
            if (idsPage.getTotal() == 0L) {
                return new PageList((IPage)new Page());
            }
            queryFilter = QueryFilter.build().withQuery(new QueryField("id", (Object)idsPage.getRecords(), QueryOP.IN));
            if (BeanUtils.isNotEmpty((Object)sorter)) {
                queryFilter.setSorter(sorter);
            }
        }
        return super.query(queryFilter);
    }

    @Override
    public List<SysIndexLayoutManage> getDataByAlias(List<String> alias, Boolean isAdmin) {
        ArrayList<SysIndexLayoutManage> list = new ArrayList<SysIndexLayoutManage>();
        alias.forEach(item -> {
            SysIndexLayoutManage layoutManage = this.getDataByAlias((String)item, isAdmin);
            if (layoutManage != null) {
                list.add(layoutManage);
            }
        });
        return list;
    }

    @Override
    public String checkLayoutAuth(String alias) {
        List<IndexLayoutVo> list = this.getCurrentAuthLayout(Optional.of("front"));
        list.addAll(this.getCurrentAuthLayout(Optional.of("manage")));
        list.addAll(this.getCurrentAuthLayout(Optional.of("mobile")));
        for (IndexLayoutVo indexLayoutVo : list) {
            if (!alias.equals(indexLayoutVo.getAlias())) continue;
            return alias;
        }
        return null;
    }

    @Override
    public SysIndexLayoutManage getDataByAlias(String alias, Boolean isAdmin) {
        if (StringUtil.isEmpty((String)(alias = this.checkLayoutAuth(alias)))) {
            return null;
        }
        List<SysIndexLayoutManage> list = this.getByAlias(alias);
        if (BeanUtils.isNotEmpty(list)) {
            if (list.size() > 1) {
                for (SysIndexLayoutManage sysIndexLayoutManage : list) {
                    if (!"datav".equals(sysIndexLayoutManage.getType())) continue;
                    return sysIndexLayoutManage;
                }
            } else if (list.size() == 1) {
                SysIndexLayoutManage sysIndexLayoutManage;
                PortalUserLayoutConfig layoutConfig;
                String acount = ContextUtil.getCurrentUserId();
                if (isAdmin.booleanValue()) {
                    acount = "1";
                }
                if (BeanUtils.isNotEmpty((Object)((Object)(layoutConfig = this.portalUserLayoutConfigManager.getByLayoutIdUserId((sysIndexLayoutManage = list.get(0)).getId(), acount))))) {
                    sysIndexLayoutManage.setLayoutConfig(layoutConfig.getConfigContent());
                    LocalDateTime lastDate = sysIndexLayoutManage.getUpdateTime() == null ? sysIndexLayoutManage.getCreateTime() : sysIndexLayoutManage.getUpdateTime();
                    int identifyChange = DateUtil.isDateLittle((LocalDateTime)layoutConfig.getCreateTime(), (LocalDateTime)lastDate) ? 2 : 1;
                    sysIndexLayoutManage.setIdentifyChange(identifyChange);
                }
                return sysIndexLayoutManage;
            }
        }
        return null;
    }

    @Override
    @Transactional
    public CommonResult<String> delete(String ids) {
        try {
            String[] aryIds = StringUtil.getStringAryByStr((String)ids);
            ArrayList<String> lauoutAliasList = new ArrayList<String>();
            for (String id : aryIds) {
                SysIndexLayoutManage layout = (SysIndexLayoutManage)this.get((Serializable)((Object)id));
                if (BeanUtils.isNotEmpty((Object)((Object)layout)) && layout.getIsDef() == 1) {
                    return new CommonResult(false, "\u5220\u9664\u5931\u8d25\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u7cfb\u7edf\u9ed8\u8ba4\u5e03\u5c40!", null);
                }
                if (!StringUtil.isNotEmpty((String)layout.getAlias())) continue;
                lauoutAliasList.add(layout.getAlias());
            }
            if (BeanUtils.isNotEmpty(lauoutAliasList)) {
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.select(new SFunction[]{SysMenu::getId, SysMenu::getRouteExtend});
                queryWrapper.like(SysMenu::getRouteExtend, (Object)"%indexLayout%");
                List list = this.sysMenuManager.list((Wrapper)queryWrapper);
                if (BeanUtils.isNotEmpty((Object)list)) {
                    HashSet sysMenuIds = new HashSet();
                    list.forEach(sysMenu -> lauoutAliasList.forEach(lauoutAlias -> {
                        if (sysMenu.getRouteExtend().indexOf(String.format("?alias=%s", lauoutAlias)) > 0) {
                            sysMenuIds.add(sysMenu.getId());
                        }
                    }));
                    if (BeanUtils.isNotEmpty(sysMenuIds)) {
                        this.sysMenuManager.removeByIds(sysMenuIds);
                        this.sysMenuManager.delUserMenuCache();
                    }
                }
            }
            this.removeByIds(aryIds);
            return new CommonResult(true, "\u5220\u9664\u5927\u5c4f\u6210\u529f!", null);
        }
        catch (Exception ex) {
            return new CommonResult(false, "\u5220\u9664\u5931\u8d25" + ex.getMessage(), null);
        }
    }

    @Override
    public Map<String, Object> design(String id, short layoutType) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        IUser user = ContextUtil.getCurrentUser();
        QueryFilter queryFilter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        queryFilter.addFilter("IS_PUBLIC", (Object)layoutType, QueryOP.EQUAL);
        List columnList = null;
        columnList = this.sysIndexColumnService.getAllByLayoutType(queryFilter);
        Map columnMap = this.sysIndexColumnService.getColumnMap2(columnList);
        SysIndexLayoutManage sysIndexLayoutManage = (SysIndexLayoutManage)this.get((Serializable)((Object)id));
        if (BeanUtils.isNotEmpty((Object)((Object)sysIndexLayoutManage)) && BeanUtils.isNotEmpty(sysIndexLayoutManage.getBannerTypeIds())) {
            QueryFilter filter = QueryFilter.build();
            filter.addFilter("classifyId", (Object)sysIndexLayoutManage.getBannerTypeIds().get(0), QueryOP.EQUAL);
            filter.getSorter().add(new FieldSort("sn", Direction.ASC));
            List portalNewsNotices = this.portalNewsNoticeManager.queryNoPage(filter);
            if (BeanUtils.isNotEmpty((Object)portalNewsNotices)) {
                sysIndexLayoutManage.setShowBannerId(((PortalNewsNotice)portalNewsNotices.get(0)).getRotatingDisplayPictures());
            }
        }
        map.put("columnMap", columnMap);
        map.put("sysIndexLayout", (Object)sysIndexLayoutManage);
        return map;
    }

    @Override
    public CommonResult<String> saveLayout(SysIndexLayoutManage indexLayout) {
        try {
            List<SysIndexLayoutManage> list = this.getByAlias(indexLayout.getAlias());
            if (BeanUtils.isEmpty((Object)indexLayout.getId())) {
                if (BeanUtils.isNotEmpty(list)) {
                    return new CommonResult(false, "\u5e03\u5c40\u522b\u540d\u3010" + indexLayout.getAlias() + "\u3011\u5df2\u5b58\u5728\u3002");
                }
                indexLayout.setId(UniqueIdUtil.getSuid());
                indexLayout.setEnable((short)1);
                this.create((Model)indexLayout);
                this.sysAuthUserManager.saveRights(indexLayout.getId(), "layoutManage", "[{\"type\":\"everyone\",\"title\":\"\u6240\u6709\u4eba\",\"checked\":true}]");
                this.sysAuthUserManager.delUserMenu();
                this.sysAuthUserManager.delPopupCache();
            } else {
                if (list.size() > 0 && !list.get(0).getId().equals(indexLayout.getId())) {
                    return new CommonResult(false, "\u5e03\u5c40\u522b\u540d\u3010" + indexLayout.getAlias() + "\u3011\u5df2\u5b58\u5728\u3002");
                }
                this.update((Model)indexLayout);
            }
            return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f", (Object)indexLayout.getId());
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, e.getMessage(), null);
        }
    }

    public CommonResult importDefaultLayout(String cacheFileId) throws IOException {
        String fileJson = ((SysIndexLayoutManageManagerImpl)AppUtil.getBean(this.getClass())).getImportFileFromCache(cacheFileId);
        if (BeanUtils.isEmpty((Object)fileJson)) {
            return new CommonResult(false, "\u5bfc\u5165\u7684\u6587\u4ef6\u5df2\u7ecf\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u5bfc\u5165\u3002");
        }
        this.importFile(fileJson);
        this.delImportFileFromCache(cacheFileId);
        return new CommonResult(true, "\u5bfc\u5165\u6210\u529f\uff01");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResult<String> importDefaultLayoutCheck(MultipartHttpServletRequest request) {
        MultipartFile file = request.getFile("file");
        String uzPath = "";
        if (file == null) {
            return new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff1a\u5bfc\u5165\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            String rootRealPath = (FileUtil.getIoTmpdir() + "/attachFiles/unZip/").replace("/", File.separator);
            FileUtil.createFolder((String)rootRealPath, (boolean)true);
            String name = file.getOriginalFilename();
            String fileDir = StringUtil.substringBeforeLast((String)name, (String)".");
            ZipUtil.unZipFile((MultipartFile)file, (String)rootRealPath);
            uzPath = rootRealPath + File.separator + fileDir;
            String fileJson = "";
            try {
                fileJson = FileUtil.readFile((String)(uzPath + File.separator + "defaultLayout.json"));
            }
            catch (RuntimeException e) {
                fileJson = FileUtil.readFile((String)(uzPath + File.separator + "orgLayout.json"));
            }
            fileJson = this.isImportFileRepeat(fileJson, uzPath);
            LinkedHashSet sysIndexLayoutRepeat = ThreadMsgUtil.getMapMsg2((String)"sysIndexLayoutRepeat");
            if (BeanUtils.isNotEmpty((Object)sysIndexLayoutRepeat)) {
                StringBuilder sb = new StringBuilder();
                sb.append("<div style='font-weight:bold;'>\u4ee5\u4e0b\u5e03\u5c40\u91cd\u590d\uff0c\u662f\u5426\u8986\u76d6\u66f4\u65b0\uff1a</div>");
                String msg = String.format("%s", String.join((CharSequence)"", sysIndexLayoutRepeat));
                sb.append(msg);
                String cacheFileId = UniqueIdUtil.getSuid();
                ((SysIndexLayoutManageManagerImpl)AppUtil.getBean(this.getClass())).putImportFileInCache(cacheFileId, fileJson);
                CommonResult commonResult = new CommonResult(false, sb.toString(), (Object)cacheFileId);
                return commonResult;
            }
            this.importFile(fileJson);
            CommonResult commonResult = new CommonResult(true, "\u5bfc\u5165\u6210\u529f\uff01");
            return commonResult;
        }
        catch (Exception e) {
            CommonResult commonResult = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
            return commonResult;
        }
        finally {
            File file1;
            if (StringUtil.isNotEmpty((String)uzPath) && (file1 = new File(uzPath)).exists()) {
                file1.delete();
            }
        }
    }

    @Override
    public List<ImportCheckResult> importLayoutCheck(List<SysIndexLayoutManage> layouts) {
        ArrayList<ImportCheckResult> results = new ArrayList<ImportCheckResult>();
        for (SysIndexLayoutManage layout : layouts) {
            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysIndexLayoutManage::getAlias, (Object)layout.getAlias());
            if (this.count((Wrapper)wrapper) > 0) {
                results.add(new ImportCheckResult(true, "datav".equals(layout.getType()) ? "\u5927\u5c4f" : "\u95e8\u6237", layout.getName()));
                continue;
            }
            results.add(new ImportCheckResult(false, "datav".equals(layout.getType()) ? "\u5927\u5c4f" : "\u95e8\u6237", layout.getName()));
        }
        return results;
    }

    @Override
    public CommonResult saveCopy(SysIndexLayoutManage layout) {
        SysIndexLayoutManage oldLayout = (SysIndexLayoutManage)this.get((Serializable)((Object)layout.getId()));
        if (StringUtil.isEmpty((String)layout.getAlias())) {
            throw new RuntimeException("\u5e03\u5c40\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (BeanUtils.isNotEmpty(this.getByAlias(layout.getAlias()))) {
            throw new RuntimeException("\u5e03\u5c40\u522b\u540d\u5df2\u5b58\u5728:" + layout.getAlias());
        }
        layout.setId(UniqueIdUtil.getSuid());
        layout.setEnable(oldLayout.getEnable());
        layout.setDesignHtml(oldLayout.getDesignHtml());
        layout.setIsDef((short)0);
        layout.setType(oldLayout.getType());
        layout.setLayoutType(oldLayout.getLayoutType());
        layout.setMemo(oldLayout.getMemo());
        layout.setTemplateHtml(oldLayout.getTemplateHtml());
        this.create((Model)layout);
        return new CommonResult(true, "\u590d\u5236\u5e03\u5c40\u6210\u529f", null);
    }

    @Override
    public List<IndexLayoutVo> getCurrentAuthLayout(Optional<String> from) {
        ArrayList<IndexLayoutVo> authVoList = new ArrayList<IndexLayoutVo>();
        IUser user = ContextUtil.getCurrentUser();
        String fromStr = from.orElse(null);
        if (BeanUtils.isNotEmpty((Object)user)) {
            if ("front".equals(fromStr)) {
                QueryFilter query = QueryFilter.build();
                query.addFilter("USER_ID", (Object)ContextUtil.getCurrentUserId(), QueryOP.EQUAL);
                query.addFilter("VALID_", (Object)1, QueryOP.EQUAL);
                List SysIndexMyLayouts = this.sysIndexMylayoutService.queryNoPage(query);
                if (BeanUtils.isNotEmpty((Object)SysIndexMyLayouts) && SysIndexMyLayouts.size() > 0) {
                    for (SysIndexMyLayout myLayout : SysIndexMyLayouts) {
                        IndexLayoutVo vo = new IndexLayoutVo("personal", myLayout.getId(), myLayout.getName(), "", myLayout.getDesignHtml(), (short)0, (short)2, "column");
                        authVoList.add(vo);
                    }
                }
            }
            List authList = new ArrayList();
            QueryFilter queryFilter = QueryFilter.build();
            queryFilter.setGroupRelation(FieldRelation.OR);
            queryFilter.withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
            queryFilter.addFilter("ENABLE", (Object)1, QueryOP.EQUAL);
            ArrayList<String> notInTypes = new ArrayList<String>();
            notInTypes.add("unit");
            notInTypes.add("template");
            queryFilter.addFilter("TYPE_", notInTypes, QueryOP.NOT_IN);
            short type = -1;
            if (StringUtil.isNotEmpty((String)fromStr)) {
                type = "manage".equals(fromStr) ? (short)0 : ("mobile".equals(fromStr) ? (short)1 : 2);
                queryFilter.addFilter("LAYOUT_TYPE", (Object)type, QueryOP.EQUAL);
            }
            if (!user.isAdmin()) {
                List authIds = this.sysAuthUserManager.getAuthorizeIdsByUserMap("layoutManage");
                if (BeanUtils.isNotEmpty((Object)authIds)) {
                    queryFilter.addFilter("ID", (Object)authIds, QueryOP.IN);
                } else {
                    queryFilter.addFilter("1", (Object)-1, QueryOP.EQUAL);
                }
                queryFilter.addFilter("IS_DEF", (Object)1, QueryOP.EQUAL, FieldRelation.AND, "defaultDef");
                if (type != -1) {
                    queryFilter.addFilter("LAYOUT_TYPE", (Object)type, QueryOP.EQUAL, FieldRelation.AND, "defaultDef");
                }
            }
            queryFilter.getSorter().add(0, new FieldSort("RANK_", Direction.ASC));
            PageList page = this.query(queryFilter);
            if (BeanUtils.isNotEmpty((Object)page)) {
                authList = page.getRows();
            }
            if (BeanUtils.isNotEmpty(authList)) {
                for (SysIndexLayoutManage layout : authList) {
                    IndexLayoutVo vo = new IndexLayoutVo("sys", layout.getId(), layout.getName(), layout.getAlias(), layout.getDesignHtml(), layout.getIsDef(), (short)2, StringUtil.isNotEmpty((String)layout.getType()) ? layout.getType() : "column");
                    vo.setBannerTypeIds(layout.getBannerTypeIds());
                    authVoList.add(vo);
                }
            }
        }
        return authVoList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResult<String> importDatav(MultipartHttpServletRequest request, String orgId, boolean isDefault) {
        MultipartFile file = request.getFile("file");
        String uzPath = "";
        try {
            String rootRealPath = (FileUtil.getIoTmpdir() + "/attachFiles/unZip/").replace("/", File.separator);
            FileUtil.createFolder((String)rootRealPath, (boolean)true);
            String name = file.getOriginalFilename();
            String fileDir = StringUtil.substringBeforeLast((String)name, (String)".");
            ZipUtil.unZipFile((MultipartFile)file, (String)rootRealPath);
            uzPath = rootRealPath + File.separator + fileDir;
            Boolean isRepeat = this.importDatavFile(uzPath, orgId, isDefault);
            if (!isRepeat.booleanValue()) {
                CommonResult commonResult = new CommonResult(true, "confirmUpload", (Object)Base64.getBase64Replace((String)uzPath));
                return commonResult;
            }
            CommonResult commonResult = new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
            return commonResult;
        }
        catch (Exception e) {
            CommonResult commonResult = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
            return commonResult;
        }
        finally {
            File file1;
            if (StringUtil.isNotEmpty((String)uzPath) && (file1 = new File(uzPath)).exists()) {
                file1.delete();
            }
        }
    }

    @Override
    public CommonResult<String> confirmImportData(String unZipFilePath, String status) {
        try {
            String json = FileUtil.readFile((String)(Base64.getFromBase64Replace((String)unZipFilePath) + File.separator + "orgLayout.json"));
            List list = (List)JsonUtil.toBean((String)json, List.class);
            ArrayList<SysIndexLayoutManage> sysIndexLayoutManages = new ArrayList<SysIndexLayoutManage>();
            for (Object o : list) {
                SysIndexLayoutManage layout = (SysIndexLayoutManage)((Object)JsonUtil.toBean((String)JsonUtil.toJson(o), SysIndexLayoutManage.class));
                sysIndexLayoutManages.add(layout);
            }
            for (SysIndexLayoutManage sysIndexLayoutManage : sysIndexLayoutManages) {
                SysIndexLayoutManage checkLayout = ((SysIndexLayoutManageDao)this.baseMapper).getDatavByAlias(sysIndexLayoutManage.getAlias());
                if (BeanUtils.isEmpty((Object)((Object)checkLayout))) {
                    sysIndexLayoutManage.setId(UniqueIdUtil.getSuid());
                    ((SysIndexLayoutManageDao)this.baseMapper).insert((Object)sysIndexLayoutManage);
                    continue;
                }
                if (!"cover".equals(status)) continue;
                sysIndexLayoutManage.setId(checkLayout.getId());
                ((SysIndexLayoutManageDao)this.baseMapper).updateById((Object)sysIndexLayoutManage);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException(e.getMessage());
        }
        return new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
    }

    private IndexLayoutVo getCacheLayout(short layoutType) {
        String[] values;
        String cacheValue;
        IndexLayoutVo vo = null;
        IUser user = ContextUtil.getCurrentUser();
        if (BeanUtils.isNotEmpty((Object)user) && StringUtil.isNotEmpty((String)(cacheValue = this.getCacheUserLayout(String.valueOf(layoutType), user.getUserId()))) && (values = cacheValue.split("_")).length == 2) {
            SysIndexLayoutManage layout;
            if ("personal".equals(values[0])) {
                SysIndexMyLayout myLayout = (SysIndexMyLayout)this.sysIndexMylayoutService.get((Serializable)((Object)values[1]));
                if (BeanUtils.isNotEmpty((Object)((Object)myLayout))) {
                    vo = new IndexLayoutVo("personal", myLayout.getId(), myLayout.getName(), "", myLayout.getDesignHtml(), (short)0, layoutType, "column");
                }
            } else if ("sys".equals(values[0]) && BeanUtils.isNotEmpty((Object)((Object)(layout = (SysIndexLayoutManage)this.get((Serializable)((Object)values[1])))))) {
                vo = new IndexLayoutVo("sys", layout.getId(), layout.getName(), layout.getAlias(), layout.getDesignHtml(), layout.getIsDef(), layoutType, StringUtil.isNotEmpty((String)layout.getType()) ? layout.getType() : "column");
            }
            if (BeanUtils.isNotEmpty(vo)) {
                return vo;
            }
        }
        return vo;
    }

    private SysIndexLayoutManage traceLayout(Short layoutType) throws IOException {
        IUser user = ContextUtil.getCurrentUser();
        SysIndexLayoutManage layout = null;
        if (BeanUtils.isNotEmpty((Object)user)) {
            List authIds;
            QueryFilter queryFilter = QueryFilter.build();
            queryFilter.setGroupRelation(FieldRelation.OR);
            queryFilter.withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
            queryFilter.addFilter("ENABLE", (Object)1, QueryOP.EQUAL);
            queryFilter.addFilter("LAYOUT_TYPE", (Object)layoutType, QueryOP.EQUAL);
            queryFilter.addFilter("IS_DEF", (Object)1, QueryOP.NOT_EQUAL);
            ArrayList<String> notInTypes = new ArrayList<String>();
            notInTypes.add("unit");
            notInTypes.add("template");
            queryFilter.addFilter("TYPE_", notInTypes, QueryOP.NOT_IN);
            if (!user.isAdmin() && BeanUtils.isNotEmpty((Object)(authIds = this.sysAuthUserManager.getAuthorizeIdsByUserMap("layoutManage")))) {
                queryFilter.addFilter("ID", (Object)authIds, QueryOP.IN);
            }
            queryFilter.getSorter().add(0, new FieldSort("RANK_", Direction.ASC));
            PageList page = this.query(queryFilter);
            if (BeanUtils.isNotEmpty((Object)page) && page.getRows().size() > 0) {
                layout = (SysIndexLayoutManage)((Object)page.getRows().get(0));
            }
        }
        if (BeanUtils.isEmpty(layout)) {
            try {
                if (0 == layoutType) {
                    layout = this.getDefaultLayoutManageByLayoutType("0");
                } else if (1 == layoutType) {
                    layout = this.getDefaultLayoutManageByLayoutType("1");
                } else if (2 == layoutType) {
                    layout = this.getDefaultLayoutManageByLayoutType("2");
                }
            }
            catch (Exception e) {
                throw new BaseException(e.getMessage(), (Throwable)e);
            }
        }
        return layout;
    }

    @Override
    public List<String> getAliasByIds(List<String> ids) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.select(new String[]{"alias"}).in((Object)"id", ids)).eq((Object)"enable", (Object)1);
        return ((SysIndexLayoutManageDao)this.baseMapper).selectList((Wrapper)queryWrapper).stream().filter(r -> StringUtil.isNotEmpty((String)r.getAlias())).map(SysIndexLayoutManage::getAlias).collect(Collectors.toList());
    }

    @Override
    public List<String> getDisabledLayoutManageAlias() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"alias"}).eq((Object)"enable", (Object)0);
        return ((SysIndexLayoutManageDao)this.baseMapper).selectList((Wrapper)queryWrapper).stream().filter(r -> StringUtil.isNotEmpty((String)r.getAlias())).map(SysIndexLayoutManage::getAlias).collect(Collectors.toList());
    }
}

