/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.persistence.manager.impl;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.Base64;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.column.model.SysIndexColumn;
import com.hotent.column.persistence.manager.SysIndexColumnManager;
import com.hotent.portal.model.SysIndexLayout;
import com.hotent.portal.model.SysIndexMyLayout;
import com.hotent.portal.params.MyLayoutVo;
import com.hotent.portal.persistence.dao.SysIndexMyLayoutDao;
import com.hotent.portal.persistence.manager.SysIndexLayoutManageManager;
import com.hotent.portal.persistence.manager.SysIndexLayoutManager;
import com.hotent.portal.persistence.manager.SysIndexMyLayoutManager;
import com.hotent.portal.util.PortalUtil;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import java.io.File;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="sysIndexMyLayoutManager")
public class SysIndexMyLayoutManagerImpl
extends BaseManagerImpl<SysIndexMyLayoutDao, SysIndexMyLayout>
implements SysIndexMyLayoutManager {
    @Resource
    SysIndexLayoutManageManager sysIndexLayoutManageManager;
    @Resource
    SysIndexColumnManager sysIndexColumnManager;
    @Resource
    private SysIndexLayoutManager sysIndexLayoutManager;
    @Resource
    private SysIndexColumnManager sysIndexColumnService;

    private String defaultIndexLayout() {
        String templateHtml = FileUtil.readFile((String)(PortalUtil.getIndexTemplatePath() + "templates" + File.separator + "defaultIndexPages.ftl"));
        return templateHtml;
    }

    @Override
    public SysIndexMyLayout getLayoutList(String userId, List<SysIndexColumn> columnList) {
        SysIndexMyLayout sysIndexMyLayout = ((SysIndexMyLayoutDao)this.baseMapper).getByUserId(userId);
        if (BeanUtils.isEmpty((Object)((Object)sysIndexMyLayout))) {
            return this.getDefaultIndexLayout();
        }
        String designHtml = "";
        try {
            designHtml = Base64.getFromBase64((String)sysIndexMyLayout.getDesignHtml());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        sysIndexMyLayout.setDesignHtml(this.sysIndexColumnManager.parserDesignHtml(designHtml, columnList));
        return sysIndexMyLayout;
    }

    private SysIndexMyLayout getDefaultIndexLayout() {
        SysIndexMyLayout sysIndexMyLayout = new SysIndexMyLayout();
        sysIndexMyLayout.setDesignHtml(this.sysIndexLayoutManageManager.getDefaultDesignHtml());
        return sysIndexMyLayout;
    }

    @Override
    public void save(String html, String designHtml, String userId) {
        SysIndexMyLayout sysIndexMyLayout = ((SysIndexMyLayoutDao)this.baseMapper).getByUserId(userId);
        if (BeanUtils.isEmpty((Object)((Object)sysIndexMyLayout))) {
            sysIndexMyLayout = new SysIndexMyLayout();
            sysIndexMyLayout.setDesignHtml(designHtml);
            sysIndexMyLayout.setTemplateHtml(html);
            sysIndexMyLayout.setId(UniqueIdUtil.getSuid());
            sysIndexMyLayout.setUserId(userId);
            this.create((Model)sysIndexMyLayout);
        } else {
            sysIndexMyLayout.setDesignHtml(designHtml);
            sysIndexMyLayout.setTemplateHtml(html);
            this.update((Model)sysIndexMyLayout);
        }
    }

    @Override
    public String obtainMyIndexData(String userId) {
        SysIndexMyLayout sysIndexMyLayout = ((SysIndexMyLayoutDao)this.baseMapper).getByUserId(userId);
        if (BeanUtils.isNotEmpty((Object)((Object)sysIndexMyLayout))) {
            return sysIndexMyLayout.getTemplateHtml();
        }
        String html = this.sysIndexLayoutManageManager.getMyHasRightsLayout();
        if (BeanUtils.isNotEmpty((Object)html)) {
            return html;
        }
        if (BeanUtils.isNotEmpty((Object)html)) {
            return html;
        }
        html = this.sysIndexLayoutManageManager.getManagerLayout();
        if (BeanUtils.isNotEmpty((Object)html)) {
            return html;
        }
        return "";
    }

    @Override
    public SysIndexMyLayout getByUser(String currentUserId) {
        return ((SysIndexMyLayoutDao)this.baseMapper).getByUserId(currentUserId);
    }

    @Override
    public String obtainIndexMyData(String layoutId) {
        SysIndexMyLayout sysIndexMyLayout = (SysIndexMyLayout)this.get((Serializable)((Object)layoutId));
        if (BeanUtils.isNotEmpty((Object)((Object)sysIndexMyLayout))) {
            return sysIndexMyLayout.getTemplateHtml();
        }
        String html = this.sysIndexLayoutManageManager.getMyHasRightsLayout();
        if (BeanUtils.isNotEmpty((Object)html)) {
            return html;
        }
        if (BeanUtils.isNotEmpty((Object)html)) {
            return html;
        }
        html = this.sysIndexLayoutManageManager.getManagerLayout();
        if (BeanUtils.isNotEmpty((Object)html)) {
            return html;
        }
        if (BeanUtils.isEmpty((Object)html)) {
            html = this.defaultIndexLayout();
        }
        return "";
    }

    @Override
    public void removeByUserId(String userId) {
        ((SysIndexMyLayoutDao)this.baseMapper).removeByUserId(userId);
    }

    @Override
    public void setValid(String id) {
        ((SysIndexMyLayoutDao)this.baseMapper).updateValid(0, ContextUtil.getCurrentUserId());
        ((SysIndexMyLayoutDao)this.baseMapper).setValid(id);
    }

    @Override
    public MyLayoutVo design() throws Exception {
        IUser user = ContextUtil.getCurrentUser();
        List list = this.sysIndexLayoutManager.list();
        QueryFilter queryFilter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        queryFilter.addFilter("IS_PUBLIC", (Object)0, QueryOP.EQUAL);
        HashMap params = new HashMap();
        List columnList = this.sysIndexColumnManager.getHashRightColumnList(queryFilter, params, Boolean.valueOf(true), (short)0, user);
        Map columnMap = this.sysIndexColumnManager.getColumnMap(columnList);
        SysIndexMyLayout sysIndexMyLayout = this.getLayoutList(user.getUserId(), columnList);
        for (SysIndexLayout sysIndexLayout : list) {
            sysIndexLayout.setTemplateHtml(Base64.getFromBase64((String)sysIndexLayout.getTemplateHtml()));
        }
        return new MyLayoutVo(list, columnMap, sysIndexMyLayout);
    }

    @Override
    public Map<String, Object> designMyLayout(String id, short layoutType) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        IUser user = ContextUtil.getCurrentUser();
        QueryFilter queryFilter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        queryFilter.addFilter("IS_PUBLIC", (Object)layoutType, QueryOP.EQUAL);
        HashMap params = new HashMap();
        List columnList = this.sysIndexColumnService.getHashRightColumnList(queryFilter, params, Boolean.valueOf(false), layoutType, user);
        Map columnMap = this.sysIndexColumnService.getColumnMap2(columnList);
        SysIndexMyLayout sysIndexMyLayout = (SysIndexMyLayout)this.get((Serializable)((Object)id));
        map.put("columnMap", columnMap);
        map.put("sysIndexLayout", (Object)sysIndexMyLayout);
        return map;
    }

    @Override
    public Map<String, List<SysIndexColumn>> getColumnMap(QueryFilter<SysIndexColumn> queryFilter, String param) throws Exception {
        IUser user = ContextUtil.getCurrentUser();
        Map params = JsonUtil.toMap((String)param);
        PageBean pageBean = queryFilter.getPageBean();
        pageBean.setPageSize(PageBean.WITHOUT_PAGE.intValue());
        queryFilter.setPageBean(pageBean);
        queryFilter.addFilter("IS_PUBLIC", (Object)0, QueryOP.EQUAL);
        List columnList = this.sysIndexColumnManager.getHashRightColumnList(queryFilter, params, Boolean.valueOf(true), (short)0, user);
        Map columnMap = this.sysIndexColumnManager.getColumnMap(columnList);
        return columnMap;
    }

    @Override
    public SysIndexMyLayout getSysIndexMyLayout(QueryFilter<SysIndexColumn> queryFilter, String param) throws Exception {
        IUser user = ContextUtil.getCurrentUser();
        String userId = user.getUserId();
        Map params = JsonUtil.toMap((String)param);
        PageBean pageBean = queryFilter.getPageBean();
        pageBean.setPageSize(PageBean.WITHOUT_PAGE.intValue());
        queryFilter.setPageBean(pageBean);
        queryFilter.addFilter("IS_PUBLIC", (Object)0, QueryOP.EQUAL);
        List columnList = this.sysIndexColumnManager.getHashRightColumnList(queryFilter, params, Boolean.valueOf(true), (short)0, user);
        SysIndexMyLayout sysIndexMyLayout = this.getLayoutList(userId, columnList);
        return sysIndexMyLayout;
    }
}

