/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.service.impl;

import com.hotent.base.exception.BaseException;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.Direction;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.FieldSort;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.portal.model.SysIndexLayoutManage;
import com.hotent.portal.model.SysIndexMyLayout;
import com.hotent.portal.params.IndexLayoutVo;
import com.hotent.portal.persistence.manager.SysIndexLayoutManageManager;
import com.hotent.portal.persistence.manager.SysIndexMyLayoutManager;
import com.hotent.portal.service.MainPortalService;
import com.hotent.sys.persistence.manager.SysAuthUserManager;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class MainPortalServiceImpl
implements MainPortalService {
    @Resource
    SysIndexLayoutManageManager sysIndexlayoutManageService;
    @Resource
    private SysAuthUserManager sysAuthUserManager;
    @Resource
    SysIndexMyLayoutManager sysIndexMylayoutService;

    @Override
    public CommonResult<IndexLayoutVo> myHome() {
        IndexLayoutVo vo = null;
        vo = this.getCacheLayout((short)0);
        if (BeanUtils.isNotEmpty((Object)vo)) {
            return new CommonResult(true, "\u83b7\u53d6\u6210\u529f\uff01", (Object)vo);
        }
        SysIndexLayoutManage layout = null;
        try {
            layout = this.traceLayout((short)0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (BeanUtils.isNotEmpty((Object)((Object)layout))) {
            vo = new IndexLayoutVo("sys", layout.getId(), layout.getName(), layout.getAlias(), layout.getDesignHtml(), layout.getIsDef(), (short)0, StringUtil.isNotEmpty((String)layout.getType()) ? layout.getType() : "column");
            vo.setBannerTypeIds(layout.getBannerTypeIds());
        } else {
            vo = new IndexLayoutVo();
            vo.setDesignHtml("");
        }
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public CommonResult<IndexLayoutVo> myVueFrontHome() throws IOException {
        IndexLayoutVo vo = null;
        vo = this.getCacheLayout((short)2);
        if (BeanUtils.isNotEmpty((Object)vo)) {
            return new CommonResult(true, "\u83b7\u53d6\u6210\u529f\uff01", (Object)vo);
        }
        QueryFilter query = QueryFilter.build();
        query.addFilter("USER_ID", (Object)ContextUtil.getCurrentUserId(), QueryOP.EQUAL);
        query.addFilter("VALID_", (Object)1, QueryOP.EQUAL);
        List SysIndexMyLayouts = this.sysIndexMylayoutService.queryNoPage(query);
        if (BeanUtils.isNotEmpty((Object)SysIndexMyLayouts) && SysIndexMyLayouts.size() > 0) {
            SysIndexMyLayout myLayout = (SysIndexMyLayout)((Object)SysIndexMyLayouts.get(0));
            vo = new IndexLayoutVo("personal", myLayout.getId(), myLayout.getName(), "", myLayout.getDesignHtml(), (short)0, (short)2, "column");
        } else {
            SysIndexLayoutManage layout = this.traceLayout((short)2);
            if (BeanUtils.isEmpty((Object)((Object)layout))) {
                vo = new IndexLayoutVo();
                vo.setDesignHtml("");
            } else {
                vo = new IndexLayoutVo("sys", layout.getId(), layout.getName(), layout.getAlias(), layout.getDesignHtml(), layout.getIsDef(), (short)2, StringUtil.isNotEmpty((String)layout.getType()) ? layout.getType() : "column");
            }
        }
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public CommonResult<IndexLayoutVo> myMobileHome() throws IOException {
        IndexLayoutVo vo = null;
        vo = this.getCacheLayout((short)1);
        if (BeanUtils.isNotEmpty((Object)vo)) {
            return new CommonResult(true, "\u83b7\u53d6\u6210\u529f\uff01", (Object)vo);
        }
        SysIndexLayoutManage layout = this.traceLayout((short)1);
        if (BeanUtils.isNotEmpty((Object)((Object)layout))) {
            vo = new IndexLayoutVo("sys", layout.getId(), layout.getName(), layout.getAlias(), layout.getDesignHtml(), layout.getIsDef(), (short)1, StringUtil.isNotEmpty((String)layout.getType()) ? layout.getType() : "column");
            vo.setBannerTypeIds(layout.getBannerTypeIds());
        } else {
            vo = new IndexLayoutVo();
            vo.setDesignHtml("");
        }
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f\uff01", (Object)vo);
    }

    private IndexLayoutVo getCacheLayout(short layoutType) {
        String[] values;
        String cacheValue;
        IndexLayoutVo vo = null;
        IUser user = ContextUtil.getCurrentUser();
        if (BeanUtils.isNotEmpty((Object)user) && StringUtil.isNotEmpty((String)(cacheValue = this.sysIndexlayoutManageService.getCacheUserLayout(String.valueOf(layoutType), user.getUserId()))) && (values = cacheValue.split("_")).length == 2) {
            SysIndexLayoutManage layout;
            if ("personal".equals(values[0])) {
                SysIndexMyLayout myLayout = (SysIndexMyLayout)this.sysIndexMylayoutService.get((Serializable)((Object)values[1]));
                if (BeanUtils.isNotEmpty((Object)((Object)myLayout))) {
                    vo = new IndexLayoutVo("personal", myLayout.getId(), myLayout.getName(), "", myLayout.getDesignHtml(), (short)0, layoutType, "column");
                }
            } else if ("sys".equals(values[0]) && BeanUtils.isNotEmpty((Object)((Object)(layout = (SysIndexLayoutManage)this.sysIndexlayoutManageService.get((Serializable)((Object)values[1])))))) {
                vo = new IndexLayoutVo("sys", layout.getId(), layout.getName(), layout.getAlias(), layout.getDesignHtml(), layout.getIsDef(), layoutType, StringUtil.isNotEmpty((String)layout.getType()) ? layout.getType() : "column");
                vo.setBannerTypeIds(layout.getBannerTypeIds());
            }
            if (BeanUtils.isNotEmpty(vo)) {
                return vo;
            }
        }
        return vo;
    }

    private SysIndexLayoutManage traceLayout(Short layoutType) throws IOException {
        IUser user = ContextUtil.getCurrentUser();
        SysIndexLayoutManage layout = null;
        if (BeanUtils.isNotEmpty((Object)user)) {
            List authIds;
            QueryFilter queryFilter = QueryFilter.build();
            queryFilter.setGroupRelation(FieldRelation.OR);
            queryFilter.withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
            queryFilter.addFilter("ENABLE", (Object)1, QueryOP.EQUAL);
            queryFilter.addFilter("LAYOUT_TYPE", (Object)layoutType, QueryOP.EQUAL);
            queryFilter.addFilter("IS_DEF", (Object)1, QueryOP.NOT_EQUAL);
            queryFilter.addFilter("TYPE_", (Object)"column", QueryOP.EQUAL);
            if (!user.isAdmin() && BeanUtils.isNotEmpty((Object)(authIds = this.sysAuthUserManager.getAuthorizeIdsByUserMap("layoutManage")))) {
                queryFilter.addFilter("ID", (Object)authIds, QueryOP.IN);
            }
            queryFilter.getSorter().add(0, new FieldSort("RANK_", Direction.ASC));
            PageList page = this.sysIndexlayoutManageService.query(queryFilter);
            if (BeanUtils.isNotEmpty((Object)page) && page.getRows().size() > 0) {
                layout = (SysIndexLayoutManage)((Object)page.getRows().get(0));
            }
        }
        if (BeanUtils.isEmpty(layout)) {
            try {
                if (0 == layoutType) {
                    layout = this.sysIndexlayoutManageService.getDefaultLayoutManageByLayoutType("0");
                } else if (1 == layoutType) {
                    layout = this.sysIndexlayoutManageService.getDefaultLayoutManageByLayoutType("1");
                } else if (2 == layoutType) {
                    layout = this.sysIndexlayoutManageService.getDefaultLayoutManageByLayoutType("2");
                }
            }
            catch (Exception e) {
                throw new BaseException(e.getMessage(), (Throwable)e);
            }
        }
        return layout;
    }
}

