/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.service.impl;

import cn.hutool.core.lang.Assert;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.BeanUtils;
import com.hotent.portal.model.SysMessage;
import com.hotent.portal.params.MessaboxVo;
import com.hotent.portal.persistence.manager.MessageReadManager;
import com.hotent.portal.persistence.manager.SysMessageManager;
import com.hotent.portal.service.MessageReceiverService;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import com.hotent.uc.api.service.IUserService;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class MessageReceiverImpl
implements MessageReceiverService {
    @Resource
    SysMessageManager sysMessageManager;
    @Resource
    IUserService iUserService;
    @Resource
    MessageReadManager messageReadManager;

    @Override
    public PageList<SysMessage> listJson(QueryFilter queryFilter) {
        queryFilter.addFilter("receiverId", (Object)ContextUtil.getCurrentUserId(), QueryOP.EQUAL);
        PageList<SysMessage> sysMessageList = this.sysMessageManager.getMsgByUserId(queryFilter);
        List list = sysMessageList.getRows();
        PageList newSysMessageList = new PageList();
        newSysMessageList.setRows(list);
        newSysMessageList.setPage(sysMessageList.getPage());
        newSysMessageList.setPageSize(sysMessageList.getPageSize());
        newSysMessageList.setTotal(sysMessageList.getTotal());
        return newSysMessageList;
    }

    @Override
    public MessaboxVo getMessBoxInfo(String account) {
        IUser user = this.iUserService.getUserByAccount(account);
        int messCount = 0;
        int noReadMessCount = 0;
        if (BeanUtils.isNotEmpty((Object)user)) {
            QueryFilter queryFilter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
            queryFilter.addFilter("receiverId", (Object)ContextUtil.getCurrentUserId(), QueryOP.EQUAL);
            PageList<SysMessage> sysMessageList = this.sysMessageManager.getMsgByUserId(queryFilter);
            messCount = (int)sysMessageList.getTotal();
            if (messCount > 0) {
                for (SysMessage message : sysMessageList.getRows()) {
                    if (!BeanUtils.isEmpty((Object)message.getReceiveTime())) continue;
                    ++noReadMessCount;
                }
            }
        }
        return new MessaboxVo(messCount, noReadMessCount);
    }

    @Override
    public void mark(List<String> ids) {
        Assert.notEmpty(ids, (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.messageReadManager.batchAddMessageRead(ids, ContextUtil.getCurrentUser());
    }

    @Override
    public void markAll() {
        QueryFilter queryFilter = QueryFilter.build();
        PageBean pageBean = new PageBean(Integer.valueOf(1), Integer.valueOf(-1), Boolean.valueOf(true));
        queryFilter.setPageBean(pageBean);
        queryFilter.addFilter("receiverId", (Object)ContextUtil.getCurrentUserId(), QueryOP.EQUAL);
        queryFilter.addFilter("receiveTime", (Object)1, QueryOP.EQUAL, FieldRelation.AND, "filterTime");
        PageList<SysMessage> messages = this.sysMessageManager.getMsgByUserId(queryFilter);
        List<String> messageIds = messages.getRows().stream().map(SysMessage::getId).collect(Collectors.toList());
        this.messageReadManager.batchAddMessageRead(messageIds, ContextUtil.getCurrentUser());
    }
}

