/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.service.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.exception.NotFoundException;
import com.hotent.base.exception.RequiredException;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.jms.JmsActor;
import com.hotent.base.jms.JmsMessage;
import com.hotent.base.jms.JmsProducer;
import com.hotent.base.jms.Notice;
import com.hotent.base.jms.NoticeMessageType;
import com.hotent.base.template.impl.FreeMarkerEngine;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.portal.model.MsgTemplate;
import com.hotent.portal.persistence.manager.MsgTemplateManager;
import com.hotent.portal.service.TemplateService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Service;

@Service
public class TemplateServiceImpl
implements TemplateService {
    private Log logger = LogFactory.getLog(TemplateServiceImpl.class);
    @Resource
    FreeMarkerEngine freeMarkerEngine;
    @Resource
    MsgTemplateManager msgTemplateManager;
    @Resource
    JmsProducer jmsProducer;
    @Resource
    UCFeignService ucFeignService;

    @Override
    public void sendNotice2Jms(Notice notice) {
        this.jmsProducer.sendToQueue((Object)notice);
    }

    @Override
    public void sendNotice(Notice notice) {
        ArrayNode users;
        if (BeanUtils.isEmpty((Object)notice)) {
            throw new RequiredException("The args 'Notice' is required.");
        }
        NoticeMessageType[] messageTypes = notice.getMessageTypes();
        if (messageTypes.length == 0) {
            throw new RequiredException("The 'messageTypes' in 'Notice' is required.");
        }
        ArrayList<JmsActor> receiver = notice.getReceiver();
        if (BeanUtils.isEmpty((Object)receiver) && BeanUtils.isNotEmpty((Object)notice.getReceivers()) && BeanUtils.isNotEmpty((Object)(users = this.ucFeignService.getUserByAccounts(StringUtils.join((Object[])notice.getReceivers(), (String)","))))) {
            receiver = new ArrayList<JmsActor>();
            for (JsonNode j : users) {
                JmsActor actor = this.convertUserObject2JmsActor(j);
                if (!BeanUtils.isNotEmpty((Object)actor)) continue;
                receiver.add(actor);
            }
        }
        if (receiver.size() == 0) {
            throw new RequiredException("The 'receivers' in 'Notice' is required.");
        }
        JmsProducer jmsProducer = (JmsProducer)AppUtil.getBean(JmsProducer.class);
        String templateKey = notice.getTemplateKey();
        String templateType = notice.getTemplateType();
        if (notice.isUseTemplate() && StringUtil.isEmpty((String)templateKey) && StringUtil.isEmpty((String)templateType)) {
            throw new RequiredException("Nor the 'templateKey' and the 'templateType' is empty, so we can not find out the template to send with.");
        }
        JsonNode sender = null;
        String senderAccount = notice.getSender();
        if (StringUtil.isNotEmpty((String)senderAccount)) {
            sender = this.ucFeignService.loadUserByUsername(senderAccount);
        }
        String subject = notice.getSubject();
        String content = notice.getContent();
        String plainContent = "";
        String templateAlias = "";
        String smsTemplateNo = "";
        String voiceTemplateNo = "";
        Map vars = notice.getVars();
        if (notice.isUseTemplate()) {
            MsgTemplate templateVo = null;
            if (StringUtil.isNotEmpty((String)templateKey)) {
                templateVo = this.getTemplate(templateKey);
                if (BeanUtils.isEmpty((Object)((Object)templateVo))) {
                    throw new NotFoundException(String.format("The is no template key was '%s'.", templateKey));
                }
            } else {
                templateVo = this.getDefaultTemplate(templateType);
                if (BeanUtils.isEmpty((Object)((Object)templateVo))) {
                    throw new NotFoundException(String.format("The is no default template for type: '%s'.", templateType));
                }
            }
            subject = this.parseSubject(templateVo, vars);
            content = this.parseHtmlContent(templateVo, vars);
            plainContent = this.parsePlainContent(templateVo, vars);
            templateAlias = templateVo.getKey();
            if (StringUtil.isNotEmpty((String)templateVo.getSmsTemplateNo())) {
                smsTemplateNo = templateVo.getSmsTemplateNo();
            }
            if (StringUtil.isNotEmpty((String)templateVo.getVoiceTemplateNo())) {
                voiceTemplateNo = templateVo.getVoiceTemplateNo();
            }
        }
        for (NoticeMessageType type : messageTypes) {
            JmsMessage jmsMessage = null;
            jmsMessage = type.isPlain() != false && notice.isUseTemplate() ? new JmsMessage(templateAlias, subject, plainContent, this.convertUserObject2JmsActor(sender), receiver, type.key()) : new JmsMessage(templateAlias, subject, content, this.convertUserObject2JmsActor(sender), receiver, type.key());
            if (StringUtil.isNotEmpty((String)smsTemplateNo)) {
                jmsMessage.setSmsTemplateNo(smsTemplateNo);
            }
            if (StringUtil.isNotEmpty((String)voiceTemplateNo)) {
                jmsMessage.setVoiceTemplateNo(voiceTemplateNo);
            }
            if (notice.isBatchSend()) {
                jmsMessage.setExtendVars(vars);
                jmsProducer.sendToQueue((Object)jmsMessage);
                continue;
            }
            notice.getVars();
            String needParseContent = jmsMessage.getContent();
            String needParseSubject = jmsMessage.getSubject();
            for (JmsActor receive : receiver) {
                vars.put("receiver", receive.getName());
                vars.put("receiverId", receive.getId());
                try {
                    jmsMessage.setContent(this.freeMarkerEngine.parseByTemplate(needParseContent, (Object)vars));
                    jmsMessage.setSubject(this.freeMarkerEngine.parseByTemplate(needParseSubject, (Object)vars));
                }
                catch (Exception e) {
                    this.logger.error((Object)String.format("parse template fail:'%s'.", e.getMessage()));
                }
                jmsMessage.setReceivers(new ArrayList<JmsActor>(Arrays.asList(receive)));
                jmsMessage.setExtendVars(vars);
                jmsProducer.sendToQueue((Object)jmsMessage);
            }
        }
    }

    @Override
    public MsgTemplate getTemplate(String templateKey) {
        MsgTemplate msgTemplate = this.msgTemplateManager.getByKey(templateKey);
        return msgTemplate;
    }

    @Override
    public MsgTemplate getDefaultTemplate(String typeKey) {
        MsgTemplate msgTemplate = this.msgTemplateManager.getDefault(typeKey.toLowerCase());
        if (msgTemplate == null) {
            throw new RuntimeException("There is not a default msgTemplate in table.");
        }
        return msgTemplate;
    }

    @Override
    public String parseSubject(MsgTemplate templateVo, Map<String, Object> vars) {
        String subject = "";
        try {
            subject = this.freeMarkerEngine.parseByTemplate(templateVo.getSubject(), vars);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.debug((Object)e.getMessage());
        }
        return subject;
    }

    @Override
    public String parsePlainContent(MsgTemplate templateVo, Map<String, Object> vars) {
        String content = "";
        try {
            content = this.freeMarkerEngine.parseByTemplate(templateVo.getPlain(), vars);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.debug((Object)e.getMessage());
        }
        return content;
    }

    public JmsActor convertUserObject2JmsActor(JsonNode jsonNode) {
        if (BeanUtils.isEmpty((Object)jsonNode) || !jsonNode.isObject()) {
            return null;
        }
        ObjectNode userNode = (ObjectNode)jsonNode;
        String userId = JsonUtil.getString((JsonNode)userNode, (String)"userId");
        if (StringUtil.isEmpty((String)userId)) {
            userId = JsonUtil.getString((JsonNode)userNode, (String)"id");
        }
        String account = JsonUtil.getString((JsonNode)userNode, (String)"account");
        String fullname = JsonUtil.getString((JsonNode)userNode, (String)"fullname");
        String email = JsonUtil.getString((JsonNode)userNode, (String)"email");
        String mobile = JsonUtil.getString((JsonNode)userNode, (String)"mobile");
        String weixin = JsonUtil.getString((JsonNode)userNode, (String)"weixin");
        String clientId = JsonUtil.getString((JsonNode)userNode, (String)"clientId");
        String clientToken = JsonUtil.getString((JsonNode)userNode, (String)"clientToken");
        return new JmsActor(userId, account, fullname, email, mobile, weixin, clientId, clientToken);
    }

    @Override
    public String parseHtmlContent(MsgTemplate templateVo, Map<String, Object> vars) {
        String content = "";
        try {
            content = this.freeMarkerEngine.parseByTemplate(templateVo.getHtml(), vars);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.debug((Object)e.getMessage());
        }
        return content;
    }
}

