/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.util;

import com.hotent.base.util.Dom4jUtil;
import com.hotent.base.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.util.ResourceUtils;

public class MessageTypeUtil {
    private Document doc = null;
    private static MessageTypeUtil config = null;
    private static Lock lock = new ReentrantLock();

    private MessageTypeUtil() throws FileNotFoundException {
        File file = ResourceUtils.getFile((String)"classpath:conf/messageType.xml");
        FileInputStream is = new FileInputStream(file);
        this.doc = Dom4jUtil.loadXml((InputStream)is);
        try {
            ((InputStream)is).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static MessageTypeUtil getInstance() throws FileNotFoundException {
        if (config == null) {
            lock.lock();
            try {
                if (config == null) {
                    config = new MessageTypeUtil();
                }
            }
            finally {
                lock.unlock();
            }
        }
        return config;
    }

    private Map<String, String> getMap(String type) {
        HashMap<String, String> msgMap = new HashMap<String, String>();
        Element root = this.doc.getRootElement();
        Element messageEl = (Element)root.selectSingleNode("message");
        List elements = messageEl.elements();
        for (int i = 0; i < elements.size(); ++i) {
            Element message = (Element)elements.get(i);
            if (StringUtil.isNotEmpty((String)type)) {
                String typeValue = message.attributeValue(type);
                if (!"1".equals(typeValue)) continue;
                String name = message.attributeValue("name");
                String key = message.attributeValue("key");
                msgMap.put(key, name);
                continue;
            }
            String name = message.attributeValue("name");
            String key = message.attributeValue("key");
            msgMap.put(key, name);
        }
        return msgMap;
    }

    private String getVal(String key) {
        String template = "message/msgtype[@key='%s']";
        String filter = String.format(template, key);
        Element root = this.doc.getRootElement();
        Element el = (Element)root.selectSingleNode(filter);
        if (el != null) {
            return el.attributeValue("name");
        }
        return "\u7cfb\u7edf\u6d88\u606f";
    }

    public static Map<String, String> getDisPlayMsgType() throws FileNotFoundException {
        return MessageTypeUtil.getInstance().getMap("display");
    }

    public static Map<String, String> getReplyMsgType() throws FileNotFoundException {
        return MessageTypeUtil.getInstance().getMap("reply");
    }

    public static Map<String, String> getAllMsgType() throws FileNotFoundException {
        return MessageTypeUtil.getInstance().getMap("");
    }

    public static String getValue(String key) throws FileNotFoundException {
        return MessageTypeUtil.getInstance().getVal(key);
    }
}

