/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.redis.service;

import com.hotent.redis.util.StringRedisSerializer;
import java.util.Arrays;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RedisCacheKey {
    private final RedisSerializer prefixSerializer1 = new StringRedisSerializer();
    private final Object keyElement;
    private String cacheName;
    private boolean usePrefix = true;
    private final RedisSerializer serializer;

    public RedisCacheKey(Object keyElement, RedisSerializer serializer) {
        Assert.notNull((Object)keyElement, (String)"\u7f13\u5b58key\u4e0d\u80fd\u4e3aNULL");
        Assert.notNull((Object)serializer, (String)"key\u7684\u5e8f\u5217\u5316\u5668\u4e0d\u80fd\u4e3aNULL");
        this.keyElement = keyElement;
        this.serializer = serializer;
    }

    public String getKey() {
        return new String(this.getKeyBytes());
    }

    public byte[] getKeyBytes() {
        byte[] rawKey = this.serializeKeyElement();
        if (!this.usePrefix) {
            return rawKey;
        }
        byte[] prefix = this.getPrefix();
        byte[] prefixedKey = Arrays.copyOf(prefix, prefix.length + rawKey.length);
        System.arraycopy(rawKey, 0, prefixedKey, prefix.length, rawKey.length);
        return prefixedKey;
    }

    private byte[] serializeKeyElement() {
        if (this.serializer == null && this.keyElement instanceof byte[]) {
            return (byte[])this.keyElement;
        }
        return this.serializer.serialize(this.keyElement);
    }

    public byte[] getPrefix() {
        return this.prefixSerializer1.serialize((Object)(StringUtils.isEmpty((Object)this.cacheName) ? "" : this.cacheName.concat(":")));
    }

    public RedisCacheKey cacheName(String cacheName) {
        this.cacheName = cacheName;
        return this;
    }

    public RedisCacheKey usePrefix(boolean usePrefix) {
        this.usePrefix = usePrefix;
        return this;
    }
}

