/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.redis.service;

import com.hotent.base.enums.ResponseErrorEnums;
import com.hotent.base.exception.BaseException;
import com.hotent.base.service.RedisLock;
import com.hotent.base.util.AppUtil;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;
import org.aspectj.lang.ProceedingJoinPoint;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Primary;
import org.springframework.integration.redis.util.RedisLockRegistry;
import org.springframework.stereotype.Service;

@Service
@Primary
@ConditionalOnProperty(value={"redis.enable"}, matchIfMissing=true)
public class RedisLockImpl
implements RedisLock {
    private Logger logger = LoggerFactory.getLogger(RedisLockImpl.class);

    public Object commitRedisLock(String key, ProceedingJoinPoint joinPoint) throws Throwable {
        RedisLockRegistry redisLockRegistry = (RedisLockRegistry)AppUtil.getBean(RedisLockRegistry.class);
        Lock lock = redisLockRegistry.obtain((Object)key);
        try {
            if (lock.tryLock(100L, TimeUnit.MILLISECONDS)) {
                this.logger.info("lock is ready");
                Object object = joinPoint.proceed();
                return object;
            }
        }
        catch (Exception e) {
            this.logger.error("obtain lock error", (Throwable)e);
            throw new BaseException(ResponseErrorEnums.REPEATABLE_COMMIT, (Throwable)e);
        }
        finally {
            try {
                lock.unlock();
            }
            catch (IllegalStateException e) {
                throw new BaseException(ResponseErrorEnums.REPEATABLE_COMMIT, (Throwable)e);
            }
        }
        throw new BaseException(ResponseErrorEnums.REPEATABLE_COMMIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean methodRedisLock(String key, Supplier<Boolean> supplier) {
        RedisLockRegistry redisLockRegistry = (RedisLockRegistry)AppUtil.getBean(RedisLockRegistry.class);
        Lock lock = redisLockRegistry.obtain((Object)key);
        int maxCountSloop = 10;
        for (int i = 0; i < maxCountSloop; ++i) {
            try {
                if (!lock.tryLock(100L, TimeUnit.MILLISECONDS)) continue;
                Boolean bl = supplier.get();
                return bl;
            }
            catch (Exception e) {
                this.logger.error("obtain lock error", (Throwable)e);
                continue;
            }
            finally {
                try {
                    lock.unlock();
                }
                catch (IllegalStateException e) {
                    this.logger.error("unlock error", (Throwable)e);
                }
            }
        }
        return false;
    }

    public Object executeWithLock(String key, ProceedingJoinPoint joinPoint, long tryTime, String lockFailMsg) throws Throwable {
        RedissonClient redissonClient = (RedissonClient)AppUtil.getBean(RedissonClient.class);
        RLock lock = redissonClient.getLock(key);
        this.logger.info("try add lock:{}", (Object)key);
        boolean lockSuccess = false;
        try {
            if (lock.tryLock(tryTime, TimeUnit.MILLISECONDS)) {
                lockSuccess = true;
                this.logger.info("lock success:{}", (Object)key);
                Object object = joinPoint.proceed();
                return object;
            }
        }
        catch (Exception e) {
            this.logger.info("lock fail:{}", (Object)key);
            throw new BaseException(lockFailMsg, (Throwable)e);
        }
        finally {
            if (lockSuccess && lock.isLocked()) {
                try {
                    lock.unlock();
                }
                catch (IllegalStateException e) {
                    throw new BaseException(lockFailMsg, (Throwable)e);
                }
            }
        }
        throw new BaseException(lockFailMsg);
    }
}

