/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.redis.caffeine;

import com.hotent.redis.caffeine.CacheMessage;
import com.hotent.redis.service.RedisCaffeineCacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.core.RedisTemplate;

public class CacheMessageListener
implements MessageListener {
    private final Logger logger = LoggerFactory.getLogger(CacheMessageListener.class);
    private RedisTemplate<String, Object> redisTemplate;
    private RedisCaffeineCacheManager redisCaffeineCacheManager;

    public CacheMessageListener(RedisTemplate<String, Object> redisTemplate, RedisCaffeineCacheManager redisCaffeineCacheManager) {
        this.redisTemplate = redisTemplate;
        this.redisCaffeineCacheManager = redisCaffeineCacheManager;
    }

    public void onMessage(Message message, byte[] pattern) {
        CacheMessage cacheMessage = (CacheMessage)this.redisTemplate.getValueSerializer().deserialize(message.getBody());
        this.logger.debug("recevice a redis topic message, clear local cache, the cacheName is {}, the key is {}", (Object)cacheMessage.getCacheName(), cacheMessage.getKey());
        this.redisCaffeineCacheManager.clearLocal(cacheMessage.getCacheName(), cacheMessage.getKey());
    }
}

