/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.redis.conf;

import com.hotent.base.util.StringUtil;
import com.hotent.redis.caffeine.CacheMessageListener;
import com.hotent.redis.service.RedisCacheManager;
import com.hotent.redis.service.RedisCaffeineCacheManager;
import com.hotent.redis.util.CustomRedisSerialize;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.redisson.spring.starter.RedissonProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.integration.redis.util.RedisLockRegistry;
import org.springframework.util.ReflectionUtils;

@Configuration
@ConditionalOnProperty(value={"redis.enable"}, matchIfMissing=true)
@ConditionalOnClass(value={Redisson.class})
@AutoConfigureAfter(value={RedisAutoConfiguration.class})
@EnableConfigurationProperties(value={RedissonProperties.class})
public class RedisConfig {
    private static final long DEFAULT_EXPIRE_AFTER = 30000L;
    @Autowired
    private RedissonProperties redissonProperties;
    @Autowired
    private RedisProperties redisProperties;
    @Autowired
    private ApplicationContext ctx;

    @Bean
    public RedisTemplate<String, Object> redisTemplate(LettuceConnectionFactory redisConnectionFactory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setValueSerializer((RedisSerializer)new CustomRedisSerialize());
        redisTemplate.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setHashValueSerializer((RedisSerializer)new CustomRedisSerialize());
        redisTemplate.setConnectionFactory((RedisConnectionFactory)redisConnectionFactory);
        return redisTemplate;
    }

    @Bean(name={"redisCacheManager"})
    @Primary
    @ConditionalOnProperty(prefix="redis.caffeine", name={"enabled"}, havingValue="false")
    public RedisCacheManager redisCacheManager(RedisTemplate<String, Object> redisTemplate) {
        RedisCacheManager redisCacheManager = new RedisCacheManager(redisTemplate);
        return redisCacheManager;
    }

    @Bean
    public RedisLockRegistry redisLockRegistry(RedisConnectionFactory redisConnectionFactory) {
        return new RedisLockRegistry(redisConnectionFactory, "eip:redis:lock", 30000L);
    }

    @Bean(name={"redisCaffeineCacheManager"})
    @Primary
    @ConditionalOnProperty(prefix="redis.caffeine", name={"enabled"}, havingValue="true", matchIfMissing=false)
    public RedisCaffeineCacheManager redisCaffeineCacheManager(RedisTemplate<String, Object> redisTemplate) {
        return new RedisCaffeineCacheManager(redisTemplate);
    }

    @Bean
    @ConditionalOnProperty(prefix="redis.caffeine", name={"enabled"}, havingValue="true", matchIfMissing=false)
    public RedisMessageListenerContainer redisMessageListenerContainer(RedisTemplate<String, Object> redisTemplate, RedisCaffeineCacheManager redisCaffeineCacheManager) {
        RedisMessageListenerContainer redisMessageListenerContainer = new RedisMessageListenerContainer();
        redisMessageListenerContainer.setConnectionFactory(redisTemplate.getConnectionFactory());
        CacheMessageListener cacheMessageListener = new CacheMessageListener(redisTemplate, redisCaffeineCacheManager);
        redisMessageListenerContainer.addMessageListener((MessageListener)cacheMessageListener, (Topic)new ChannelTopic("cache:redis:caffeine:topic"));
        return redisMessageListenerContainer;
    }

    @Bean(destroyMethod="shutdown")
    @ConditionalOnMissingBean(value={RedissonClient.class})
    public RedissonClient redisson() throws IOException {
        int timeout;
        Config config = null;
        Method clusterMethod = ReflectionUtils.findMethod(RedisProperties.class, (String)"getCluster");
        Method timeoutMethod = ReflectionUtils.findMethod(RedisProperties.class, (String)"getTimeout");
        Object timeoutValue = ReflectionUtils.invokeMethod((Method)timeoutMethod, (Object)this.redisProperties);
        if (null == timeoutValue) {
            timeout = 0;
        } else if (!(timeoutValue instanceof Integer)) {
            Method millisMethod = ReflectionUtils.findMethod(timeoutValue.getClass(), (String)"toMillis");
            timeout = ((Long)ReflectionUtils.invokeMethod((Method)millisMethod, (Object)timeoutValue)).intValue();
        } else {
            timeout = (Integer)timeoutValue;
        }
        if (this.redissonProperties.getConfig() != null) {
            try {
                InputStream is = this.getConfigStream();
                config = Config.fromJSON((InputStream)is);
            }
            catch (IOException e) {
                try {
                    InputStream is = this.getConfigStream();
                    config = Config.fromYAML((InputStream)is);
                }
                catch (IOException e1) {
                    throw new IllegalArgumentException("Can't parse config", e1);
                }
            }
        } else if (this.redisProperties.getSentinel() != null) {
            Method nodesMethod = ReflectionUtils.findMethod(RedisProperties.Sentinel.class, (String)"getNodes");
            Object nodesValue = ReflectionUtils.invokeMethod((Method)nodesMethod, (Object)this.redisProperties.getSentinel());
            String[] nodes = nodesValue instanceof String ? this.convert(Arrays.asList(((String)nodesValue).split(","))) : this.convert((List)nodesValue);
            config = new Config();
            SentinelServersConfig sentinelServersConfig = config.useSentinelServers();
            sentinelServersConfig.setMasterName(this.redisProperties.getSentinel().getMaster()).addSentinelAddress(nodes).setDatabase(this.redisProperties.getDatabase()).setConnectTimeout(timeout);
            if (StringUtil.isNotEmpty((String)this.redisProperties.getPassword())) {
                sentinelServersConfig.setPassword(this.redisProperties.getPassword());
            }
        } else if (clusterMethod != null && ReflectionUtils.invokeMethod((Method)clusterMethod, (Object)this.redisProperties) != null) {
            Object clusterObject = ReflectionUtils.invokeMethod((Method)clusterMethod, (Object)this.redisProperties);
            Method nodesMethod = ReflectionUtils.findMethod(clusterObject.getClass(), (String)"getNodes");
            List nodesObject = (List)ReflectionUtils.invokeMethod((Method)nodesMethod, (Object)clusterObject);
            String[] nodes = this.convert(nodesObject);
            config = new Config();
            ClusterServersConfig clusterServersConfig = config.useClusterServers();
            clusterServersConfig.addNodeAddress(nodes).setConnectTimeout(timeout);
            if (StringUtil.isNotEmpty((String)this.redisProperties.getPassword())) {
                clusterServersConfig.setPassword(this.redisProperties.getPassword());
            }
        } else {
            config = new Config();
            String prefix = "redis://";
            Method method = ReflectionUtils.findMethod(RedisProperties.class, (String)"isSsl");
            if (method != null && ((Boolean)ReflectionUtils.invokeMethod((Method)method, (Object)this.redisProperties)).booleanValue()) {
                prefix = "rediss://";
            }
            SingleServerConfig singleServerConfig = config.useSingleServer();
            ((SingleServerConfig)singleServerConfig.setAddress(prefix + this.redisProperties.getHost() + ":" + this.redisProperties.getPort()).setConnectTimeout(timeout)).setDatabase(this.redisProperties.getDatabase());
            if (StringUtil.isNotEmpty((String)this.redisProperties.getPassword())) {
                singleServerConfig.setPassword(this.redisProperties.getPassword());
            }
        }
        return Redisson.create((Config)config);
    }

    private String[] convert(List<String> nodesObject) {
        ArrayList<String> nodes = new ArrayList<String>(nodesObject.size());
        for (String node : nodesObject) {
            if (!node.startsWith("redis://") && !node.startsWith("rediss://")) {
                nodes.add("redis://" + node);
                continue;
            }
            nodes.add(node);
        }
        return nodes.toArray(new String[nodes.size()]);
    }

    private InputStream getConfigStream() throws IOException {
        Resource resource = this.ctx.getResource(this.redissonProperties.getConfig());
        InputStream is = resource.getInputStream();
        return is;
    }
}

