/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.redis.service;

import com.hotent.base.cache.ICache;
import com.hotent.base.cache.impl.AbstractCacheManager;
import com.hotent.base.cache.impl.CaffeineCache;
import com.hotent.base.cache.setting.CacheSetting;
import com.hotent.base.util.StringUtil;
import com.hotent.redis.caffeine.CacheMessage;
import com.hotent.redis.service.RedisCaffeineCache;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.Assert;

public class RedisCaffeineCacheManager
extends AbstractCacheManager {
    private final Logger logger = LoggerFactory.getLogger(RedisCaffeineCacheManager.class);
    private RedisTemplate<String, Object> redisTemplate;

    public RedisCaffeineCacheManager(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    protected ICache getMissingCache(String name, CacheSetting cacheSetting) {
        this.logger.debug("create cache instance, the cache name is : {}", (Object)name);
        return new RedisCaffeineCache(name, this.redisTemplate, new CaffeineCache(name, cacheSetting.getFirstCacheSetting()), cacheSetting.getSecondaryCacheSetting(), cacheSetting.getOnlyUseRedis());
    }

    public void clearCascadeByKey(String key) {
        Assert.notNull((Object)key, (String)"\u6839\u636ekey\u6e05\u9664\u7f13\u5b58\u65f6\uff0ckey\u4e0d\u80fd\u4e3a\u7a7a");
        Set keys = this.redisTemplate.keys((Object)(key + "*"));
        this.redisTemplate.delete((Collection)keys);
        this.redisTemplate.convertAndSend("cache:redis:caffeine:topic", (Object)new CacheMessage(null, null));
        this.cacheContainer.forEach((k, map) -> {
            if (StringUtil.isNotEmpty((String)k) && (k.equals(key) || k.startsWith(key + ":"))) {
                map.forEach((i, cache) -> ((RedisCaffeineCache)((Object)((Object)cache))).clearLocal(k));
            }
        });
    }

    public synchronized void clearLocal(String cacheName, Object key) {
        if (StringUtil.isNotEmpty((String)cacheName)) {
            if (this.cacheContainer.containsKey(cacheName)) {
                ConcurrentMap cacheConcurrentMap = (ConcurrentMap)this.cacheContainer.get(cacheName);
                cacheConcurrentMap.forEach((i, cache) -> ((RedisCaffeineCache)((Object)cache)).clearLocal(key));
            }
        } else {
            this.cacheContainer.forEach(new BiConsumer<String, ConcurrentMap<String, ICache>>(){

                @Override
                public void accept(String key, ConcurrentMap<String, ICache> stringICacheConcurrentMap) {
                    stringICacheConcurrentMap.forEach((i, cache) -> ((RedisCaffeineCache)((Object)cache)).clearLocal(null));
                }
            });
        }
    }
}

