/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.redis.util;

import com.hotent.base.util.JsonUtil;
import java.nio.charset.Charset;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.util.Assert;

public class StringRedisSerializer
implements RedisSerializer<Object> {
    private final Charset charset;
    private final String target = "\"";
    private final String replacement = "";

    public StringRedisSerializer() {
        this(Charset.forName("UTF8"));
    }

    public StringRedisSerializer(Charset charset) {
        Assert.notNull((Object)charset, (String)"Charset must not be null!");
        this.charset = charset;
    }

    public String deserialize(byte[] bytes) {
        return bytes == null ? null : new String(bytes, this.charset);
    }

    public byte[] serialize(Object object) {
        String string = JsonUtil.toJsonString((Object)object);
        if (string == null) {
            return null;
        }
        string = string.replace("\"", "");
        return string.getBytes(this.charset);
    }
}

