/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.service.choreography.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.datasource.DatabaseContext;
import com.hotent.base.exception.BaseException;
import com.hotent.base.groovy.GroovyScriptEngine;
import com.hotent.base.manager.CommonManager;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryOP;
import com.hotent.base.sqlbuilder.SqlBuilderModel;
import com.hotent.base.sqlbuilder.service.ISqlBuilderService;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.MapUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.service.choreography.dao.PortalDbInterfaceDao;
import com.hotent.service.choreography.datatrans.ITypeConvert;
import com.hotent.service.choreography.datatrans.ResultTransform;
import com.hotent.service.choreography.manager.PortalConnectionManagerManager;
import com.hotent.service.choreography.manager.PortalDbInterfaceManager;
import com.hotent.service.choreography.model.PortalDbInterface;
import com.hotent.service.choreography.model.PortalInterfaceManager;
import com.hotent.service.choreography.util.CustomUtil;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PortalDbInterfaceManagerImpl
extends BaseManagerImpl<PortalDbInterfaceDao, PortalDbInterface>
implements PortalDbInterfaceManager {
    private static Pattern regex = Pattern.compile("\\{(\\w+)\\}", 66);
    @Resource
    DatabaseContext databaseContext;
    @Resource
    GroovyScriptEngine groovyScriptEngine;
    @Resource
    ISqlBuilderService sqlBuilderService;
    @Resource
    CommonManager commonManager;
    @Resource
    PortalConnectionManagerManager portalConnectionManagerManager;

    @Override
    public PortalDbInterface getDetail(String id) {
        PortalDbInterface portalDbInterface = (PortalDbInterface)this.get((Serializable)((Object)id));
        return portalDbInterface;
    }

    @Override
    @Transactional
    public void createOrUpdate(PortalDbInterface portalDbInterface) {
        this.saveOrUpdate((Object)portalDbInterface);
    }

    @Override
    public PortalDbInterface getDataByRefId(String refId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"ref_id_", (Object)refId);
        return (PortalDbInterface)((Object)((PortalDbInterfaceDao)this.baseMapper).selectOne((Wrapper)wrapper));
    }

    @Override
    public void deleteDataByRefId(String refId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"ref_id_", (Object)refId);
        ((PortalDbInterfaceDao)this.baseMapper).delete((Wrapper)wrapper);
    }

    @Override
    public PageList getData(PortalInterfaceManager portalInterfaceManager, String queryData, String resultData, String paramData) {
        Object list = null;
        String id = portalInterfaceManager.getId();
        PortalDbInterface dbDetail = this.getDataByRefId(id);
        if (BeanUtils.isEmpty((Object)((Object)dbDetail))) {
            return null;
        }
        try {
            return this.getListData(dbDetail, queryData, resultData, paramData, this.databaseContext.getDbTypeByAlias(dbDetail.getDsalias()), 1);
        }
        catch (IOException e1) {
            throw new RuntimeException("\u64cd\u4f5c\u5931\u8d25\uff1a\u6570\u636e\u6e90\uff1a" + dbDetail.getDsalias() + "\u5931\u8d25\u539f\u56e0\uff1a" + e1.getMessage());
        }
    }

    private PageList getListData(PortalDbInterface dbDetail, String queryData, String resultData, String paramData, String dsType, int pageNo) throws IOException {
        String sql = "";
        sql = PortalDbInterface.DS_TYPE_SEARCH.equals(dbDetail.getType()) ? this.getSearchSql(dbDetail, queryData, resultData, paramData, dsType) : this.getCustomSql(dbDetail, queryData, resultData, paramData, dsType);
        if (!"postgresql".equals(dsType)) {
            sql = sql.replaceAll("\"", "");
        }
        PageList pageList = null;
        List list = null;
        String finalSql = sql;
        if (dbDetail.getNeedPage() == 1) {
            int pageSize = dbDetail.getPageSize();
            pageNo = pageNo <= 0 ? 1 : pageNo;
            pageSize = pageSize <= 0 ? 10 : pageSize;
            PageBean page = new PageBean(Integer.valueOf(pageNo), Integer.valueOf(pageSize));
            pageList = (PageList)this.databaseContext.switchDS(dbDetail.getDsalias(), () -> this.commonManager.query(finalSql, page), e -> {
                throw new BaseException(e.getMessage());
            });
        } else {
            list = (List)this.databaseContext.switchDS(dbDetail.getDsalias(), () -> this.commonManager.query(finalSql), e -> {
                throw new BaseException(e.getMessage());
            });
            pageList = new PageList(list);
        }
        ResultTransform.transform(pageList.getRows(), new ITypeConvert(){

            @Override
            public Object processValue(Object obj) {
                Map map = null;
                if (BeanUtils.isNotEmpty((Object)obj)) {
                    map = (Map)obj;
                    for (String key : map.keySet()) {
                        if (BeanUtils.isEmpty(map.get(key)) || !Date.class.isAssignableFrom(map.get(key).getClass()) && !java.util.Date.class.isAssignableFrom(map.get(key).getClass())) continue;
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        try {
                            map.put(key, sdf.format(map.get(key)));
                        }
                        catch (Exception exception) {}
                    }
                }
                return map;
            }
        });
        return pageList;
    }

    private String getSearchSql(PortalDbInterface dbDetail, String queryData, String resultData, String paramData, String dsType) throws IOException {
        String sql = "";
        if ("1".equals(dbDetail.getSqlBuildType())) {
            HashMap params = new HashMap();
            if (StringUtil.isNotEmpty((String)paramData)) {
                ArrayNode json = (ArrayNode)JsonUtil.toJsonNode((String)paramData);
                HashMap<String, String> tmp = new HashMap<String, String>();
                boolean isEmpty = true;
                for (JsonNode jsonObj : json) {
                    tmp.put(jsonObj.get("key").asText(), jsonObj.get("value").asText());
                    isEmpty = false;
                }
                if (!isEmpty) {
                    params.put("map", tmp);
                    params.putAll(tmp);
                }
            }
            sql = this.groovyScriptEngine.executeString(dbDetail.getDiySql(), params);
        } else {
            SqlBuilderModel model = this.buildSqlBuilderModel(dbDetail, queryData, resultData, paramData, dsType);
            sql = this.sqlBuilderService.getSql(model);
        }
        return sql;
    }

    private String getCustomSql(PortalDbInterface dbDetail, String queryData, String resultData, String paramData, String dsType) throws IOException {
        ArrayNode inputList;
        int i;
        String sql = dbDetail.getDiySql();
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtil.isNotEmpty((String)paramData)) {
            ArrayNode jArray = (ArrayNode)JsonUtil.toJsonNode((String)paramData);
            for (i = 0; i < jArray.size(); ++i) {
                ObjectNode jSONObject = (ObjectNode)JsonUtil.toJsonNode((Object)jArray.get(i));
                if (!BeanUtils.isNotEmpty((Object)jSONObject.get("value"))) continue;
                params.put(jSONObject.get("key").asText(), jSONObject.get("value").asText());
            }
        }
        ArrayNode confilJA = (ArrayNode)JsonUtil.toJsonNode((String)dbDetail.getConditionfield());
        if (StringUtil.isNotEmpty((String)queryData) && BeanUtils.isNotEmpty((Object)(inputList = (ArrayNode)JsonUtil.toJsonNode((String)queryData)))) {
            ArrayNode inputNode = JsonUtil.getMapper().createArrayNode();
            for (JsonNode qObj : inputList) {
                ObjectNode newCondi = JsonUtil.getMapper().createObjectNode();
                newCondi.put("field", qObj.get("key").asText());
                newCondi.put("condition", "EQ");
                newCondi.put("dbType", "varchar");
                newCondi.put("defaultType", qObj.get("type").asText());
                newCondi.put("defaultValue", qObj.get("value").asText());
                inputNode.add((JsonNode)newCondi);
            }
            confilJA = inputNode;
        }
        for (i = 0; i < confilJA.size(); ++i) {
            ObjectNode jObject = (ObjectNode)JsonUtil.toJsonNode((Object)confilJA.get(i));
            String field = jObject.get("field").asText();
            String defaultType = jObject.get("defaultType").asText();
            String defaultValue = jObject.get("defaultValue").asText();
            String dbType = jObject.get("dbType").asText();
            String condition = jObject.get("condition").asText();
            Object value = null;
            ObjectNode jsonObject = JsonUtil.getMapper().createObjectNode();
            jsonObject.put("field", field);
            jsonObject.put("op", condition);
            jsonObject.put("dbType", dbType);
            value = CustomUtil.buildValue(field, defaultType, defaultValue, params);
            if (BeanUtils.isEmpty((Object)value) || value instanceof String && (StringUtil.isEmpty((String)value.toString()) || value.toString().equals("|"))) continue;
            if (condition.equals(QueryOP.BETWEEN.toString())) {
                value = CustomUtil.handleDateBetweenValue(value);
            }
            params.put(field, value);
        }
        sql = PortalDbInterfaceManagerImpl.replaceStr(sql, params);
        return sql;
    }

    private SqlBuilderModel buildSqlBuilderModel(PortalDbInterface dbDetail, String queryData, String resultData, String paramData, String dsType) throws IOException {
        ArrayNode inputList;
        SqlBuilderModel sqlBuilderModel = new SqlBuilderModel();
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, String> relationParams = new HashMap<String, String>();
        HashMap<String, String> conditionParams = new HashMap<String, String>();
        if (StringUtil.isNotEmpty((String)paramData)) {
            ArrayNode jArray = (ArrayNode)JsonUtil.toJsonNode((String)paramData);
            for (int i = 0; i < jArray.size(); ++i) {
                ObjectNode jSONObject = (ObjectNode)JsonUtil.toJsonNode((Object)jArray.get(i));
                if (!BeanUtils.isNotEmpty((Object)jSONObject.get("value"))) continue;
                params.put(jSONObject.get("key").asText(), jSONObject.get("value").asText());
                if (jSONObject.has("relation")) {
                    relationParams.put(JsonUtil.getString((JsonNode)jSONObject, (String)"key"), JsonUtil.getString((JsonNode)jSONObject, (String)"relation"));
                }
                if (!jSONObject.has("condition")) continue;
                conditionParams.put(JsonUtil.getString((JsonNode)jSONObject, (String)"key"), JsonUtil.getString((JsonNode)jSONObject, (String)"condition"));
            }
        }
        sqlBuilderModel.setDbType(dsType);
        sqlBuilderModel.setFromName(dbDetail.getObjName());
        if (StringUtil.isEmpty((String)resultData)) {
            sqlBuilderModel.setResultField((ArrayNode)JsonUtil.toJsonNode((String)dbDetail.getResultfield()));
        } else {
            sqlBuilderModel.setResultField((ArrayNode)JsonUtil.toJsonNode((String)resultData));
        }
        ArrayNode conditionField = JsonUtil.getMapper().createArrayNode();
        ArrayNode confilJA = (ArrayNode)JsonUtil.toJsonNode((String)dbDetail.getConditionfield());
        if (StringUtil.isNotEmpty((String)queryData) && BeanUtils.isNotEmpty((Object)(inputList = (ArrayNode)JsonUtil.toJsonNode((String)queryData)))) {
            ArrayNode inputNode = JsonUtil.getMapper().createArrayNode();
            for (JsonNode qObj : inputList) {
                ObjectNode newCondi = JsonUtil.getMapper().createObjectNode();
                newCondi.put("field", qObj.get("key").asText());
                newCondi.put("condition", "EQ");
                newCondi.put("dbType", "varchar");
                newCondi.put("defaultType", qObj.get("type").asText());
                newCondi.put("defaultValue", qObj.get("value").asText());
                inputNode.add((JsonNode)newCondi);
            }
            confilJA = inputNode;
        }
        for (int i = 0; i < confilJA.size(); ++i) {
            ObjectNode jObject = (ObjectNode)JsonUtil.toJsonNode((Object)confilJA.get(i));
            String field = jObject.get("field").asText();
            String defaultType = jObject.get("defaultType").asText();
            String defaultValue = jObject.get("defaultValue").asText();
            String dbType = jObject.get("dbType").asText();
            String condition = jObject.get("condition").asText();
            Object value = null;
            ObjectNode jsonObject = JsonUtil.getMapper().createObjectNode();
            jsonObject.put("field", field);
            jsonObject.put("op", condition);
            jsonObject.put("dbType", dbType);
            value = CustomUtil.buildValue(field, defaultType, defaultValue, params);
            if (value != null && MapUtil.containsIgnoreKey(relationParams, (String)field)) {
                jsonObject.put("relation", MapUtil.getIgnoreCase(relationParams, (String)field).toString());
            }
            if (value != null && MapUtil.containsIgnoreKey(conditionParams, (String)field)) {
                jsonObject.put("op", MapUtil.getIgnoreCase(conditionParams, (String)field).toString());
            }
            if (BeanUtils.isEmpty((Object)value) || value instanceof String && (StringUtil.isEmpty((String)value.toString()) || value.toString().equals("|"))) continue;
            if (condition.equals(QueryOP.BETWEEN.toString())) {
                value = CustomUtil.handleDateBetweenValue(value);
            }
            jsonObject.set("value", JsonUtil.toJsonNode((Object)value));
            conditionField.add((JsonNode)jsonObject);
        }
        sqlBuilderModel.setConditionField(conditionField);
        sqlBuilderModel.setSortField((ArrayNode)JsonUtil.toJsonNode((String)dbDetail.getSortfield()));
        return sqlBuilderModel;
    }

    private static String replaceStr(String str, Map<String, Object> map) {
        if (StringUtil.isEmpty((String)str)) {
            return "";
        }
        Matcher regexMatcher = regex.matcher(str);
        while (regexMatcher.find()) {
            String key = regexMatcher.group(1);
            String toReplace = regexMatcher.group(0);
            if (!BeanUtils.isNotEmpty((Object)map.get(key))) continue;
            String val = map.get(key).toString();
            if (val == null) {
                val = "";
            }
            str = str.replace(toReplace, val);
        }
        return str;
    }
}

