/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.service.choreography.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.ApiTokenUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.service.choreography.dao.PortalRestfulInterfaceDao;
import com.hotent.service.choreography.manager.PortalConnectionManagerManager;
import com.hotent.service.choreography.manager.PortalRestfulInterfaceManager;
import com.hotent.service.choreography.manager.PortalRestfulManageManager;
import com.hotent.service.choreography.model.PortalConnectionManager;
import com.hotent.service.choreography.model.PortalInterfaceManager;
import com.hotent.service.choreography.model.PortalRestfulInterface;
import com.hotent.service.choreography.model.PortalRestfulManage;
import com.hotent.service.choreography.util.CustomUtil;
import com.hotent.service.choreography.util.FluentUtil;
import com.hotent.service.choreography.util.ParserUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class PortalRestfulInterfaceManagerImpl
extends BaseManagerImpl<PortalRestfulInterfaceDao, PortalRestfulInterface>
implements PortalRestfulInterfaceManager {
    @Resource
    PortalConnectionManagerManager portalConnectionManagerManager;
    @Resource
    PortalRestfulManageManager portalRestfulManageManager;
    @Resource
    PortalFeignService portalFeignService;

    @Override
    public PortalRestfulInterface getDetail(String id) {
        PortalRestfulInterface portalRestfulInterface = (PortalRestfulInterface)this.get((Serializable)((Object)id));
        return portalRestfulInterface;
    }

    @Override
    @Transactional
    public void createOrUpdate(PortalRestfulInterface portalRestfulInterface) {
        this.saveOrUpdate((Object)portalRestfulInterface);
    }

    @Override
    public PortalRestfulInterface getDataByRefId(String refId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"ref_id_", (Object)refId);
        return (PortalRestfulInterface)((Object)((PortalRestfulInterfaceDao)this.baseMapper).selectOne((Wrapper)wrapper));
    }

    @Override
    public void deleteDataByRefId(String refId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"ref_id_", (Object)refId);
        ((PortalRestfulInterfaceDao)this.baseMapper).delete((Wrapper)wrapper);
    }

    @Override
    public Object getData(PortalInterfaceManager portalInterfaceManager, String queryData, String resultData, String paramData) {
        ServletRequestAttributes attributes;
        HttpServletRequest request;
        String token;
        String id = portalInterfaceManager.getId();
        PortalRestfulInterface restfulDetail = this.getDataByRefId(id);
        if (BeanUtils.isEmpty((Object)((Object)restfulDetail))) {
            return null;
        }
        ArrayList<ObjectNode> treeParamNodeList = new ArrayList<ObjectNode>();
        String heardStr = "";
        String tokenAuth = restfulDetail.getTokenAuth();
        if (StringUtil.isNotEmpty((String)tokenAuth) && "1".equals(tokenAuth) && StringUtil.isNotEmpty((String)(token = (request = (attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest()).getHeader("Authorization")))) {
            ObjectNode objectNode = JsonUtil.getMapper().createObjectNode();
            objectNode.put("Authorization", token);
            heardStr = JsonUtil.toJsonString((Object)objectNode);
        }
        String refId = portalInterfaceManager.getRefId();
        PortalRestfulManage restfulManage = null;
        ObjectNode portalBizSystem = null;
        if (portalInterfaceManager.getSourceType() == 1) {
            portalBizSystem = this.portalFeignService.getBizSystem(refId);
            if (portalBizSystem != null) {
                restfulManage = new PortalRestfulManage();
                String rootAddress = portalBizSystem.get("rootAddress") == null ? "" : portalBizSystem.get("rootAddress").asText();
                restfulManage.setBaseUrl(rootAddress);
            }
        } else {
            PortalConnectionManager portalConnectionManager = (PortalConnectionManager)this.portalConnectionManagerManager.get((Serializable)((Object)refId));
            if (BeanUtils.isNotEmpty((Object)((Object)portalConnectionManager))) {
                String restfulId = portalConnectionManager.getRefId();
                restfulManage = (PortalRestfulManage)this.portalRestfulManageManager.get((Serializable)((Object)restfulId));
            }
        }
        if (BeanUtils.isEmpty(restfulManage)) {
            return null;
        }
        try {
            ArrayNode inputList;
            String apiRestParams = "";
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (StringUtil.isNotEmpty((String)paramData)) {
                JsonNode paramDataNode = JsonUtil.toJsonNode((String)paramData);
                if (paramDataNode instanceof ArrayNode) {
                    ArrayNode jArray = (ArrayNode)paramDataNode;
                    for (int i = 0; i < jArray.size(); ++i) {
                        ObjectNode jSONObject = (ObjectNode)JsonUtil.toJsonNode((Object)jArray.get(i));
                        if (!BeanUtils.isNotEmpty((Object)jSONObject.get("value"))) continue;
                        if (StringUtil.isNotEmpty((String)JsonUtil.getString((JsonNode)jSONObject, (String)"treeParam", (String)""))) {
                            treeParamNodeList.add(jSONObject);
                            continue;
                        }
                        params.put(jSONObject.get("key").asText(), jSONObject.get("value").asText());
                    }
                } else {
                    apiRestParams = paramData;
                }
            }
            String baseUrl = restfulManage.getBaseUrl();
            String url = baseUrl + restfulDetail.getUrl();
            String requestType = restfulDetail.getRequestType();
            String header = restfulDetail.getHeader();
            if (StringUtil.isNotEmpty((String)heardStr)) {
                header = heardStr;
            }
            HashMap<String, Object> conditionMap = new HashMap<String, Object>();
            ArrayNode confilJA = null;
            if (StringUtil.isNotEmpty((String)restfulDetail.getConditionfield())) {
                confilJA = (ArrayNode)JsonUtil.toJsonNode((String)restfulDetail.getConditionfield());
            }
            if (StringUtil.isNotEmpty((String)queryData) && BeanUtils.isNotEmpty((Object)(inputList = (ArrayNode)JsonUtil.toJsonNode((String)queryData)))) {
                ArrayNode inputNode = JsonUtil.getMapper().createArrayNode();
                for (JsonNode qObj : inputList) {
                    ObjectNode newCondi = JsonUtil.getMapper().createObjectNode();
                    newCondi.put("field", qObj.get("key").asText());
                    newCondi.put("condition", "EQ");
                    newCondi.put("dbType", "varchar");
                    newCondi.put("defaultType", qObj.get("type").asText());
                    newCondi.put("defaultValue", qObj.get("value").asText());
                    inputNode.add((JsonNode)newCondi);
                }
                confilJA = inputNode;
            }
            if (BeanUtils.isNotEmpty((Object)confilJA)) {
                for (int i = 0; i < confilJA.size(); ++i) {
                    ObjectNode jObject = (ObjectNode)JsonUtil.toJsonNode((Object)confilJA.get(i));
                    String field = jObject.get("field").asText();
                    String defaultType = jObject.get("defaultType").asText();
                    String defaultValue = jObject.get("defaultValue").asText();
                    String condition = jObject.get("condition").asText();
                    Object value = null;
                    value = CustomUtil.buildValue(field, defaultType, defaultValue, params);
                    if (BeanUtils.isEmpty((Object)value) || value instanceof String && (StringUtil.isEmpty((String)value.toString()) || value.toString().equals("|"))) continue;
                    if (condition.equals(QueryOP.BETWEEN.toString())) {
                        value = CustomUtil.handleDateBetweenValue(value);
                    }
                    conditionMap.put(field, value.toString());
                }
            }
            if (BeanUtils.isNotEmpty(treeParamNodeList)) {
                for (ObjectNode paramNode : treeParamNodeList) {
                    conditionMap.put(JsonUtil.getString((JsonNode)paramNode, (String)"key", (String)""), JsonUtil.getString((JsonNode)paramNode, (String)"value", (String)""));
                }
            }
            if (portalInterfaceManager.getSourceType() == 1 && portalBizSystem != null) {
                StringBuilder urlBizSystem = new StringBuilder(url);
                ObjectNode headerNode = StringUtil.isEmpty((String)header) ? JsonUtil.getMapper().createObjectNode() : (ObjectNode)JsonUtil.toJsonNode((String)header);
                this.handleBizSystemToken(portalInterfaceManager, portalBizSystem, urlBizSystem, headerNode);
                header = JsonUtil.toJson((Object)headerNode);
                url = urlBizSystem.toString();
            }
            String response = "";
            if (PortalRestfulInterface.RESTFUL_GET.equals(requestType)) {
                url = this.handleGet(url, conditionMap);
                response = FluentUtil.get(url, header);
            } else if (PortalRestfulInterface.RESTFUL_POST.equals(requestType)) {
                Object inMap = StringUtil.isNotEmpty((String)apiRestParams) ? JsonUtil.toJsonNode((String)apiRestParams) : this.handlePost(restfulDetail, conditionMap);
                response = FluentUtil.post(url, header, inMap);
            }
            if (restfulDetail.getResultfield() == null || "[]".equals(restfulDetail.getResultfield())) {
                return new CommonResult(true, response);
            }
            if (StringUtil.isNotEmpty((String)response)) {
                JsonNode result = JsonUtil.toJsonNode((String)response);
                return this.handleResponse(restfulDetail, resultData, result);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private void handleBizSystemToken(PortalInterfaceManager portalInterfaceManager, ObjectNode portalBizSystem, StringBuilder url, ObjectNode headerNode) throws Exception {
        String tokenKey;
        if (portalInterfaceManager.getSourceType() != 1 || portalBizSystem == null) {
            return;
        }
        String sysCode = portalBizSystem.get("sysCode") == null ? "" : portalBizSystem.get("sysCode").asText();
        String string = tokenKey = portalBizSystem.get("tokenKey") == null ? "" : portalBizSystem.get("tokenKey").asText();
        if (StringUtil.isEmpty((String)sysCode) || StringUtil.isEmpty((String)tokenKey)) {
            return;
        }
        int tokenType = portalBizSystem.get("tokenType") == null ? 0 : portalBizSystem.get("tokenType").asInt();
        int tokenExpire = portalBizSystem.get("tokenExpire") == null ? 0 : portalBizSystem.get("tokenExpire").asInt();
        String tokenApiInfo = portalBizSystem.get("tokenApiInfo") == null ? "" : portalBizSystem.get("tokenApiInfo").asText();
        String tokenValue = "";
        if (StringUtil.isNotEmpty((String)tokenApiInfo)) {
            JsonNode jsonNode = JsonUtil.toJsonNode((String)tokenApiInfo);
            tokenValue = ApiTokenUtil.getToken((JsonNode)jsonNode, (Integer)tokenExpire, (String)sysCode);
        }
        if ("Authorization".equalsIgnoreCase(tokenKey)) {
            tokenValue = "Bearer " + tokenValue;
        }
        if (tokenType == 0) {
            headerNode.put(tokenKey, tokenValue);
        } else {
            if (url.toString().contains("?")) {
                url.append("&");
            } else {
                url.append("?");
            }
            url.append(tokenKey).append("=").append(tokenValue);
        }
    }

    private String handleGet(String url, Map<String, Object> params) {
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue().toString();
            String map = key + "=" + value;
            if (url.indexOf("?") > -1) {
                url = url + "&" + map;
                continue;
            }
            url = url + "?" + map;
        }
        return url;
    }

    private Object handlePost(PortalRestfulInterface restfulDetail, Map<String, Object> params) {
        try {
            String dataParam = restfulDetail.getDataParam();
            if (BeanUtils.isNotEmpty((Object)dataParam)) {
                dataParam = ParserUtil.replaceWithMap(dataParam, params);
                return JsonUtil.toJsonNode((String)dataParam);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return params;
    }

    private Object handleResponse(PortalRestfulInterface restfulDetail, String resultData, JsonNode result) {
        try {
            String comment;
            String field;
            ArrayNode resultField;
            String listKey = restfulDetail.getListKey();
            if (StringUtil.isNotEmpty((String)listKey)) {
                result = this.getResult(listKey, result);
            }
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            if (StringUtil.isEmpty((String)resultData)) {
                resultField = (ArrayNode)JsonUtil.toJsonNode((String)restfulDetail.getResultfield());
                for (JsonNode jObject : resultField) {
                    field = jObject.get("field").asText();
                    comment = jObject.get("comment").asText();
                    params.put(field, comment);
                }
            } else {
                resultField = (ArrayNode)JsonUtil.toJsonNode((String)resultData);
                for (JsonNode jObject : resultField) {
                    field = jObject.get("field").asText();
                    comment = jObject.get("comment").asText();
                    params.put(field, comment);
                }
            }
            if (params.isEmpty()) {
                return result;
            }
            if (result.isArray()) {
                ArrayNode arrayNode = JsonUtil.getMapper().createArrayNode();
                ArrayNode resultAry = (ArrayNode)result;
                for (JsonNode node : resultAry) {
                    arrayNode.add((JsonNode)this.handleResultField(params, node));
                }
                return arrayNode;
            }
            return this.handleResultField(params, result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return result;
        }
    }

    private JsonNode getResult(String listKey, JsonNode result) {
        if (listKey.indexOf(".") > -1) {
            String[] data;
            for (String item : data = listKey.split("\\.")) {
                result = result.get(item);
            }
        } else {
            result = result.get(listKey);
        }
        return result;
    }

    private ObjectNode handleResultField(Map<String, Object> params, JsonNode node) {
        ObjectNode objectNode = JsonUtil.getMapper().createObjectNode();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            if (!BeanUtils.isNotEmpty((Object)node.get(key))) continue;
            objectNode.set(key, node.get(key));
        }
        return objectNode;
    }
}

