/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.service.choreography.manager.impl;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.util.DruidDataSourceUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.datasource.DatabaseContext;
import com.hotent.base.exception.BaseException;
import com.hotent.base.exception.DataExistException;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.Base64;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ZipUtil;
import com.hotent.service.choreography.dao.PortalConnectionManagerDao;
import com.hotent.service.choreography.manager.PortalConnectionManagerManager;
import com.hotent.service.choreography.manager.PortalInterfaceManagerManager;
import com.hotent.service.choreography.manager.PortalRestfulManageManager;
import com.hotent.service.choreography.model.PortalConnectionManager;
import com.hotent.service.choreography.model.PortalRestfulManage;
import com.hotent.service.choreography.vo.InitConnectionVo;
import com.hotent.service.choreography.vo.PortalRestfulVo;
import com.hotent.sys.constants.CategoryConstants;
import com.hotent.sys.persistence.manager.SysDataSourceManager;
import com.hotent.sys.persistence.manager.SysTypeManager;
import com.hotent.sys.persistence.model.SysDataSource;
import com.hotent.sys.persistence.model.SysType;
import com.hotent.table.datasource.DataSourceUtil;
import java.io.File;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service
public class PortalConnectionManagerManagerImpl
extends BaseManagerImpl<PortalConnectionManagerDao, PortalConnectionManager>
implements PortalConnectionManagerManager {
    Logger logger = LoggerFactory.getLogger(PortalConnectionManagerManagerImpl.class);
    @Resource
    PortalInterfaceManagerManager portalInterfaceManagerManager;
    @Resource
    SysDataSourceManager sysDataSourceManager;
    @Resource
    PortalRestfulManageManager portalRestfulManageManager;
    @Resource
    DatabaseContext databaseContext;
    private static final Set<String> BASIC_JDBC = new HashSet<String>();

    @Override
    public PortalConnectionManager getDetail(String id) {
        PortalConnectionManager portalConnectionManager = (PortalConnectionManager)this.get((Serializable)((Object)id));
        String refId = portalConnectionManager.getRefId();
        String connectType = portalConnectionManager.getConnectionType();
        if (PortalConnectionManager.DS_TYPE_DATASOURCE.equals(connectType)) {
            SysDataSource sysDataSource = (SysDataSource)this.sysDataSourceManager.get((Serializable)((Object)refId));
            if ("LOCAL".equalsIgnoreCase(portalConnectionManager.getAlias())) {
                this.setLocalDataSource(sysDataSource);
            }
            portalConnectionManager.setDataSource(sysDataSource);
        } else if (PortalConnectionManager.DS_TYPE_RESTFUL.equals(connectType)) {
            portalConnectionManager.setRestfulManage((PortalRestfulManage)this.portalRestfulManageManager.get((Serializable)((Object)refId)));
        }
        return portalConnectionManager;
    }

    private void setLocalDataSource(SysDataSource sysDataSource) {
        try {
            DataSource currDataSource = DataSourceUtil.getDataSourceByAlias((String)"LOCAL");
            if (currDataSource instanceof DruidDataSource) {
                DruidDataSource druidDataSource = (DruidDataSource)currDataSource;
                Map dataSourceMessage = DruidDataSourceUtils.getStatDataForMBean((Object)currDataSource);
                ArrayList<Map<String, Object>> localDataSources = new ArrayList<Map<String, Object>>(dataSourceMessage.size() + 2);
                this.addBasicDataSourceMessage(druidDataSource, localDataSources);
                for (Map.Entry dataSourceNode : dataSourceMessage.entrySet()) {
                    String key = (String)dataSourceNode.getKey();
                    if (PortalConnectionManagerManagerImpl.containsBasicJdbc(key) || BeanUtils.isEmpty(dataSourceNode.getValue())) continue;
                    Object value = dataSourceNode.getValue();
                    char[] keyElements = key.toCharArray();
                    keyElements[0] = (char)(keyElements[0] + 32);
                    HashMap<String, String> localDataSource = new HashMap<String, String>(6);
                    String localSourceKey = String.valueOf(keyElements);
                    Object defaultValue = this.isNumberType(value) ? value : "";
                    localDataSource.put("name", localSourceKey);
                    localDataSource.put("comment", localSourceKey);
                    localDataSource.put("type", value.getClass().getTypeName());
                    localDataSource.put("baseAttr", "1");
                    localDataSource.put("default", (String)defaultValue);
                    localDataSource.put("value", (String)value);
                    localDataSources.add(localDataSource);
                }
                sysDataSource.setSettingJson(JsonUtil.toJsonString(localDataSources));
                sysDataSource.setClassPath(druidDataSource.getClass().getName());
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            this.logger.error("\u83b7\u53d6\u672c\u5730\u6570\u636e\u6e90\u4fe1\u606f\u51fa\u9519\uff1a{}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private static boolean containsBasicJdbc(String key) {
        return BASIC_JDBC.contains(key.toLowerCase());
    }

    private boolean isNumberType(Object value) {
        return value instanceof Number;
    }

    private void addBasicDataSourceMessage(DruidDataSource druidDataSource, List<Map<String, Object>> localDataSources) {
        HashMap<String, String> localDataSource = new HashMap<String, String>(6);
        localDataSource.put("name", "username");
        localDataSource.put("comment", "username");
        localDataSource.put("type", "java.lang.String");
        localDataSource.put("baseAttr", "1");
        localDataSource.put("default", "root");
        localDataSource.put("value", druidDataSource.getUsername());
        localDataSources.add(localDataSource);
        localDataSource = new HashMap(6);
        localDataSource.put("name", "password");
        localDataSource.put("comment", "password");
        localDataSource.put("type", "java.lang.String");
        localDataSource.put("baseAttr", "1");
        localDataSource.put("default", "root");
        localDataSource.put("value", druidDataSource.getPassword());
        localDataSources.add(localDataSource);
        localDataSource = new HashMap(6);
        localDataSource.put("name", "url");
        localDataSource.put("comment", "url");
        localDataSource.put("type", "java.lang.String");
        localDataSource.put("baseAttr", "1");
        localDataSource.put("default", "");
        localDataSource.put("value", druidDataSource.getUrl());
        localDataSources.add(localDataSource);
    }

    @Override
    @Transactional
    public CommonResult<String> createOrUpdate(PortalConnectionManager portalConnectionManager) {
        String connectType;
        String resultMsg = "\u66f4\u65b0\u6210\u529f";
        String alias = portalConnectionManager.getAlias();
        String name = portalConnectionManager.getName();
        if (StringUtil.isEmpty((String)portalConnectionManager.getId()) && portalConnectionManager.getInitFlag() != 1) {
            resultMsg = "\u6dfb\u52a0\u6210\u529f";
            PortalConnectionManager oldManager = this.getByAlias(alias);
            if (BeanUtils.isNotEmpty((Object)((Object)oldManager))) {
                return new CommonResult(false, "\u522b\u540d\u5df2\u5b58\u5728");
            }
        }
        if (PortalConnectionManager.DS_TYPE_DATASOURCE.equals(connectType = portalConnectionManager.getConnectionType())) {
            SysDataSource sysDataSource = portalConnectionManager.getDataSource();
            if (BeanUtils.isNotEmpty((Object)sysDataSource)) {
                sysDataSource.setName(name);
                sysDataSource.setAlias(alias);
                if ("1".equals(portalConnectionManager.getStatus())) {
                    sysDataSource.setEnabled(Boolean.valueOf(true));
                } else {
                    sysDataSource.setEnabled(Boolean.valueOf(false));
                }
                if ("LOCAL".equalsIgnoreCase(sysDataSource.getAlias()) && portalConnectionManager.getInitFlag() == 1) {
                    SysDataSource source = this.sysDataSourceManager.getByAlias("LOCAL");
                    if (BeanUtils.isNotEmpty((Object)source)) {
                        sysDataSource.setId(source.getId());
                        this.sysDataSourceManager.update((Model)sysDataSource);
                    } else {
                        this.sysDataSourceManager.create((Model)sysDataSource);
                    }
                } else {
                    CommonResult result = this.sysDataSourceManager.saveSysDataSource(sysDataSource);
                    if (!result.getState().booleanValue()) {
                        return result;
                    }
                }
                portalConnectionManager.setRefId(sysDataSource.getId());
            }
        } else if (PortalConnectionManager.DS_TYPE_RESTFUL.equals(connectType)) {
            PortalRestfulManage restfulManage = portalConnectionManager.getRestfulManage();
            this.portalRestfulManageManager.saveOrUpdate((Object)restfulManage);
            portalConnectionManager.setRefId(restfulManage.getId());
        }
        this.saveOrUpdate((Object)portalConnectionManager);
        return new CommonResult(resultMsg);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void initConnection(InitConnectionVo initConnectionVo) throws BaseException {
        List<PortalRestfulVo> listRestfulVo;
        SysTypeManager sysTypeManager = (SysTypeManager)AppUtil.getBean(SysTypeManager.class);
        SysType defaultSysType = sysTypeManager.getByTypeKeyAndGroupKey(CategoryConstants.CONNECT_TYPE.key(), "default");
        ((PortalConnectionManagerDao)this.baseMapper).delete((Wrapper)Wrappers.lambdaQuery().eq(PortalConnectionManager::getInitFlag, (Object)1));
        if (initConnectionVo.getInitDatabase() != null && initConnectionVo.getInitDatabase().booleanValue()) {
            PortalConnectionManager connectionLocalDataSource = new PortalConnectionManager();
            if (defaultSysType != null) {
                connectionLocalDataSource.setTypeId(defaultSysType.getId());
                connectionLocalDataSource.setTypeName(defaultSysType.getName());
                connectionLocalDataSource.setTypeIdPath(defaultSysType.getPath());
            }
            connectionLocalDataSource.setAlias("LOCAL");
            connectionLocalDataSource.setName("\u672c\u5730\u6570\u636e\u6e90");
            connectionLocalDataSource.setInitFlag(1);
            connectionLocalDataSource.setStatus("1");
            connectionLocalDataSource.setConnectionType(PortalConnectionManager.DS_TYPE_DATASOURCE);
            connectionLocalDataSource.setDataSource(this.sysDataSourceManager.getDefaultDataSource());
            CommonResult<String> result = this.createOrUpdate(connectionLocalDataSource);
            if (!result.getState().booleanValue()) {
                throw new BaseException(result.getMessage());
            }
        }
        if (CollectionUtils.isNotEmpty(listRestfulVo = initConnectionVo.getRestfulVoList())) {
            listRestfulVo.forEach(restfulVo -> {
                PortalConnectionManager connectionRestful = new PortalConnectionManager();
                if (defaultSysType != null) {
                    connectionRestful.setTypeId(defaultSysType.getId());
                    connectionRestful.setTypeName(defaultSysType.getName());
                    connectionRestful.setTypeIdPath(defaultSysType.getPath());
                }
                connectionRestful.setAlias(restfulVo.getAlias());
                connectionRestful.setName(restfulVo.getName());
                connectionRestful.setInitFlag(1);
                connectionRestful.setStatus("1");
                connectionRestful.setConnectionType(PortalConnectionManager.DS_TYPE_RESTFUL);
                PortalRestfulManage restfulManage = new PortalRestfulManage();
                restfulManage.setBaseUrl(restfulVo.getBaseUrl());
                connectionRestful.setRestfulManage(restfulManage);
                CommonResult<String> resultRestful = this.createOrUpdate(connectionRestful);
                if (!resultRestful.getState().booleanValue()) {
                    throw new BaseException(resultRestful.getMessage());
                }
            });
        }
    }

    @Override
    public PortalConnectionManager getByAlias(String alias) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"alias_", (Object)alias);
        List list = ((PortalConnectionManagerDao)this.baseMapper).selectList((Wrapper)wrapper);
        if (BeanUtils.isNotEmpty((Object)list)) {
            return (PortalConnectionManager)((Object)list.get(0));
        }
        return null;
    }

    @Override
    @Transactional
    public void changeStatus(String id, String status) {
        PortalConnectionManager portalConnectionManager = (PortalConnectionManager)this.get((Serializable)((Object)id));
        String connectType = portalConnectionManager.getConnectionType();
        if (PortalConnectionManager.DS_TYPE_DATASOURCE.equals(connectType)) {
            String refId = portalConnectionManager.getRefId();
            SysDataSource sysDataSource = (SysDataSource)this.sysDataSourceManager.get((Serializable)((Object)refId));
            if ("1".equals(status)) {
                sysDataSource.setEnabled(Boolean.valueOf(true));
            } else {
                sysDataSource.setEnabled(Boolean.valueOf(false));
            }
            this.sysDataSourceManager.saveSysDataSource(sysDataSource);
        } else if (PortalConnectionManager.DS_TYPE_RESTFUL.equals(connectType)) {
            // empty if block
        }
        portalConnectionManager.setStatus(status);
        this.update((Model)portalConnectionManager);
    }

    @Override
    public List<PortalConnectionManager> getList() {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"status_", (Object)"1");
        return ((PortalConnectionManagerDao)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    public void removeConnect(String ... ids) {
        List<String> idList = Arrays.asList(ids);
        for (String id : idList) {
            this.deleteData(id);
        }
    }

    private void deleteData(String id) {
        PortalConnectionManager portalConnectionManager = (PortalConnectionManager)this.get((Serializable)((Object)id));
        String refId = portalConnectionManager.getRefId();
        String connectType = portalConnectionManager.getConnectionType();
        if (PortalConnectionManager.DS_TYPE_DATASOURCE.equals(connectType)) {
            this.sysDataSourceManager.remove((Serializable)((Object)refId));
            if (portalConnectionManager.getDataSource() != null && StringUtil.isNotEmpty((String)portalConnectionManager.getDataSource().getAlias())) {
                this.databaseContext.remove(portalConnectionManager.getDataSource().getAlias());
            }
        } else if (PortalConnectionManager.DS_TYPE_RESTFUL.equals(connectType)) {
            this.portalRestfulManageManager.remove((Serializable)((Object)refId));
        }
        this.remove((Serializable)((Object)id));
        this.portalInterfaceManagerManager.removeByRefId(id);
    }

    @Override
    public CommonResult<String> importData(MultipartHttpServletRequest request, HttpServletResponse response, String typeId) throws UnsupportedEncodingException {
        MultipartFile file = request.getFile("file");
        String unZipFilePath = "";
        Boolean isRepeat = true;
        try {
            String rootRealPath = (FileUtil.getIoTmpdir() + "/attachFiles/unZip/").replace("/", File.separator);
            FileUtil.createFolder((String)rootRealPath, (boolean)true);
            String name = file.getOriginalFilename();
            String fileDir = StringUtil.substringBeforeLast((String)name, (String)".");
            ZipUtil.unZipFile((MultipartFile)file, (String)rootRealPath);
            unZipFilePath = rootRealPath + File.separator + fileDir;
            this.importData(Base64.getBase64((String)unZipFilePath), "check", typeId);
            return new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
        }
        catch (DataExistException e) {
            isRepeat = true;
            return new CommonResult(true, "confirmUpload", (Object)Base64.getBase64((String)unZipFilePath));
        }
        catch (Exception e) {
            File zipFile;
            if (StringUtil.isNotEmpty((String)unZipFilePath) && isRepeat.booleanValue() && (zipFile = new File(unZipFilePath)).exists()) {
                zipFile.delete();
            }
            return new CommonResult(false, "\u5bfc\u5165\u5931\u8d25:" + e.getMessage());
        }
    }

    @Override
    public CommonResult<String> importData(String unZipFilePath, String status, String typeId) throws Exception {
        try {
            String json = FileUtil.readFile((String)(Base64.getFromBase64((String)unZipFilePath) + File.separator + "connection.json"));
            List connections = (List)JsonUtil.toBean((String)json, (TypeReference)new TypeReference<List<PortalConnectionManager>>(){});
            PortalFeignService portalFeignService = (PortalFeignService)AppUtil.getBean(PortalFeignService.class);
            ObjectNode sysTypeNode = portalFeignService.getSysTypeById(typeId);
            String typeName = sysTypeNode.get("name").asText("");
            for (PortalConnectionManager connection : connections) {
                connection.setTypeId(typeId);
                connection.setTypeName(typeName);
                PortalConnectionManager byAlias = this.getByAlias(connection.getAlias());
                if (BeanUtils.isEmpty((Object)((Object)byAlias)) || "cover".equals(status)) {
                    this.createOrUpdate(connection);
                    continue;
                }
                if (!BeanUtils.isNotEmpty((Object)((Object)byAlias)) || !"check".equals(status)) continue;
                throw new DataExistException();
            }
        }
        catch (Exception e) {
            File zipFile;
            if (!(e instanceof DataExistException) && StringUtil.isNotEmpty((String)unZipFilePath) && (zipFile = new File(unZipFilePath)).exists()) {
                zipFile.delete();
            }
            throw e;
        }
        return new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
    }

    static {
        BASIC_JDBC.add("username");
        BASIC_JDBC.add("password");
        BASIC_JDBC.add("url");
    }
}

