/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.service.choreography.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.service.choreography.dao.PortalInterfaceManagerDao;
import com.hotent.service.choreography.manager.PortalDbInterfaceManager;
import com.hotent.service.choreography.manager.PortalInterfaceManagerManager;
import com.hotent.service.choreography.manager.PortalRestfulInterfaceManager;
import com.hotent.service.choreography.model.PortalConnectionManager;
import com.hotent.service.choreography.model.PortalDbInterface;
import com.hotent.service.choreography.model.PortalInterfaceManager;
import com.hotent.service.choreography.model.PortalRestfulInterface;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PortalInterfaceManagerManagerImpl
extends BaseManagerImpl<PortalInterfaceManagerDao, PortalInterfaceManager>
implements PortalInterfaceManagerManager {
    @Resource
    PortalDbInterfaceManager portalDbInterfaceManager;
    @Resource
    PortalRestfulInterfaceManager portalRestfulInterfaceManager;

    @Override
    public PortalInterfaceManager getDetail(String id) {
        PortalInterfaceManager portalInterfaceManager = (PortalInterfaceManager)this.get((Serializable)((Object)id));
        this.handleDetail(portalInterfaceManager);
        return portalInterfaceManager;
    }

    private void handleDetail(PortalInterfaceManager portalInterfaceManager) {
        String connectType = portalInterfaceManager.getConnectionType();
        String id = portalInterfaceManager.getId();
        if (portalInterfaceManager.getSourceType() == 0) {
            if (PortalConnectionManager.DS_TYPE_DATASOURCE.equals(connectType)) {
                PortalDbInterface dbDetail = this.portalDbInterfaceManager.getDataByRefId(id);
                portalInterfaceManager.setDbDetail(dbDetail);
            } else if (PortalConnectionManager.DS_TYPE_RESTFUL.equals(connectType)) {
                PortalRestfulInterface restfulDetail = this.portalRestfulInterfaceManager.getDataByRefId(id);
                portalInterfaceManager.setRestfulDetail(restfulDetail);
            }
        } else {
            PortalRestfulInterface restfulDetail = this.portalRestfulInterfaceManager.getDataByRefId(id);
            portalInterfaceManager.setConnectionType(PortalConnectionManager.DS_TYPE_RESTFUL);
            portalInterfaceManager.setRestfulDetail(restfulDetail);
        }
    }

    @Override
    @Transactional
    public CommonResult<String> createData(PortalInterfaceManager portalInterfaceManager) {
        String alias = portalInterfaceManager.getAlias();
        PortalInterfaceManager oldManager = this.getByAlias(alias);
        if (BeanUtils.isNotEmpty((Object)((Object)oldManager))) {
            return new CommonResult(false, "\u522b\u540d\u5df2\u5b58\u5728");
        }
        String id = UniqueIdUtil.getSuid();
        portalInterfaceManager.setId(id);
        this.create((Model)portalInterfaceManager);
        String connectType = portalInterfaceManager.getConnectionType();
        if (PortalConnectionManager.DS_TYPE_DATASOURCE.equals(connectType)) {
            PortalDbInterface dbDetail = portalInterfaceManager.getDbDetail();
            dbDetail.setRefId(id);
            this.portalDbInterfaceManager.create((Model)dbDetail);
        } else if (portalInterfaceManager.getSourceType() == 1 || PortalConnectionManager.DS_TYPE_RESTFUL.equals(connectType)) {
            PortalRestfulInterface restfulDetail = portalInterfaceManager.getRestfulDetail();
            restfulDetail.setRefId(id);
            this.portalRestfulInterfaceManager.create((Model)restfulDetail);
        }
        return new CommonResult("\u6dfb\u52a0\u63a5\u53e3\u7ba1\u7406\u6210\u529f");
    }

    @Override
    @Transactional
    public CommonResult<String> updateData(PortalInterfaceManager portalInterfaceManager) {
        String connectType = portalInterfaceManager.getConnectionType();
        if (PortalConnectionManager.DS_TYPE_DATASOURCE.equals(connectType)) {
            PortalDbInterface dbDetail = portalInterfaceManager.getDbDetail();
            if (StringUtil.isEmpty((String)dbDetail.getId())) {
                dbDetail.setRefId(portalInterfaceManager.getId());
                this.portalDbInterfaceManager.create((Model)dbDetail);
                this.portalRestfulInterfaceManager.deleteDataByRefId(portalInterfaceManager.getId());
            } else {
                this.portalDbInterfaceManager.update((Model)dbDetail);
            }
        } else if (portalInterfaceManager.getSourceType() == 1 || PortalConnectionManager.DS_TYPE_RESTFUL.equals(connectType)) {
            PortalRestfulInterface restfulDetail = portalInterfaceManager.getRestfulDetail();
            if (StringUtil.isEmpty((String)restfulDetail.getId())) {
                restfulDetail.setRefId(portalInterfaceManager.getId());
                this.portalRestfulInterfaceManager.create((Model)restfulDetail);
                this.portalDbInterfaceManager.deleteDataByRefId(portalInterfaceManager.getId());
            } else {
                this.portalRestfulInterfaceManager.update((Model)restfulDetail);
            }
        }
        this.update((Model)portalInterfaceManager);
        return new CommonResult("\u66f4\u65b0\u63a5\u53e3\u7ba1\u7406\u6210\u529f");
    }

    @Override
    public Object doQuery(String alias, String queryData, String resultData, String paramData) {
        PortalInterfaceManager portalInterfaceManager = this.getByAlias(alias);
        if (BeanUtils.isEmpty((Object)((Object)portalInterfaceManager))) {
            return null;
        }
        String connectType = portalInterfaceManager.getConnectionType();
        if (PortalConnectionManager.DS_TYPE_DATASOURCE.equals(connectType)) {
            PageList data = this.portalDbInterfaceManager.getData(portalInterfaceManager, queryData, resultData, paramData);
            if (BeanUtils.isNotEmpty((Object)data)) {
                return data.getRows();
            }
        } else if (portalInterfaceManager.getSourceType() == 1 || PortalConnectionManager.DS_TYPE_RESTFUL.equals(connectType)) {
            Object data = this.portalRestfulInterfaceManager.getData(portalInterfaceManager, queryData, resultData, paramData);
            return data;
        }
        return null;
    }

    @Override
    public PortalInterfaceManager getByAlias(String alias) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"alias_", (Object)alias);
        List list = ((PortalInterfaceManagerDao)this.baseMapper).selectList((Wrapper)wrapper);
        if (BeanUtils.isNotEmpty((Object)list)) {
            return (PortalInterfaceManager)((Object)list.get(0));
        }
        return null;
    }

    @Override
    public PortalInterfaceManager getDetailByAlias(String alias) {
        PortalInterfaceManager portalInterfaceManager = this.getByAlias(alias);
        if (BeanUtils.isEmpty((Object)((Object)portalInterfaceManager))) {
            return null;
        }
        this.handleDetail(portalInterfaceManager);
        return portalInterfaceManager;
    }

    @Override
    public List<PortalInterfaceManager> getListByRefId(String refId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"ref_id_", (Object)refId);
        return ((PortalInterfaceManagerDao)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    public void removeInteface(String ... ids) {
        List<String> idList = Arrays.asList(ids);
        for (String id : idList) {
            this.remove((Serializable)((Object)id));
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"ref_id_", (Object)id);
            this.portalDbInterfaceManager.remove((Wrapper)wrapper);
            this.portalRestfulInterfaceManager.remove((Wrapper)wrapper);
        }
    }

    @Override
    public void removeByRefId(String refId) {
        List<PortalInterfaceManager> list = this.getListByRefId(refId);
        if (BeanUtils.isNotEmpty(list)) {
            for (PortalInterfaceManager item : list) {
                String id = item.getId();
                this.remove((Serializable)((Object)id));
                QueryWrapper wrapper = new QueryWrapper();
                wrapper.eq((Object)"ref_id_", (Object)id);
                this.portalDbInterfaceManager.remove((Wrapper)wrapper);
                this.portalRestfulInterfaceManager.remove((Wrapper)wrapper);
            }
        }
    }

    @Override
    public List<PortalInterfaceManager> getList() {
        QueryWrapper wrapper = new QueryWrapper();
        return ((PortalInterfaceManagerDao)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    public void changeStatus(String id, String status) {
        PortalInterfaceManager manage = (PortalInterfaceManager)this.get((Serializable)((Object)id));
        manage.setStatus(status);
        this.update((Model)manage);
    }
}

