/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.service.choreography.util;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FluentUtil {
    private static final Logger logger = LoggerFactory.getLogger(FluentUtil.class);
    private static final int CONNECT_TIMEOUT = 30000;
    private static final int SOCKET_TIMEOUT = 30000;

    public static String get(String url, String headerStr) throws ClientProtocolException, IOException {
        return FluentUtil.get(url, headerStr, 0, 0);
    }

    public static String get(String url, String headerStr, int connectTimeout, int socketTimeout) throws ClientProtocolException, IOException {
        connectTimeout = connectTimeout > 0 ? connectTimeout : 30000;
        socketTimeout = socketTimeout > 0 ? socketTimeout : 30000;
        Request request = Request.Get((String)url);
        FluentUtil.setHeaders(request, headerStr);
        HttpResponse returnResponse = request.connectTimeout(connectTimeout).socketTimeout(socketTimeout).execute().returnResponse();
        return FluentUtil.handleResponse(returnResponse);
    }

    public static String post(String url, String headerStr, Object params) throws ClientProtocolException, IOException {
        return FluentUtil.post(url, headerStr, params, 0, 0);
    }

    public static String post(String url, String headerStr, Object params, int connectTimeout, int socketTimeout) throws ClientProtocolException, IOException {
        String paramStr = "{}";
        if (BeanUtils.isNotEmpty((Object)params)) {
            paramStr = JsonUtil.toJson((Object)params);
        }
        return FluentUtil.post(url, headerStr, paramStr, connectTimeout, socketTimeout);
    }

    public static String post(String url, String headerStr, String body, int connectTimeout, int socketTimeout) throws ClientProtocolException, IOException {
        connectTimeout = connectTimeout > 0 ? connectTimeout : 30000;
        socketTimeout = socketTimeout > 0 ? socketTimeout : 30000;
        Request request = Request.Post((String)url);
        FluentUtil.setHeaders(request, headerStr);
        HttpResponse returnResponse = request.bodyString(body, ContentType.APPLICATION_JSON).connectTimeout(connectTimeout).socketTimeout(socketTimeout).execute().returnResponse();
        return FluentUtil.handleResponse(returnResponse);
    }

    public static String put(String url, String headerStr, Object params) throws ClientProtocolException, IOException {
        return FluentUtil.put(url, headerStr, params, 0, 0);
    }

    public static String put(String url, String headerStr, Object params, int connectTimeout, int socketTimeout) throws ClientProtocolException, IOException {
        String paramStr = "";
        if (BeanUtils.isNotEmpty((Object)params)) {
            paramStr = JsonUtil.toJson((Object)params);
        }
        return FluentUtil.put(url, headerStr, paramStr, connectTimeout, socketTimeout);
    }

    public static String put(String url, String headerStr, String body, int connectTimeout, int socketTimeout) throws ClientProtocolException, IOException {
        connectTimeout = connectTimeout > 0 ? connectTimeout : 30000;
        socketTimeout = socketTimeout > 0 ? socketTimeout : 30000;
        Request request = Request.Put((String)url);
        FluentUtil.setHeaders(request, headerStr);
        HttpResponse returnResponse = request.bodyString(body, ContentType.APPLICATION_JSON).connectTimeout(connectTimeout).socketTimeout(socketTimeout).execute().returnResponse();
        return FluentUtil.handleResponse(returnResponse);
    }

    public static String delete(String url, String headerStr) throws ClientProtocolException, IOException {
        return FluentUtil.delete(url, headerStr, 0, 0);
    }

    public static String delete(String url, String headerStr, int connectTimeout, int socketTimeout) throws ClientProtocolException, IOException {
        connectTimeout = connectTimeout > 0 ? connectTimeout : 30000;
        socketTimeout = socketTimeout > 0 ? socketTimeout : 30000;
        Request request = Request.Delete((String)url);
        FluentUtil.setHeaders(request, headerStr);
        HttpResponse returnResponse = request.connectTimeout(connectTimeout).socketTimeout(socketTimeout).execute().returnResponse();
        return FluentUtil.handleResponse(returnResponse);
    }

    private static Request setHeaders(Request request, String headerStr) {
        if (StringUtil.isNotEmpty((String)headerStr)) {
            try {
                ObjectNode obj = (ObjectNode)JsonUtil.toJsonNode((String)headerStr);
                Iterator it = obj.fieldNames();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    request.setHeader(key, obj.get(key).asText());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return request;
    }

    private static String handleResponse(HttpResponse returnResponse) throws IOException {
        int statusCode = returnResponse.getStatusLine().getStatusCode();
        InputStream content = returnResponse.getEntity().getContent();
        String res = StringUtil.InputStreamToString((InputStream)content);
        if (statusCode != 200) {
            logger.warn(statusCode + "\u89e3\u6790\u5f02\u5e38\u5185\u5bb9");
            throw new RuntimeException(statusCode + "");
        }
        return res;
    }

    public static String httpHttpFormData(String url, Map<String, Object> params) throws IOException {
        URL u = null;
        HttpURLConnection con = null;
        StringBuffer sb = new StringBuffer();
        if (params != null) {
            for (Map.Entry<String, Object> e : params.entrySet()) {
                sb.append(e.getKey());
                sb.append("=");
                sb.append(e.getValue());
                sb.append("&");
            }
            sb.substring(0, sb.length() - 1);
        }
        try {
            u = new URL(url);
            con = (HttpURLConnection)u.openConnection();
            con.setRequestMethod("POST");
            con.setDoOutput(true);
            con.setDoInput(true);
            con.setUseCaches(false);
            con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            OutputStreamWriter osw = new OutputStreamWriter(con.getOutputStream(), "UTF-8");
            osw.write(sb.toString());
            osw.flush();
            osw.close();
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001POST \u8bf7\u6c42\u83b7\u53d6\u54cd\u5e94json\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
        StringBuffer buffer = new StringBuffer();
        try {
            String temp;
            BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream(), "UTF-8"));
            while ((temp = br.readLine()) != null) {
                buffer.append(temp);
                buffer.append("\n");
            }
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001POST \u8bf7\u6c42\u83b7\u53d6\u54cd\u5e94json\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
        return buffer.toString();
    }
}

