/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.service.choreography.controller;

import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.service.choreography.manager.PortalConnectionManagerManager;
import com.hotent.service.choreography.model.PortalConnectionManager;
import com.hotent.service.choreography.vo.InitConnectionVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/portal/portalConnectionManager/v1/"})
@Api(tags={"\u8fde\u63a5\u7ba1\u7406"})
@ApiGroup(group={"group_portal"})
public class PortalConnectionManagerController
extends BaseController<PortalConnectionManagerManager, PortalConnectionManager> {
    @GetMapping(value={"getDetail"})
    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6\u8fde\u63a5\u7ba1\u7406\u6570\u636e\u8be6\u60c5", httpMethod="GET", notes="\u6839\u636eid\u83b7\u53d6\u8fde\u63a5\u7ba1\u7406\u6570\u636e\u8be6\u60c5")
    public CommonResult<PortalConnectionManager> getDetail(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @RequestParam(required=true) String id) throws Exception {
        return CommonResult.ok().value((Object)((PortalConnectionManagerManager)this.baseService).getDetail(id));
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u65b0\u589e,\u66f4\u65b0\u8fde\u63a5\u7ba1\u7406\u6570\u636e", httpMethod="POST", notes="\u65b0\u589e,\u66f4\u65b0\u8fde\u63a5\u7ba1\u7406\u6570\u636e")
    public CommonResult<String> save(@ApiParam(name="PortalConnectionManager", value="\u8fde\u63a5\u7ba1\u7406\u5bf9\u8c61", required=true) @RequestBody PortalConnectionManager portalConnectionManager) throws Exception {
        return ((PortalConnectionManagerManager)this.baseService).createOrUpdate(portalConnectionManager);
    }

    @PostMapping(value={"initConnection"})
    @ApiOperation(value="\u521d\u59cb\u5316\u9ed8\u8ba4\u8fde\u63a5", httpMethod="POST", notes="\u521d\u59cb\u5316\u9ed8\u8ba4\u8fde\u63a5")
    public CommonResult<String> initConnection(@ApiParam(name="initConnectionVo", value="\u521d\u59cb\u5316\u8fde\u63a5\u7ba1\u7406\u5165\u53c2") @RequestBody InitConnectionVo initConnectionVo) throws Exception {
        ((PortalConnectionManagerManager)this.baseService).initConnection(initConnectionVo);
        return CommonResult.ok().message("\u64cd\u4f5c\u6210\u529f");
    }

    @GetMapping(value={"changeStatus"})
    @ApiOperation(value="\u542f\u7528/\u505c\u7528\u8fde\u63a5\u7ba1\u7406", httpMethod="GET", notes="\u542f\u7528/\u505c\u7528\u8fde\u63a5\u7ba1\u7406")
    public CommonResult<String> changeStatus(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @RequestParam(required=true) String id, @ApiParam(name="status", value="\u72b6\u6001", required=true) String status) throws Exception {
        ((PortalConnectionManagerManager)this.baseService).changeStatus(id, status);
        return CommonResult.ok().message("\u64cd\u4f5c\u6210\u529f");
    }

    @GetMapping(value={"getList"})
    @ApiOperation(value="\u83b7\u53d6\u8fde\u63a5\u7ba1\u7406\u5217\u8868", httpMethod="GET", notes="\u83b7\u53d6\u8fde\u63a5\u7ba1\u7406\u5217\u8868")
    public List<PortalConnectionManager> getList() throws Exception {
        return ((PortalConnectionManagerManager)this.baseService).getList();
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u8fde\u63a5\u7ba1\u7406\u6570\u636e", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u8fde\u63a5\u7ba1\u7406\u6570\u636e")
    public CommonResult<String> remove(String ... ids) throws Exception {
        ((PortalConnectionManagerManager)this.baseService).removeConnect(ids);
        return CommonResult.ok().message("\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"export"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u6570\u636e", httpMethod="GET", notes="\u5bfc\u51fa\u6570\u636e")
    public void export(HttpServletResponse response, HttpServletRequest request, @ApiParam(name="ids", value="ids", required=true) @RequestParam String ids) throws Exception {
        String[] idList = ids.split(",");
        String fileName = "connection_" + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy_MMdd_HHmm");
        ArrayList<PortalConnectionManager> list = new ArrayList<PortalConnectionManager>();
        for (String id : idList) {
            PortalConnectionManager detail = ((PortalConnectionManagerManager)this.baseService).getDetail(id);
            list.add(detail);
        }
        String json = JsonUtil.toJson(list);
        HttpUtil.downLoadFile((HttpServletRequest)request, (HttpServletResponse)response, (String)json, (String)"connection.json", (String)fileName);
    }

    @RequestMapping(value={"import"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165\u8fde\u63a5\u7ba1\u7406", httpMethod="POST", notes="\u5bfc\u5165\u8fde\u63a5\u7ba1\u7406")
    public CommonResult<String> importCustom(MultipartHttpServletRequest request, HttpServletResponse response, @RequestParam(value="typeId") String typeId) throws Exception {
        CommonResult<String> res = ((PortalConnectionManagerManager)this.baseService).importData(request, response, typeId);
        return res;
    }

    @RequestMapping(value={"importData"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165\u8fde\u63a5\u7ba1\u7406", httpMethod="POST", notes="\u5bfc\u5165\u8fde\u63a5\u7ba1\u7406")
    public CommonResult<String> importData(@ApiParam(name="unZipFilePath", value="unZipFilePath", required=true) @RequestParam String unZipFilePath, @ApiParam(name="status", value="status", required=true) @RequestParam String status, @RequestParam(value="typeId") String typeId) throws Exception {
        CommonResult<String> res = ((PortalConnectionManagerManager)this.baseService).importData(unZipFilePath, status, typeId);
        return res;
    }
}

