/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.sse.server.controller;

import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.exception.BaseException;
import com.hotent.base.util.StringUtil;
import com.hotent.sse.server.service.SseService;
import com.hotent.sse.server.vo.MessageVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@RestController
@RequestMapping(value={"/sse/v1"})
@Api(tags={"\u6d88\u606f\u63a8\u9001"})
@ApiGroup(group={"group_sse"})
public class SseController {
    @Resource
    private SseService sseService;

    @GetMapping(value={"/create"})
    @ApiOperation(value="\u5ba2\u6237\u7aef\u8bf7\u6c42\u521b\u5efaSSE\u8fde\u63a5", httpMethod="GET", notes="\u5ba2\u6237\u7aef\u8bf7\u6c42\u521b\u5efaSSE\u8fde\u63a5")
    public SseEmitter create(HttpServletResponse response, @ApiParam(name="account", value="\u7528\u6237\u8d26\u53f7", required=true) @RequestParam String account) {
        if (StringUtil.isEmpty((String)account)) {
            throw new BaseException("\u7528\u6237\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setHeader("Content-Type", "text/event-stream");
        response.setHeader("Cache-Control", "no-cache");
        return this.sseService.crateSse(account);
    }

    @RequestMapping(value={"/sendMsg"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d1\u9001SSE\u6d88\u606f", httpMethod="POST", notes="\u53d1\u9001SSE\u6d88\u606f")
    public List<String> sendMsg(@RequestBody @Valid MessageVO messageVO) {
        return this.sseService.sendMessage(messageVO);
    }

    @RequestMapping(value={"/keys"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u5ba2\u6237\u7aef\u8fde\u63a5\u7684KEY", httpMethod="GET", notes="\u83b7\u53d6\u6240\u6709\u5ba2\u6237\u7aef\u8fde\u63a5\u7684KEY")
    public List<String> getKeys() {
        return this.sseService.getSseEmitterKeys();
    }
}

