/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.sys.persistence.manager.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.lang.Assert;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.cache.annotation.Cacheable;
import com.hotent.base.cache.annotation.FirstCache;
import com.hotent.base.datasource.DatabaseContext;
import com.hotent.base.exception.BaseException;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.Direction;
import com.hotent.base.query.FieldSort;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.sys.persistence.dao.SysAppDao;
import com.hotent.sys.persistence.dao.SysAppMenuDao;
import com.hotent.sys.persistence.manager.AppTagsRelationManager;
import com.hotent.sys.persistence.manager.CurrentUserService;
import com.hotent.sys.persistence.manager.SysAppManager;
import com.hotent.sys.persistence.manager.SysAppMenuManager;
import com.hotent.sys.persistence.manager.SysAuthUserManager;
import com.hotent.sys.persistence.manager.SysTagManager;
import com.hotent.sys.persistence.manager.SysUserAppManager;
import com.hotent.sys.persistence.model.AppTagsRelation;
import com.hotent.sys.persistence.model.SysApp;
import com.hotent.sys.persistence.model.SysAppMenu;
import com.hotent.sys.persistence.model.SysAuthUser;
import com.hotent.sys.persistence.model.SysTag;
import com.hotent.sys.persistence.model.SysUserApp;
import com.hotent.sys.persistence.param.SysAppCopyDTO;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="sysAppManager")
public class SysAppManagerImpl
extends BaseManagerImpl<SysAppDao, SysApp>
implements SysAppManager {
    @Resource
    SysAuthUserManager sysAuthUserManager;
    @Resource
    AppTagsRelationManager appTagsRelationManager;
    @Resource
    CurrentUserService currentUserService;
    @Resource
    SysAppMenuDao sysAppMenuDao;
    @Resource
    SysAppMenuManager sysAppMenuManager;
    @Resource
    SysUserAppManager sysUserAppManager;
    @Resource
    SysTagManager sysTagManager;

    public PageList<SysApp> query(QueryFilter<SysApp> queryFilter) {
        List sorter;
        List sorters = queryFilter.getSorter();
        List filterSorters = sorters.stream().filter(fieldSort -> "SN".equalsIgnoreCase(fieldSort.getProperty().replace("_", ""))).collect(Collectors.toList());
        if (BeanUtils.isEmpty(filterSorters)) {
            sorter = queryFilter.getSorter();
            sorter.add(new FieldSort("SN_", Direction.ASC));
            queryFilter.setSorter(sorter);
        }
        if ("oracle".equals(((DatabaseContext)AppUtil.getBean(DatabaseContext.class)).getDbType())) {
            sorter = queryFilter.getSorter();
            for (FieldSort fieldSort2 : sorter) {
                if (!"icon".equals(fieldSort2.getProperty())) continue;
                fieldSort2.setProperty("dbms_lob.substr(" + fieldSort2.getProperty() + "_,4000)");
            }
        }
        return new PageList(((SysAppDao)this.baseMapper).customQuery((IPage<SysApp>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<SysApp>)this.convert2Wrapper(queryFilter, this.currentModelClass())));
    }

    @Transactional
    public void create(SysApp sysApp) {
        String id = UniqueIdUtil.getSuid();
        sysApp.setId(id);
        sysApp.setIsPublish(SysApp.NOT_PUBLISH);
        sysApp.setCreateBy(null);
        ((SysAppDao)this.baseMapper).insert((Object)sysApp);
        this.sysAuthUserManager.createDefault(id);
    }

    @Override
    public List<SysApp> queryByAuth(SysApp sysApp) throws Exception {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_publish_", (Object)SysApp.IS_PUBLISH);
        queryWrapper.eq((Object)"menu_id_", (Object)sysApp.getMenuId());
        List sysApps = this.list((Wrapper)queryWrapper);
        if (ContextUtil.getCurrentUser().isAdmin()) {
            return sysApps;
        }
        if (BeanUtils.isNotEmpty((Object)sysApps)) {
            ArrayList<String> ids = new ArrayList<String>();
            for (SysApp app2 : sysApps) {
                ids.add(app2.getId());
            }
            List<String> authIds = this.sysAuthUserManager.filterAuth(ids);
            if (BeanUtils.isEmpty(authIds)) {
                return new ArrayList<SysApp>();
            }
            return sysApps.parallelStream().filter(app -> authIds.contains(app.getId())).collect(Collectors.toList());
        }
        return new ArrayList<SysApp>();
    }

    @Override
    public PageList<SysApp> queryByFilter(QueryFilter<SysApp> queryFilter) {
        Map params;
        Object tagIds;
        if (BeanUtils.isEmpty((Object)queryFilter.getPageBean())) {
            queryFilter.setPageBean(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        }
        if ((tagIds = (params = queryFilter.getParams()).getOrDefault("tagIds", null)) != null) {
            List tagIdList = Arrays.stream(tagIds.toString().split(",")).map(tagId -> "'" + tagId + "'").collect(Collectors.toList());
            queryFilter.addParams("tagIds", (Object)String.join((CharSequence)",", tagIdList));
        }
        IUser user = ContextUtil.getCurrentUser();
        queryFilter.addParams("userId", (Object)user.getUserId());
        if (queryFilter.getParams().containsKey("isManage") && user.isAdmin()) {
            return new PageList(((SysAppDao)this.baseMapper).queryByFilter((IPage<SysApp>)this.convert2IPage(queryFilter.getPageBean()), queryFilter.getParams()));
        }
        List<String> authIds = this.sysAuthUserManager.getAuthorizeIdsByUserMap(SysAuthUser.BPMDEFUSER_OBJ_TYPE.SYS_APP);
        authIds = authIds.stream().map(authId -> "'" + authId + "'").collect(Collectors.toList());
        queryFilter.addParams("authIds", (Object)String.join((CharSequence)",", authIds));
        return new PageList(((SysAppDao)this.baseMapper).queryByFilter((IPage<SysApp>)this.convert2IPage(queryFilter.getPageBean()), queryFilter.getParams()));
    }

    @Override
    public List<SysApp> queryByTagIds(String menuId, List<Map<String, String>> maps) {
        QueryWrapper qw = new QueryWrapper();
        qw.eq((Object)"is_publish_", (Object)SysApp.IS_PUBLISH);
        qw.eq((Object)"menu_id_", (Object)menuId);
        if (BeanUtils.isNotEmpty(maps)) {
            Set<String> appIds = this.getAppIdByTags(maps);
            if (BeanUtils.isNotEmpty(appIds)) {
                qw.in((Object)"id_", appIds);
            } else {
                return new ArrayList<SysApp>();
            }
        }
        List sysApps = this.list((Wrapper)qw);
        if (ContextUtil.getCurrentUser().isAdmin()) {
            return sysApps;
        }
        return sysApps.stream().filter(app -> this.sysAuthUserManager.hasRights(app.getId())).collect(Collectors.toList());
    }

    private Set<String> getAppIdByTags(List<Map<String, String>> maps) {
        Set<String> relList = new HashSet<String>();
        for (Map<String, String> map : maps) {
            String tagIds = map.get("tagIds");
            if (StringUtil.isEmpty((String)tagIds)) continue;
            Set<String> list = this.appTagsRelationManager.getAppIdsByTagIds(tagIds.split(","));
            if (BeanUtils.isEmpty(relList)) {
                relList = list;
                continue;
            }
            relList.retainAll(list);
            if (!relList.isEmpty()) continue;
            return new HashSet<String>();
        }
        return relList;
    }

    @Override
    @Cacheable(value={"eip:sys:appAuthMenu"}, key="#userId", firstCache=@FirstCache(expireTime=10, timeUnit=TimeUnit.MINUTES))
    public List<String> getValidMenu(String userId) {
        Map<String, Set<String>> userRightMap = this.currentUserService.getUserRightMap();
        Map<String, String> userRightMapStr = this.currentUserService.getMapStringByMayList(userRightMap);
        List<String> ids = ((SysAppDao)this.baseMapper).getValidMenu();
        if (BeanUtils.isEmpty(ids)) {
            return new ArrayList<String>();
        }
        return ids.stream().filter(menuId -> this.sysAuthUserManager.getAuthorizeAppMenuId((String)menuId, userRightMapStr)).collect(Collectors.toList());
    }

    @Override
    @Transactional
    public void publish(SysApp sysApp) {
        List<SysAppMenu> menuTree;
        if (sysApp.getIsPublish() == 1 && (menuTree = this.sysAppMenuManager.getMenuTree(sysApp.getId())).isEmpty()) {
            throw new BaseException("\u5e94\u7528\u65e0\u5185\u5bb9\uff0c\u4e0d\u53ef\u53d1\u5e03\uff01");
        }
        this.update((Model)sysApp);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"app_id_", (Object)sysApp.getId());
        this.appTagsRelationManager.remove((Wrapper)wrapper);
    }

    @Override
    @Transactional
    public void saveAndPublish(SysApp sysApp) {
        sysApp.setId(UniqueIdUtil.getSuid());
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysApp::getAlias, (Object)sysApp.getAlias());
        if (this.count((Wrapper)wrapper) > 0) {
            throw new BaseException("\u5e94\u7528\u522b\u540d\u5df2\u5b58\u5728");
        }
        ((SysAppDao)this.baseMapper).insert((Object)sysApp);
        this.updateApp(sysApp.getId());
        this.sysAuthUserManager.createDefault(sysApp.getId());
    }

    @Override
    public SysApp getAuthById(String appId) {
        IUser user = ContextUtil.getCurrentUser();
        int count = this.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysApp::getId, (Object)appId)).eq(SysApp::getCreateBy, (Object)user.getUserId()));
        if (count == 0) {
            Assert.isTrue((boolean)this.sysAuthUserManager.hasRights(appId), (String)"\u60a8\u65e0\u8be5\u5e94\u7528\u6743\u9650\uff01", (Object[])new Object[0]);
        }
        return (SysApp)((Object)((SysAppDao)this.baseMapper).selectById((Serializable)((Object)appId)));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateApp(String id) {
        SysApp sysApp = (SysApp)this.get((Serializable)((Object)id));
        if (sysApp.getType() != 1) {
            SysAppMenu menu = new SysAppMenu();
            menu.setAppId(sysApp.getId());
            menu.setParentId("0");
            menu.setName(sysApp.getName());
            menu.setAlias(sysApp.getAlias());
            menu.setType(sysApp.getType());
            menu.setMenuType("page");
            menu.setContent(sysApp.getContent());
            menu.setSn(1);
            this.sysAppMenuDao.insert((Object)menu);
            sysApp.setType((short)1);
            sysApp.setContent(null);
        }
        this.update((Model)sysApp);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeApp(String[] ids) {
        this.removeByIds(ids);
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().in(SysAppMenu::getAppId, Arrays.asList(ids));
        this.sysAppMenuManager.remove((Wrapper)wrapper);
        LambdaQueryWrapper authWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(SysAuthUser::getAuthorizeId, Arrays.asList(ids))).eq(SysAuthUser::getObjType, (Object)"app");
        this.sysAuthUserManager.remove((Wrapper)authWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createOrUpdate(SysApp sysApp) {
        if (StringUtil.isEmpty((String)sysApp.getId())) {
            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysApp::getAlias, (Object)sysApp.getAlias());
            Assert.isTrue((boolean)StringUtil.isNotEmpty((String)sysApp.getAlias()), (String)"\u5e94\u7528\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            if (this.count((Wrapper)wrapper) > 0) {
                throw new BaseException("\u5e94\u7528\u522b\u540d\u5df2\u5b58\u5728");
            }
            sysApp.setId(UniqueIdUtil.getSuid());
            this.create(sysApp);
            this.updateApp(sysApp.getId());
        } else {
            this.update((Model)sysApp);
            this.updateTags(sysApp);
        }
    }

    private void updateTags(SysApp sysApp) {
        List<SysTag> tags = this.sysTagManager.getTagsByTypeId(sysApp.getMenuId());
        List tagIds = tags.stream().map(SysTag::getId).collect(Collectors.toList());
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppTagsRelation::getAppId, (Object)sysApp.getId())).notIn(!tagIds.isEmpty(), AppTagsRelation::getTagId, tagIds);
        this.appTagsRelationManager.remove((Wrapper)wrapper);
    }

    @Override
    public boolean hasRight() {
        QueryFilter filter = QueryFilter.build();
        filter.setPageBean(new PageBean(Integer.valueOf(1), Integer.valueOf(1)));
        PageList<SysApp> list = this.queryByFilter((QueryFilter<SysApp>)filter);
        return !list.getRows().isEmpty();
    }

    @Override
    public CommonResult<String> batchSaveUserApp(List<SysApp> sysApps, Boolean isDefault, String columnAlias) {
        IUser currentUser = ContextUtil.getCurrentUser();
        if (isDefault.booleanValue()) {
            this.sysUserAppManager.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserApp::getAccount, (Object)currentUser.getAccount()));
            return CommonResult.success((Object)"\u6062\u590d\u9ed8\u8ba4\u6210\u529f!");
        }
        if (BeanUtils.isNotEmpty(sysApps)) {
            ArrayList<SysUserApp> userApps = new ArrayList<SysUserApp>();
            for (SysApp sysApp : sysApps) {
                userApps.add(new SysUserApp("pc", sysApp.getAlias(), currentUser.getAccount(), columnAlias));
            }
            if (BeanUtils.isNotEmpty(userApps)) {
                this.sysUserAppManager.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserApp::getAccount, (Object)currentUser.getAccount())).eq(SysUserApp::getColumnAlias, (Object)columnAlias));
                this.sysUserAppManager.saveBatch(userApps);
            }
        }
        return CommonResult.success((Object)"\u66f4\u65b0\u6210\u529f!");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void copyApp(SysAppCopyDTO sysAppCopy) {
        SysApp sysApp = (SysApp)this.get((Serializable)((Object)sysAppCopy.getAppId()));
        Assert.notNull((Object)((Object)sysApp), (String)"\u88ab\u590d\u5236\u5e94\u7528\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        SysApp copyApp = (SysApp)((Object)BeanUtil.copyProperties((Object)((Object)sysApp), SysApp.class, (String[])new String[]{"id", "tenantId"}));
        copyApp.setAlias(sysAppCopy.getAlias());
        copyApp.setName(sysAppCopy.getName());
        copyApp.setMenuId(sysAppCopy.getMenuId());
        this.createOrUpdate(copyApp);
        this.sysAppMenuManager.copyMenus(sysAppCopy.getAppId(), copyApp.getId());
    }
}

