/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.sys.persistence.manager.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.lang.Assert;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.hotent.base.exception.BaseException;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.MapUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.ZipUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.i18n.util.I18nUtil;
import com.hotent.sys.persistence.dao.SysAppMenuDao;
import com.hotent.sys.persistence.manager.SysAppManager;
import com.hotent.sys.persistence.manager.SysAppMenuManager;
import com.hotent.sys.persistence.manager.SysAuthUserManager;
import com.hotent.sys.persistence.model.SysApp;
import com.hotent.sys.persistence.model.SysAppMenu;
import com.hotent.sys.util.SortUtil;
import com.hotent.sys.vo.SysMenuSortVO;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import java.io.File;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service(value="sysAppMenuManager")
public class SysAppMenuManagerImpl
extends BaseManagerImpl<SysAppMenuDao, SysAppMenu>
implements SysAppMenuManager {
    @Resource
    SysAuthUserManager sysAuthUserManager;
    @Resource
    SysAppManager sysAppManager;
    @Resource
    UCFeignService ucFeignService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResult<String> importData(MultipartFile file, String parentMenuId, String appId) throws Exception {
        String unZipFilePath = "";
        try {
            String rootRealPath = (FileUtil.getIoTmpdir() + "/attachFiles/unZip/").replace("/", File.separator);
            FileUtil.createFolder((String)rootRealPath, (boolean)true);
            String name = file.getOriginalFilename();
            String fileDir = StringUtil.substringBeforeLast((String)name, (String)".");
            ZipUtil.unZipFile((MultipartFile)file, (String)rootRealPath);
            unZipFilePath = rootRealPath + File.separator + fileDir;
            this.importFile(unZipFilePath, parentMenuId, appId);
            CommonResult commonResult = new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
            return commonResult;
        }
        catch (Exception e) {
            throw new BaseException("\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
        }
        finally {
            File zipFile;
            if (StringUtil.isNotEmpty((String)unZipFilePath) && (zipFile = new File(unZipFilePath)).exists()) {
                zipFile.delete();
            }
        }
    }

    @Override
    public void exportData(String appId, String parentMenuId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysAppMenu::getAppId, (Object)appId);
        List menus = this.list((Wrapper)wrapper);
        if (BeanUtils.isEmpty((Object)menus)) {
            throw new BaseException("\u5bfc\u51fa\u7684\u83dc\u5355\u4e0d\u5b58\u5728\uff01");
        }
        BeanUtils.listToTree((List)menus);
        List outputMenus = menus.stream().filter(menu -> parentMenuId.equalsIgnoreCase(menu.getId())).collect(Collectors.toList());
        SysApp sysApp = (SysApp)this.sysAppManager.get((Serializable)((Object)appId));
        Assert.notNull((Object)((Object)sysApp), (String)"\u5e94\u7528\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        SysAppMenu sysAppMenu = (SysAppMenu)this.get((Serializable)((Object)parentMenuId));
        Assert.notNull((Object)((Object)sysApp), (String)"\u5e94\u7528\u83dc\u5355\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        String json = JsonUtil.toJson((Object)BeanUtils.treeToList(outputMenus));
        HashMap<String, String> fileContentMap = new HashMap<String, String>();
        fileContentMap.put("sysAppMenus.json", json);
        String fileName = String.format("\u5e94\u7528\u83dc\u5355-%s-%s-%s", sysApp.getName(), sysAppMenu.getName(), DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyyMMdd_HHmm"));
        HttpUtil.downLoadFile((HttpServletRequest)request, (HttpServletResponse)response, fileContentMap, (String)fileName);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeResById(String id) {
        this.remove((Serializable)((Object)id));
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysAppMenu::getParentId, (Object)id);
        List subMenus = this.list((Wrapper)wrapper);
        subMenus.forEach(subMenu -> this.removeResById(subMenu.getId()));
    }

    @Override
    public CommonResult<SysAppMenu> isSinglePage(String appId) {
        List<SysAppMenu> menus;
        if (!ContextUtil.getCurrentUser().isAdmin()) {
            Assert.isTrue((boolean)this.sysAuthUserManager.hasRights(appId), (String)"\u60a8\u65e0\u6b64\u5e94\u7528\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (Object[])new Object[0]);
        }
        if ((menus = this.getAppCurrentMenus(appId)).size() == 0) {
            return new CommonResult(true, "\u60a8\u65e0\u6b64\u5e94\u7528\u83dc\u5355\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        if (menus.size() == 1) {
            if ("page".equals(menus.get(0).getMenuType())) {
                return new CommonResult(true, "success", (Object)menus.get(0));
            }
            return new CommonResult(true, "success");
        }
        return new CommonResult(true, "success");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResult<String> sort(SysMenuSortVO sortVO) {
        if (!"0".equals(sortVO.getParentId())) {
            SysAppMenu nodeMenu = (SysAppMenu)this.get((Serializable)((Object)sortVO.getParentId()));
            Assert.notNull((Object)((Object)nodeMenu), (String)"\u7236\u7ea7\u83dc\u5355\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        }
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(SysAppMenu::getId, sortVO.getMenuIds())).eq(SysAppMenu::getAppId, (Object)sortVO.getAppId())).orderByAsc(SysAppMenu::getSn);
        List menus = this.list((Wrapper)wrapper);
        Map<String, Integer> sortMap = SortUtil.sortToMap(sortVO.getMenuIds());
        menus.forEach(menu -> {
            menu.setSn((Integer)sortMap.get(menu.getId()));
            menu.setParentId(sortVO.getParentId());
        });
        this.updateBatchById(menus);
        return new CommonResult(true, "\u6392\u5e8f\u6210\u529f");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createOrUpdate(SysAppMenu sysAppMenu) {
        if (StringUtil.isEmpty((String)sysAppMenu.getId())) {
            LambdaQueryWrapper countWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysAppMenu::getAlias, (Object)sysAppMenu.getAlias())).eq(SysAppMenu::getAppId, (Object)sysAppMenu.getAppId());
            if (this.count((Wrapper)countWrapper) > 0) {
                throw new BaseException("\u83dc\u5355\u522b\u540d\u5df2\u5b58\u5728");
            }
            QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)Wrappers.query().select(new String[]{"max(sn_) as max_sn_"}).eq((Object)"app_id_", (Object)sysAppMenu.getAppId())).eq((Object)"parent_id_", (Object)sysAppMenu.getParentId());
            Map map = this.getMap((Wrapper)wrapper);
            sysAppMenu.setSn(MapUtil.getInt((Map)Optional.ofNullable(map).orElse(new HashMap()), (String)"max_sn_", (int)0) + 1);
            this.create((Model)sysAppMenu);
        } else {
            this.update((Model)sysAppMenu);
        }
        this.sysAppManager.updateApp(sysAppMenu.getAppId());
    }

    @Override
    public List<SysAppMenu> getMenuTree(String appId) {
        SysApp sysApp = (SysApp)this.sysAppManager.get((Serializable)((Object)appId));
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"app_id_", (Object)appId);
        List<SysAppMenu> menus = this.i18nSysMenu(this.list((Wrapper)wrapper), sysApp.getAlias());
        menus = menus.stream().sorted(Comparator.comparing(SysAppMenu::getSn)).collect(Collectors.toList());
        return BeanUtils.listToTree(menus);
    }

    @Override
    public List<SysAppMenu> getMenuAuthorization(String appId, String roleAlias) {
        return ((SysAppMenuDao)this.baseMapper).getMenuAuthorizations(appId, roleAlias);
    }

    @Override
    public List<SysAppMenu> getAppCurrentMenus(String appId) {
        SysApp sysApp = (SysApp)this.sysAppManager.get((Serializable)((Object)appId));
        if (BeanUtils.isEmpty((Object)((Object)sysApp))) {
            return new ArrayList<SysAppMenu>();
        }
        IUser user = ContextUtil.getCurrentUser();
        if (user.isAdmin()) {
            return this.getMenuTree(appId);
        }
        List roles = this.ucFeignService.getRoleListByAccount(user.getAccount());
        List roleCodes = roles.stream().filter(role -> 1 == JsonUtil.getInt((JsonNode)role, (String)"enabled", (int)0)).map(role -> role.get("code").asText()).collect(Collectors.toList());
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("appId", appId);
        param.put("roleCodes", roleCodes);
        param.put("currentUserId", ContextUtil.getCurrentUserId());
        List menus = this.i18nSysMenu(((SysAppMenuDao)this.baseMapper).getAppCurrentMenu(param), sysApp.getAlias());
        menus = menus.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<SysAppMenu>(Comparator.comparing(SysAppMenu::getId))), ArrayList::new));
        menus = menus.stream().sorted(Comparator.comparing(SysAppMenu::getSn)).collect(Collectors.toList());
        return BeanUtils.listToTree(menus);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void copyMenus(String oldAppId, String newAppId) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysAppMenu::getAppId, (Object)oldAppId);
        List menus = this.list((Wrapper)wrapper);
        HashMap oldAndNewIdMap = new HashMap();
        menus.forEach(menu -> oldAndNewIdMap.put(menu.getId(), UniqueIdUtil.getSuid()));
        List newMenus = menus.stream().map(menu -> {
            SysAppMenu sysAppMenu = (SysAppMenu)((Object)((Object)BeanUtil.copyProperties((Object)menu, SysAppMenu.class, (String[])new String[]{"id", "tenantId"})));
            sysAppMenu.setId((String)oldAndNewIdMap.get(menu.getId()));
            sysAppMenu.setParentId(oldAndNewIdMap.getOrDefault(menu.getParentId(), "0"));
            sysAppMenu.setAppId(newAppId);
            return sysAppMenu;
        }).collect(Collectors.toList());
        this.saveBatch(newMenus);
    }

    @Override
    public List<SysAppMenu> getByAppId(String appId) {
        return this.list((Wrapper)Wrappers.lambdaQuery().eq(SysAppMenu::getAppId, (Object)appId));
    }

    private List<SysAppMenu> i18nSysMenu(List<SysAppMenu> menus, String appKey) {
        String formatKey = "app.%s.menu.%s";
        List i18nKeys = menus.stream().map(menu -> String.format(formatKey, appKey, menu.getAlias())).collect(Collectors.toList());
        Map messages = I18nUtil.getMessages(i18nKeys, (Locale)LocaleContextHolder.getLocale());
        for (SysAppMenu sysMenu : menus) {
            String key = String.format(formatKey, appKey, sysMenu.getAlias());
            if (!messages.containsKey(key) || !StringUtil.isNotEmpty((String)((String)messages.get(key)))) continue;
            String newName = (String)messages.get(key);
            sysMenu.setName(newName);
        }
        return menus;
    }

    private void importFile(String unZipFilePath, String parentMenuId, String appId) throws Exception {
        SysAppMenu baseParentMenu = "0".equals(parentMenuId) ? SysAppMenu.rootMenu(appId) : (SysAppMenu)this.get((Serializable)((Object)parentMenuId));
        String json = FileUtil.readFile((String)(unZipFilePath + File.separator + "sysAppMenus.json"));
        TypeReference<List<SysAppMenu>> typeReference = new TypeReference<List<SysAppMenu>>(){};
        List list = (List)JsonUtil.toBean((String)json, (TypeReference)typeReference);
        list = BeanUtils.listToTree((List)list);
        for (int i = 0; i < list.size(); ++i) {
            SysAppMenu sysMenu = (SysAppMenu)((Object)list.get(i));
            List menus = this.list((Wrapper)Wrappers.lambdaQuery().eq(SysAppMenu::getAppId, (Object)appId));
            Set<String> menusSet = menus.stream().map(SysAppMenu::getAlias).collect(Collectors.toSet());
            this.getTreeMenu(sysMenu, baseParentMenu, menusSet);
        }
    }

    public void getTreeMenu(SysAppMenu sysMenu, SysAppMenu parentMenu, Set<String> menusSet) throws Exception {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysAppMenu::getAlias, (Object)sysMenu.getAlias())).eq(SysAppMenu::getAppId, (Object)parentMenu.getAppId());
        SysAppMenu menu = (SysAppMenu)((Object)this.getOne((Wrapper)wrapper));
        if (BeanUtils.isNotEmpty((Object)((Object)menu))) {
            String finalAlias = this.createAlias(menusSet, sysMenu.getAlias());
            sysMenu.setAlias(finalAlias);
        }
        sysMenu.setParentId(parentMenu.getId());
        sysMenu.setAppId(parentMenu.getAppId());
        String nId = UniqueIdUtil.getSuid();
        sysMenu.setId(nId);
        sysMenu.setTenantId(null);
        this.create((Model)sysMenu);
        menusSet.add(sysMenu.getAlias());
        if (BeanUtils.isEmpty((Object)sysMenu.getChildren())) {
            return;
        }
        for (Object chirden : sysMenu.getChildren()) {
            this.getTreeMenu((SysAppMenu)((Object)chirden), sysMenu, menusSet);
        }
    }

    private String createAlias(Set<String> aliasList, String alias) {
        int index = 1;
        String tempAlias = alias;
        while (aliasList.contains(tempAlias)) {
            tempAlias = alias + index++;
        }
        return tempAlias;
    }
}

