/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.sys.persistence.manager.impl;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.cache.annotation.CacheEvict;
import com.hotent.base.cache.annotation.Cacheable;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.util.AppUtil;
import com.hotent.sys.persistence.dao.SysLogsSettingsDao;
import com.hotent.sys.persistence.manager.SysLogsSettingsManager;
import com.hotent.sys.persistence.model.SysLogsSettings;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service(value="sysLogsSettingsManager")
public class SysLogsSettingsManagerImpl
extends BaseManagerImpl<SysLogsSettingsDao, SysLogsSettings>
implements SysLogsSettingsManager {
    public void remove(Serializable id) {
        super.remove(id);
        SysLogsSettingsManagerImpl bean = (SysLogsSettingsManagerImpl)AppUtil.getBean(this.getClass());
        bean.cleanStatus();
        bean.cleanDays();
    }

    public void removeByIds(String ... ids) {
        super.removeByIds(ids);
        SysLogsSettingsManagerImpl bean = (SysLogsSettingsManagerImpl)AppUtil.getBean(this.getClass());
        bean.cleanStatus();
        bean.cleanDays();
    }

    public void create(SysLogsSettings t) {
        super.create((Model)t);
        SysLogsSettingsManagerImpl bean = (SysLogsSettingsManagerImpl)AppUtil.getBean(this.getClass());
        bean.cleanStatus();
        bean.cleanDays();
    }

    public void update(SysLogsSettings t) {
        super.update((Model)t);
        SysLogsSettingsManagerImpl bean = (SysLogsSettingsManagerImpl)AppUtil.getBean(this.getClass());
        bean.cleanStatus();
        bean.cleanDays();
    }

    @CacheEvict(value={"eip:sys:logsSettingStatus"}, key="SYS_LOGS_SETTING_STATUS", pureKey=true)
    protected void cleanStatus() {
    }

    @CacheEvict(value={"eip:sys:logsSettingDay"}, key="SYS_LOGS_SETTING_SAVE_DAY", pureKey=true)
    protected void cleanDays() {
    }

    @Override
    public Map<String, String> getSysLogsSettingStatusMap() {
        List all = this.list();
        HashMap<String, String> statusMap = new HashMap<String, String>();
        for (SysLogsSettings sysLogsSettings : all) {
            statusMap.put(sysLogsSettings.getModuleType(), sysLogsSettings.getStatus());
        }
        return statusMap;
    }

    @Override
    @Cacheable(value={"eip:sys:logsSettingDay"}, key="SYS_LOGS_SETTING_SAVE_DAY", pureKey=true)
    public Map<String, Integer> getSysLogsSettingDaysMap() {
        List all = this.list();
        HashMap<String, Integer> saveDayMap = new HashMap<String, Integer>();
        for (SysLogsSettings sysLogsSettings : all) {
            saveDayMap.put(sysLogsSettings.getModuleType(), sysLogsSettings.getSaveDays());
        }
        return saveDayMap;
    }
}

