/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.sys.persistence.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.cache.annotation.CacheEvict;
import com.hotent.base.cache.annotation.CachePut;
import com.hotent.base.cache.annotation.Cacheable;
import com.hotent.base.cache.annotation.FirstCache;
import com.hotent.base.exception.BaseException;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.model.ImportCheckResult;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.JAXBUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ThreadMsgUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.sys.persistence.dao.SysModuleDao;
import com.hotent.sys.persistence.manager.SysAppManager;
import com.hotent.sys.persistence.manager.SysMenuManager;
import com.hotent.sys.persistence.manager.SysModuleDetailManager;
import com.hotent.sys.persistence.manager.SysModuleManager;
import com.hotent.sys.persistence.model.SysApp;
import com.hotent.sys.persistence.model.SysMenu;
import com.hotent.sys.persistence.model.SysModule;
import com.hotent.sys.persistence.model.SysModuleDetail;
import com.hotent.sys.persistence.param.SysModuleImportXml;
import com.hotent.sys.persistence.param.SysModuleXml;
import com.hotent.sys.vo.SaveAndPublishModuleVo;
import com.hotent.sys.vo.SysModuleMenuVo;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IGroup;
import com.hotent.uc.api.model.IUser;
import java.io.File;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.xml.bind.JAXBException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SysModuleManagerImpl
extends BaseManagerImpl<SysModuleDao, SysModule>
implements SysModuleManager {
    @Resource
    SysModuleDetailManager sysModuleDetailManager;
    @Resource
    SysMenuManager sysMenuManager;
    @Resource
    SysAppManager sysAppManager;

    public void remove(Serializable id) {
        super.remove(id);
        this.sysModuleDetailManager.removeByModuleId(id);
    }

    public void removeByIds(String ... ids) {
        if (ids != null) {
            for (String pk : ids) {
                this.remove((Serializable)((Object)pk));
            }
        }
    }

    @Override
    public void saveModule(SysModule sysModule) {
        String id = sysModule.getId();
        IUser user = ContextUtil.getCurrentUser();
        List<SysModuleDetail> details1 = sysModule.getModuleDetail();
        if (BeanUtils.isNotEmpty((Object)user)) {
            sysModule.setCreateBy(user.getUserId());
            sysModule.setCreator(user.getFullname());
        } else {
            sysModule.setCreator("\u7cfb\u7edf");
        }
        if (StringUtil.isEmpty((String)id)) {
            sysModule.setId(UniqueIdUtil.getSuid());
            sysModule.setUpdateTime(LocalDateTime.now());
            this.create((Model)sysModule);
        } else {
            this.update((Model)sysModule);
            this.sysModuleDetailManager.removeByModuleId((Serializable)((Object)sysModule.getId()));
        }
        List<SysModuleDetail> details = sysModule.getModuleDetail();
        if (BeanUtils.isNotEmpty(details)) {
            for (int x = 0; x < details.size(); ++x) {
                SysModuleDetail sysModuleDetail = details.get(x);
                sysModuleDetail.setSn(x);
                if (StringUtil.isEmpty((String)sysModuleDetail.getId())) {
                    sysModuleDetail.setId(UniqueIdUtil.getSuid());
                }
                sysModuleDetail.setModuleId(sysModule.getId());
                this.sysModuleDetailManager.create((Model)sysModuleDetail);
            }
        }
    }

    @Override
    public SysModule getModuleByCode(String code) {
        return ((SysModuleDao)this.baseMapper).getModuleByCode(code);
    }

    @Override
    public Map<String, String> exportModules(List<String> idList) throws JAXBException {
        SysModuleImportXml importXml = new SysModuleImportXml();
        HashMap<String, String> map = new HashMap<String, String>();
        for (String id : idList) {
            SysModule module = (SysModule)this.get((Serializable)((Object)id));
            Assert.notNull((Object)((Object)module), (String)("\u4e0d\u5b58\u5728id\u4e3a[" + id + "]\u7684\u6a21\u5757"));
            if (!BeanUtils.isNotEmpty((Object)((Object)module))) continue;
            SysModuleXml moduleXml = new SysModuleXml();
            moduleXml.setSysModule(module);
            List<SysModuleDetail> details = this.sysModuleDetailManager.getModuleDetail(id, null);
            moduleXml.setModuleDetail(details);
            importXml.addModuleXml(moduleXml);
        }
        map.put("module.xml", JAXBUtil.marshall((Object)importXml, SysModuleImportXml.class));
        return map;
    }

    @Override
    public Map<String, String> importModules(SysModuleImportXml importXml) {
        List<SysModuleXml> moduleXmls = importXml.getModuleXmlList();
        for (SysModuleXml sysModuleXml : moduleXmls) {
            SysModule module = sysModuleXml.getSysModule();
            IUser user = ContextUtil.getCurrentUser();
            module.setCreateBy(user.getFullname());
            module.setCreateBy(user.getUserId());
            module.setUpdateBy(user.getUserId());
            SysModule oldModule = this.getModuleByCode(module.getCode());
            if (BeanUtils.isEmpty((Object)((Object)oldModule))) {
                module.setId(UniqueIdUtil.getSuid());
                module.setUpdateTime(LocalDateTime.now());
                this.create((Model)module);
                ThreadMsgUtil.addMsg((String)("\u6a21\u5757 \u201c" + module.getName() + "\u201d[" + module.getCode() + "] \u6dfb\u52a0\u6210\u529f\uff01"));
            } else {
                module.setId(oldModule.getId());
                this.update((Model)module);
                ThreadMsgUtil.addMsg((String)("\u6a21\u5757 \u201c" + module.getName() + "\u201d[" + module.getCode() + "] \u5df2\u5b58\u5728\uff0c\u66f4\u65b0\u6210\u529f\uff01"));
            }
            List<SysModuleDetail> details = sysModuleXml.getModuleDetail();
            this.sysModuleDetailManager.removeByModuleId((Serializable)((Object)module.getId()));
            if (!BeanUtils.isNotEmpty(details)) continue;
            for (SysModuleDetail detail : details) {
                detail.setId(UniqueIdUtil.getSuid());
                detail.setModuleId(module.getId());
                this.sysModuleDetailManager.create((Model)detail);
            }
        }
        List alias = moduleXmls.stream().map(item -> item.getSysModule().getCode()).collect(Collectors.toList());
        return this.list((Wrapper)Wrappers.lambdaQuery().in(SysModule::getCode, alias)).stream().collect(Collectors.toMap(SysModule::getCode, SysModule::getId, (k1, k2) -> k1));
    }

    public boolean importModulesCheckRepeat(String unZipFilePath) throws JAXBException, UnsupportedEncodingException {
        String moduleXmlStr = FileUtil.readFile((String)(unZipFilePath + File.separator + "module.xml"));
        if (StringUtil.isNotEmpty((String)moduleXmlStr)) {
            ArrayList<String> existSysModuleList = new ArrayList<String>();
            SysModuleImportXml importXml = (SysModuleImportXml)JAXBUtil.unmarshall((String)moduleXmlStr, SysModuleImportXml.class);
            List<SysModuleXml> moduleXmls = importXml.getModuleXmlList();
            for (SysModuleXml sysModuleXml : moduleXmls) {
                SysModule module = sysModuleXml.getSysModule();
                SysModule oldModule = this.getModuleByCode(module.getCode());
                if (BeanUtils.isEmpty((Object)((Object)oldModule))) continue;
                module.setUpdateTime(LocalDateTime.now());
                existSysModuleList.add(module.getName());
            }
            if (BeanUtils.isNotEmpty(existSysModuleList)) {
                StringUtil.join(existSysModuleList, (String)",");
                ThreadMsgUtil.addMsg((String)String.format("\u5bfc\u5165\u5931\u8d25\uff0c\u6a21\u5757\u3010%s\u3011\u5df2\u5b58\u5728\uff0c\u662f\u5426\u66f4\u65b0\u8986\u76d6\uff01", StringUtil.join(existSysModuleList, (String)",")));
                return true;
            }
            this.importModules(importXml);
        }
        return false;
    }

    @Override
    @Transactional
    public void saveAndPublishModule(SysModule sysModule) {
        SysModule oldModule = this.getModuleByCode(sysModule.getCode());
        if (BeanUtils.isNotEmpty((Object)((Object)oldModule))) {
            throw new BaseException("\u6a21\u5757\u522b\u540d\u3010" + sysModule.getCode() + "\u3011\u5df2\u5b58\u5728");
        }
        this.create((Model)sysModule);
        List<SysModuleDetail> details = this.getDefaultFlowDetails(sysModule);
        for (SysModuleDetail detail : details) {
            this.sysModuleDetailManager.create((Model)detail);
        }
    }

    @Override
    public CommonResult<String> saveSysModule(SysModule sysModule) {
        CommonResult resultMsg = null;
        String id = sysModule.getId();
        boolean isDeploy = sysModule.isDeploy();
        try {
            if (StringUtil.isEmpty((String)id)) {
                SysModule oldSysModule = this.getModuleByCode(sysModule.getCode());
                if (BeanUtils.isNotEmpty((Object)((Object)oldSysModule))) {
                    throw new RuntimeException("\u7f16\u7801\uff1a" + sysModule.getCode() + "\u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u6a21\u5757\u7f16\u7801\uff01");
                }
                sysModule.setId(UniqueIdUtil.getSuid());
                IGroup iGroup = ContextUtil.getCurrentGroup();
                if (BeanUtils.isNotEmpty((Object)iGroup)) {
                    sysModule.setCreateOrgId(iGroup.getGroupId());
                }
                sysModule.setUpdateTime(LocalDateTime.now());
                this.create((Model)sysModule);
                resultMsg = new CommonResult(isDeploy ? "\u6a21\u5757\u6dfb\u52a0\u3001\u53d1\u5e03\u6210\u529f" : "\u6dfb\u52a0\u6a21\u5757\u6210\u529f");
            } else {
                this.update((Model)sysModule);
                resultMsg = new CommonResult(isDeploy ? "\u6a21\u5757\u66f4\u65b0\u3001\u53d1\u5e03\u6210\u529f" : "\u66f4\u65b0\u6a21\u5757\u6210\u529f");
            }
        }
        catch (Exception e) {
            resultMsg = new CommonResult(false, "\u5bf9\u6a21\u5757\u64cd\u4f5c\u5931\u8d25" + e.getMessage());
        }
        return resultMsg;
    }

    @Override
    public CommonResult<String> importModule(Optional<String> cacheFileId) throws JAXBException, UnsupportedEncodingException {
        CommonResult message = new CommonResult("\u5bfc\u5165\u6210\u529f");
        String moduleXmlStr = ((SysModuleManagerImpl)AppUtil.getBean(this.getClass())).getImportFileFromCache(cacheFileId.get());
        if (StringUtil.isEmpty((String)moduleXmlStr)) {
            message.setState(Boolean.valueOf(false));
            message.setMessage("\u5bfc\u5165\u7684\u6587\u4ef6\u5df2\u7ecf\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u5bfc\u5165\u3002");
            return message;
        }
        SysModuleImportXml importXml = (SysModuleImportXml)JAXBUtil.unmarshall((String)moduleXmlStr, SysModuleImportXml.class);
        this.importModules(importXml);
        this.delImportFileFromCache(cacheFileId.orElse(""));
        return message;
    }

    /*
     * Exception decompiling
     */
    @Override
    public CommonResult<String> importModuleCheck(MultipartFile file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    @CachePut(value={"eip:flow_module:importFile"}, key="#fileId", firstCache=@FirstCache(expireTime=1, timeUnit=TimeUnit.HOURS))
    public String putImportFileInCache(String fileId, String fileJson) {
        return fileJson;
    }

    @Override
    @Cacheable(value={"eip:flow_module:importFile"}, key="#fileId", firstCache=@FirstCache(expireTime=1, timeUnit=TimeUnit.HOURS))
    public String getImportFileFromCache(String fileId) {
        return null;
    }

    @Override
    @CacheEvict(value={"eip:flow_module:importFile"}, key="#fileId")
    public void delImportFileFromCache(String fileId) {
    }

    @Override
    public CommonResult<String> saveAndPublishModule(SaveAndPublishModuleVo saveAndPublishModuleVo, String type) {
        PlatformTransactionManager transactionManagerl = (PlatformTransactionManager)AppUtil.getBean(PlatformTransactionManager.class);
        DefaultTransactionDefinition defaultTransactionDefinition = new DefaultTransactionDefinition();
        defaultTransactionDefinition.setPropagationBehavior(0);
        TransactionStatus status = transactionManagerl.getTransaction((TransactionDefinition)defaultTransactionDefinition);
        try {
            String sysModuleId = UniqueIdUtil.getSuid();
            saveAndPublishModuleVo.getSysModule().setId(sysModuleId);
            String message = "\u4fdd\u5b58\u6210\u529f";
            this.saveAndPublishModule(saveAndPublishModuleVo.getSysModule());
            if (BeanUtils.isNotEmpty((Object)saveAndPublishModuleVo.getTemplateToMenuVo())) {
                SysModuleMenuVo templateToMenuVo = saveAndPublishModuleVo.getTemplateToMenuVo();
                message = "\u4fdd\u5b58\u5e76\u53d1\u5e03\u6210\u529f";
                if (!"app".equals(type)) {
                    if (StringUtil.isEmpty((String)templateToMenuVo.getParentAlias())) {
                        throw new BaseException("\u7236\u83dc\u5355\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtil.isEmpty((String)templateToMenuVo.getAlias())) {
                        throw new BaseException("\u83dc\u5355\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    SysMenu pMenu = this.sysMenuManager.getByAlias(templateToMenuVo.getParentAlias());
                    if (BeanUtils.isEmpty((Object)((Object)pMenu))) {
                        throw new BaseException("\u6839\u636e\u7236\u83dc\u5355\u522b\u540d" + templateToMenuVo.getParentAlias() + "\u672a\u627e\u5230\u5bf9\u5e94\u83dc\u5355\uff01");
                    }
                    boolean isExist = this.sysMenuManager.isExistByAlias(templateToMenuVo.getAlias());
                    if (isExist) {
                        throw new BaseException("\u83dc\u5355\u522b\u540d\u3010" + templateToMenuVo.getAlias() + "\u3011\u5df2\u5b58\u5728\uff01");
                    }
                    SysMenu templateListMenu = new SysMenu();
                    String id = UniqueIdUtil.getSuid();
                    templateListMenu.setPath(pMenu.getPath() + id + ".");
                    templateListMenu.setSn(99);
                    templateListMenu.setOpen(false);
                    templateListMenu.setHref(templateToMenuVo.getHref() + sysModuleId + "/" + saveAndPublishModuleVo.getSysModule().getName());
                    templateListMenu.setAlias(templateToMenuVo.getAlias());
                    templateListMenu.setName(templateToMenuVo.getName());
                    templateListMenu.setActiveTab(templateToMenuVo.getPath());
                    templateListMenu.setId(id);
                    templateListMenu.setParentId(pMenu.getId());
                    this.sysMenuManager.create((Model)templateListMenu);
                } else {
                    ObjectNode contnet = JsonUtil.getMapper().createObjectNode();
                    contnet.put("id", sysModuleId);
                    contnet.put("name", saveAndPublishModuleVo.getSysModule().getName());
                    SysApp sysApp = new SysApp();
                    sysApp.setType((short)7);
                    sysApp.setIcon("icon-hotent-H");
                    sysApp.setName(templateToMenuVo.getName());
                    sysApp.setIsPublish(SysApp.IS_PUBLISH);
                    if (StringUtil.isEmpty((String)templateToMenuVo.getAppTypeAlias()) || StringUtil.isEmpty((String)templateToMenuVo.getAppTypeId())) {
                        throw new BaseException("\u5e94\u7528\u83dc\u5355\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    sysApp.setContent(JsonUtil.toJson((Object)contnet));
                    sysApp.setMenuId(templateToMenuVo.getAppTypeId());
                    sysApp.setMenuAlias(templateToMenuVo.getAppTypeAlias());
                    this.sysAppManager.getBaseMapper().insert((Object)sysApp);
                }
            }
            transactionManagerl.commit(status);
            return new CommonResult(true, message);
        }
        catch (Exception e) {
            transactionManagerl.rollback(status);
            return new CommonResult(false, "\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private List<SysModuleDetail> getDefaultFlowDetails(SysModule sysModule) {
        if ("form".equals(sysModule.getType())) {
            for (int i = 0; i < sysModule.getModuleDetail().size(); ++i) {
                SysModuleDetail sysModuleDetail = sysModule.getModuleDetail().get(i);
                sysModuleDetail.setModuleId(sysModule.getId());
                sysModuleDetail.setShowType("form");
                sysModuleDetail.setSn(i);
                sysModuleDetail.setType("workspace");
            }
            return sysModule.getModuleDetail();
        }
        ArrayList<SysModuleDetail> details = new ArrayList<SysModuleDetail>();
        details.add(new SysModuleDetail("todo", "\u5f85\u529e\u4e8b\u9879", "/matter/myTask?tabActiveName=todo&from=applicationModule&__isFull__=true&flowKey=" + sysModule.getRelCode()));
        details.add(new SysModuleDetail("done", "\u5df2\u529e\u4e8b\u9879", "/matter/myTask?tabActiveName=done&from=applicationModule&__isFull__=true&flowKey=" + sysModule.getRelCode()));
        details.add(new SysModuleDetail("request", "\u6211\u7684\u8bf7\u6c42", "/matter/apply?&from=applicationModule&__isFull__=true&flowKey=" + sysModule.getRelCode()));
        details.add(new SysModuleDetail("newProcess", "\u53d1\u8d77" + sysModule.getRelName(), "/matter/startProcess?defId=&tabActiveName=processOverview&from=applicationModule&__isFull__=true&flowKey=" + sysModule.getRelCode()));
        details.add(new SysModuleDetail("todoRead", "\u5f85\u9605\u4e8b\u9879", "/matter/circulateMatter?tabActiveName=received&from=applicationModule&__isFull__=true&flowKey=" + sysModule.getRelCode()));
        details.add(new SysModuleDetail("myRead", "\u6211\u6536\u5230\u7684", "/matter/circulateMatter?tabActiveName=circulated&from=applicationModule&__isFull__=true&flowKey=" + sysModule.getRelCode()));
        details.add(new SysModuleDetail("myDelegate", "\u6211\u8f6c\u529e\u7684", "/matter/myTask?tabActiveName=myDelegate&from=applicationModule&__isFull__=true&flowKey=" + sysModule.getRelCode()));
        for (int i = 0; i < details.size(); ++i) {
            ((SysModuleDetail)((Object)details.get(i))).setModuleId(sysModule.getId());
            ((SysModuleDetail)((Object)details.get(i))).setType("workspace");
            ((SysModuleDetail)((Object)details.get(i))).setShowType("flow");
            ((SysModuleDetail)((Object)details.get(i))).setSn(i);
        }
        return details;
    }

    @Override
    public CommonResult<String> updateSysModuleByCustomId(String customChartId, ObjectNode objectNode) {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("URL_", (Object)customChartId, QueryOP.EQUAL);
        queryFilter.setPageBean(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        List sysModuleDetails = this.sysModuleDetailManager.query(queryFilter).getRows();
        if (sysModuleDetails.size() == 0) {
            return new CommonResult(true, "\u4e0d\u5b58\u5728\u5f15\u7528\u8be5\u56fe\u8868\u7684\u6a21\u5757");
        }
        String name = objectNode.has("name") ? objectNode.get("name").asText() : "";
        String style = objectNode.has("style") ? objectNode.get("style").asText() : "";
        sysModuleDetails.forEach(sysModuleDetail -> {
            if (StringUtil.isNotEmpty((String)name)) {
                sysModuleDetail.setName(name);
            }
            if (StringUtil.isNotEmpty((String)style)) {
                sysModuleDetail.setChartType(style);
            }
        });
        return new CommonResult(this.sysModuleDetailManager.updateBatchById(sysModuleDetails), "");
    }

    @Override
    public List<ImportCheckResult> importCheckModules(SysModuleImportXml sysModuleImportXml) {
        ArrayList<ImportCheckResult> results = new ArrayList<ImportCheckResult>();
        for (SysModuleXml sysModuleXml : sysModuleImportXml.getModuleXmlList()) {
            SysModule module = sysModuleXml.getSysModule();
            SysModule oldModule = this.getModuleByCode(module.getCode());
            if (!BeanUtils.isNotEmpty((Object)((Object)oldModule))) continue;
            results.add(new ImportCheckResult(true, "\u6d41\u7a0b\u6a21\u5757", module.getName()));
        }
        return results;
    }
}

