/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.sys.persistence.manager.impl;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.exception.BaseException;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.id.IdGenerator;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.Base64;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.ZipUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.sys.persistence.dao.SysIdentityDao;
import com.hotent.sys.persistence.manager.SysIdentityManager;
import com.hotent.sys.persistence.model.SysIdentity;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="identityManager")
public class SysIdentityManagerImpl
extends BaseManagerImpl<SysIdentityDao, SysIdentity>
implements SysIdentityManager {
    @Resource
    SysIdentityManager identityManager;
    @Resource
    protected IdGenerator idGenerator;
    @Resource
    protected PortalFeignService portalFeignService;

    @Override
    public boolean isAliasExisted(Map<String, Object> params) {
        Integer i = ((SysIdentityDao)this.baseMapper).isAliasExisted(params);
        return i > 0;
    }

    @Override
    public String getCurIdByAlias(String alias) {
        SysIdentity identity = ((SysIdentityDao)this.baseMapper).getByAlias(alias);
        int curValue = Optional.ofNullable(identity.getCurValue()).orElse(identity.getInitValue());
        return this.getByRule(identity.getRegulation(), identity.getNoLength(), curValue);
    }

    private String getByRule(String rule, int length, int curValue) {
        Calendar c = Calendar.getInstance();
        int year = c.get(1);
        int month = c.get(2) + 1;
        int day = c.get(5);
        String yearStr = String.valueOf(year);
        String shortMonth = String.valueOf(month);
        String longMonth = month < 10 ? "0" + month : String.valueOf(month);
        String shortDay = String.valueOf(day);
        String longDay = day < 10 ? "0" + day : String.valueOf(day);
        String seqNo = SysIdentityManagerImpl.getSeqNo(rule, curValue, length);
        return rule.replace("{yyyy}", yearStr).replace("{MM}", longMonth).replace("{mm}", shortMonth).replace("{DD}", longDay).replace("{dd}", shortDay).replace("{NO}", seqNo).replace("{no}", seqNo);
    }

    private static String getSeqNo(String rule, int curValue, int length) {
        String tmp = String.valueOf(curValue);
        int len = rule.contains("no") ? length : length - tmp.length();
        StringBuilder rtn = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            rtn.append("0");
        }
        if (rule.contains("no")) {
            return tmp + rtn;
        }
        return rtn + tmp;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public synchronized List<String> nextIds(String alias, Integer count) {
        int start;
        boolean inc;
        SysIdentity identity = ((SysIdentityDao)this.baseMapper).getByAlias(alias);
        if (BeanUtils.isEmpty((Object)((Object)identity))) {
            throw new BaseException(String.format("\u83b7\u53d6\u5931\u8d25\uff0c\u6d41\u6c34\u53f7[%s]\u4e0d\u5b58\u5728", alias));
        }
        short genType = identity.getGenType();
        boolean bl = inc = identity.getGenType() == 0;
        if (inc) {
            start = identity.getCurValue() + 1;
        } else {
            String identityDate;
            String nowDate = this.getCurDate(this.getFormatString(Integer.valueOf(genType)));
            if (nowDate.equals(identityDate = identity.getCurDate())) {
                start = identity.getCurValue() + 1;
            } else {
                start = identity.getInitValue();
                identity.setCurDate(nowDate);
            }
        }
        int end = start + count - 1;
        identity.setNewCurValue(end);
        LinkedList<String> result = new LinkedList<String>();
        for (int i = start; i <= end; ++i) {
            result.add(this.getByRule(identity.getRegulation(), identity.getNoLength(), i));
        }
        int updResult = 0;
        updResult = genType == 0 ? ((SysIdentityDao)this.baseMapper).updByAlias(identity) : ((SysIdentityDao)this.baseMapper).updByAliasWithDay(identity);
        if (updResult == 0) {
            throw new BaseException("\u6d41\u6c34\u53f7\u83b7\u53d6\u5931\u8d25");
        }
        return result;
    }

    @Override
    public synchronized String nextId(String alias) {
        SysIdentity identity = ((SysIdentityDao)this.baseMapper).getByAlias(alias);
        Result result = this.genResult(identity);
        int tryTimes = 0;
        while (result.getRtn() == 0) {
            if (++tryTimes > 100) {
                throw new RuntimeException("\u83b7\u53d6\u6d41\u6c34\u53f7\u5931\u8d25\uff01 " + identity.getAlias());
            }
            try {
                TimeUnit.MILLISECONDS.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            identity.setCurValue(result.getCurValue());
            result = this.genResult(identity);
        }
        return result.getIdNo();
    }

    public Result genResult(SysIdentity identity) {
        String rule = identity.getRegulation();
        short step = identity.getStep();
        short genEveryDay = identity.getGenType();
        Integer curValue = identity.getCurValue();
        if (curValue == 0) {
            curValue = identity.getInitValue();
        }
        if (genEveryDay == 0) {
            curValue = curValue + step;
        } else {
            String formatString = this.getFormatString(Integer.valueOf(genEveryDay));
            String curDate = this.getCurDate(formatString);
            String oldDate = identity.getCurDate();
            identity.setOldDate(oldDate);
            if (!curDate.equals(oldDate)) {
                identity.setCurDate(curDate);
                curValue = identity.getInitValue();
            } else {
                curValue = curValue + step;
            }
        }
        identity.setNewCurValue(curValue);
        int i = 0;
        i = genEveryDay == 0 ? ((SysIdentityDao)this.baseMapper).updByAlias(identity) : ((SysIdentityDao)this.baseMapper).updByAliasWithDay(identity);
        Result result = new Result(0, "", curValue);
        if (i > 0) {
            String rtn = this.getByRule(rule, identity.getNoLength(), curValue);
            result.setIdNo(rtn);
            result.setRtn(1);
        }
        return result;
    }

    public String getFormatString(Integer type) {
        String formatString = "yyyyMMdd";
        if (type == 2) {
            formatString = "yyyyMM";
        } else if (type == 3) {
            formatString = "yyyy";
        }
        return formatString;
    }

    public String getCurDate(String formatString) {
        return DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)formatString);
    }

    @Override
    public List<SysIdentity> getPreviewIden(String alias) {
        int genNum = 10;
        SysIdentity identity = ((SysIdentityDao)this.baseMapper).getByAlias(alias);
        String rule = identity.getRegulation();
        short step = identity.getStep();
        Integer curValue = identity.getCurValue();
        if (curValue == null) {
            curValue = identity.getInitValue();
        }
        ArrayList<SysIdentity> tempList = new ArrayList<SysIdentity>();
        for (int i = 0; i < genNum; ++i) {
            SysIdentity identityTemp = new SysIdentity();
            if (i > 0) {
                curValue = curValue + step;
            }
            String rtn = this.getByRule(rule, identity.getNoLength(), curValue);
            identityTemp.setId(curValue.toString());
            identityTemp.setCurIdenValue(rtn);
            tempList.add(identityTemp);
        }
        return tempList;
    }

    @Override
    public String export(String[] idList) throws IOException {
        if (BeanUtils.isEmpty((Object)idList)) {
            return "";
        }
        ArrayList<SysIdentity> list = new ArrayList<SysIdentity>();
        for (String s : idList) {
            SysIdentity sysIdentity = (SysIdentity)this.get((Serializable)((Object)s));
            list.add(sysIdentity);
        }
        if (BeanUtils.isEmpty(list)) {
            return "";
        }
        return JsonUtil.toJson(list);
    }

    @Override
    @Transactional
    public boolean importFile(String unZipFilePath, String typeId) throws Exception {
        try {
            String json = FileUtil.readFile((String)(unZipFilePath + File.separator + "identity.json"));
            List sysIdentities = (List)JsonUtil.toBean((String)json, (TypeReference)new TypeReference<List<SysIdentity>>(){});
            ArrayList byAliases = new ArrayList();
            this.importCheck(sysIdentities, byAliases::add);
            if (byAliases.size() > 0) {
                return false;
            }
            ObjectNode sysTypeNode = this.portalFeignService.getSysTypeById(typeId);
            String typeName = sysTypeNode.get("name").asText("");
            for (SysIdentity sysIdentity : sysIdentities) {
                sysIdentity.setTypeId(typeId);
                sysIdentity.setTypeName(typeName);
                sysIdentity.setCurValue(0);
                sysIdentity.setId(UniqueIdUtil.getSuid());
                ((SysIdentityDao)this.baseMapper).insert((Object)sysIdentity);
            }
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage());
        }
        return true;
    }

    @Override
    public Object saveSysIdentity(SysIdentity identity) {
        String resultMsg = null;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", identity.getId());
        params.put("alias", identity.getAlias());
        boolean rtn = this.identityManager.isAliasExisted(params);
        if (rtn) {
            return new CommonResult(false, "\u6d41\u6c34\u53f7\u522b\u540d\u5df2\u7ecf\u5b58\u5728", null);
        }
        try {
            if (StringUtil.isEmpty((String)identity.getId())) {
                identity.setId(this.idGenerator.getSuid());
                this.identityManager.create((Model)identity);
                resultMsg = "\u6dfb\u52a0\u6d41\u6c34\u53f7\u751f\u6210\u6210\u529f";
            } else {
                this.identityManager.update((Model)identity);
                resultMsg = "\u66f4\u65b0\u6d41\u6c34\u53f7\u751f\u6210\u6210\u529f";
            }
            return new CommonResult(true, resultMsg, null);
        }
        catch (Exception e) {
            return new CommonResult(false, resultMsg, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResult<String> importIdentity(MultipartHttpServletRequest request, HttpServletResponse response, String typeId) {
        MultipartFile file = request.getFile("file");
        String unZipFilePath = "";
        boolean isRepeat = true;
        try {
            String rootRealPath = (FileUtil.getIoTmpdir() + "/attachFiles/unZip/").replace("/", File.separator);
            FileUtil.createFolder((String)rootRealPath, (boolean)true);
            String name = file.getOriginalFilename();
            String fileDir = StringUtil.substringBeforeLast((String)name, (String)".");
            ZipUtil.unZipFile((MultipartFile)file, (String)rootRealPath);
            unZipFilePath = rootRealPath + File.separator + fileDir;
            isRepeat = this.importFile(unZipFilePath, typeId);
            if (!isRepeat) {
                CommonResult commonResult = new CommonResult(true, "confirmUpload", (Object)Base64.getBase64Replace((String)unZipFilePath));
                return commonResult;
            }
            CommonResult commonResult = new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
            return commonResult;
        }
        catch (Exception e) {
            CommonResult commonResult = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
            return commonResult;
        }
        finally {
            File zipFile;
            if (StringUtil.isNotEmpty((String)unZipFilePath) && isRepeat && (zipFile = new File(unZipFilePath)).exists()) {
                zipFile.delete();
            }
        }
    }

    @Override
    public CommonResult<String> importFileData(String unZipFilePath, String status, String typeId) {
        try {
            String json = FileUtil.readFile((String)(Base64.getFromBase64Replace((String)unZipFilePath) + File.separator + "identity.json"));
            List sysIdentities = (List)JsonUtil.toBean((String)json, (TypeReference)new TypeReference<List<SysIdentity>>(){});
            this.importData(sysIdentities, status, typeId);
        }
        catch (Exception e) {
            throw new BaseException("\u4e0a\u4f20\u5931\u8d25");
        }
        finally {
            try {
                File formDir;
                String unZipFilePathStr = Base64.getFromBase64((String)unZipFilePath);
                if (StringUtil.isNotEmpty((String)unZipFilePathStr) && (formDir = new File(unZipFilePathStr)).exists()) {
                    FileUtil.deleteDir((File)formDir);
                }
            }
            catch (UnsupportedEncodingException e) {
                this.log.error("\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u5931\u8d25");
            }
        }
        return new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
    }

    @Override
    public void importCheck(List<SysIdentity> identities, Consumer<SysIdentity> consumer) {
        for (SysIdentity sysIdentity : identities) {
            sysIdentity.setCurValue(0);
            SysIdentity byAlias = ((SysIdentityDao)this.baseMapper).getByAlias(sysIdentity.getAlias());
            if (byAlias == null) continue;
            consumer.accept(byAlias);
        }
    }

    @Override
    public void importData(List<SysIdentity> identities, String status, String typeId) {
        ObjectNode sysTypeNode = this.portalFeignService.getSysTypeById(typeId);
        String typeName = sysTypeNode.get("name").asText("");
        for (SysIdentity sysIdentity : identities) {
            sysIdentity.setTypeId(typeId);
            sysIdentity.setTypeName(typeName);
            sysIdentity.setCurValue(0);
            SysIdentity byAlias = ((SysIdentityDao)this.baseMapper).getByAlias(sysIdentity.getAlias());
            if (BeanUtils.isEmpty((Object)((Object)byAlias))) {
                sysIdentity.setId(UniqueIdUtil.getSuid());
                ((SysIdentityDao)this.baseMapper).insert((Object)sysIdentity);
                continue;
            }
            if (!"cover".equals(status)) continue;
            sysIdentity.setId(byAlias.getId());
            ((SysIdentityDao)this.baseMapper).updateById((Object)sysIdentity);
        }
    }

    public class Result {
        private int rtn = 0;
        private String idNo = "";
        private int curValue = 0;

        public Result(int rtn, String idNo, int curValue) {
            this.rtn = rtn;
            this.idNo = idNo;
            this.setCurValue(curValue);
        }

        public int getRtn() {
            return this.rtn;
        }

        public void setRtn(int rtn) {
            this.rtn = rtn;
        }

        public String getIdNo() {
            return this.idNo;
        }

        public void setIdNo(String idNo) {
            this.idNo = idNo;
        }

        public int getCurValue() {
            return this.curValue;
        }

        public void setCurValue(int curValue) {
            this.curValue = curValue;
        }
    }
}

