/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.sys.persistence.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.BeanUtils;
import com.hotent.sys.persistence.dao.SysMethodDao;
import com.hotent.sys.persistence.dao.SysRoleAuthDao;
import com.hotent.sys.persistence.manager.SysMethodManager;
import com.hotent.sys.persistence.model.SysMethod;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.stereotype.Service;

@Service(value="sysMethodManager")
public class SysMethodManagerImpl
extends BaseManagerImpl<SysMethodDao, SysMethod>
implements SysMethodManager {
    @Resource
    SysRoleAuthDao sysRoleAuthDao;

    @Override
    public boolean isExistByAlias(String alias) {
        return ((SysMethodDao)this.baseMapper).isExistByAlias(alias) > 0;
    }

    @Override
    public List<String> getCurrentUserMethodAuth() {
        ArrayList<String> userMethod = new ArrayList();
        IUser currentUser = ContextUtil.getCurrentUser();
        Collection authorities = currentUser.getAuthorities();
        ArrayList<String> roles = new ArrayList<String>();
        if (BeanUtils.isNotEmpty((Object)authorities)) {
            for (SimpleGrantedAuthority simpleGrantedAuthority : authorities) {
                roles.add(simpleGrantedAuthority.getAuthority());
            }
        }
        if (BeanUtils.isEmpty(roles)) {
            return new ArrayList<String>();
        }
        userMethod = this.sysRoleAuthDao.getMethodByRoleAlias(roles);
        return userMethod;
    }

    @Override
    public List<Map<String, Object>> getAllMethodByRoleAlias(String roleAlias) {
        return ((SysMethodDao)this.baseMapper).getAllMethodByRoleAlias(roleAlias);
    }

    @Override
    public PageList<SysMethod> getRoleMethods(String roleAlias, QueryFilter queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        Page page = new Page(0L, (long)PageBean.WITHOUT_PAGE.intValue());
        if (BeanUtils.isNotEmpty((Object)pageBean)) {
            page = this.convert2IPage(pageBean);
        }
        Class currentModelClass = this.currentModelClass();
        Wrapper convert2Wrapper = this.convert2Wrapper(queryFilter, currentModelClass);
        List<SysMethod> roleMethods = ((SysMethodDao)this.baseMapper).getRoleMethods((IPage<SysMethod>)page, (Wrapper<SysMethod>)convert2Wrapper);
        PageList sysMethodPageList = new PageList(roleMethods);
        sysMethodPageList.setPage(page.getCurrent());
        sysMethodPageList.setPageSize(page.getSize());
        sysMethodPageList.setTotal(page.getTotal());
        return sysMethodPageList;
    }
}

