/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.sys.persistence.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.cache.annotation.CacheEvict;
import com.hotent.base.exception.ServerRejectException;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.sys.persistence.dao.SysRoleAuthDao;
import com.hotent.sys.persistence.manager.SysRoleAuthManager;
import com.hotent.sys.persistence.model.SysRoleAuth;
import com.hotent.sys.persistence.param.SysRoleAuthParam;
import com.hotent.sys.vo.AuthMethodSave;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.stereotype.Service;

@Service(value="sysRoleAuthManager")
public class SysRoleAuthManagerImpl
extends BaseManagerImpl<SysRoleAuthDao, SysRoleAuth>
implements SysRoleAuthManager {
    @Value(value="${system.mode.demo:false}")
    protected boolean demoMode;
    @Resource
    SysRoleAuthDao sysRoleAuthDao;

    @Override
    public void removeMethodRoleAuth() {
        SysRoleAuthManagerImpl bean = (SysRoleAuthManagerImpl)AppUtil.getBean(this.getClass());
        bean.delMethodRoleAuth();
    }

    @CacheEvict(value={"eip:sys:methodAuth"}, allEntries=true)
    protected void delMethodRoleAuth() {
    }

    @Override
    public void removeUserMenu() {
        SysRoleAuthManagerImpl bean = (SysRoleAuthManagerImpl)AppUtil.getBean(this.getClass());
        bean.delUserMenu();
    }

    @CacheEvict(value={"eip:sys:userMenu"}, allEntries=true)
    protected void delUserMenu() {
    }

    private void removeDataPermission() {
        SysRoleAuthManagerImpl bean = (SysRoleAuthManagerImpl)AppUtil.getBean(this.getClass());
        bean.delDataPermission();
    }

    @CacheEvict(value={"eip:sys:dataPermission"}, allEntries=true)
    protected void delDataPermission() {
    }

    @Override
    public List<SysRoleAuth> getSysRoleAuthByRoleAlias(String roleAlias) {
        return ((SysRoleAuthDao)this.baseMapper).getSysRoleAuthByRoleAlias(roleAlias);
    }

    @Override
    public List<String> getMenuAliasByRoleAlias(String roleAlias) {
        return ((SysRoleAuthDao)this.baseMapper).getMenuAliasByRoleAlias(roleAlias);
    }

    @Override
    public List<String> getMethodAliasByRoleAlias(String roleAlias) {
        return ((SysRoleAuthDao)this.baseMapper).getMethodAliasByRoleAlias(roleAlias);
    }

    @Override
    public void removeByRoleAlias(String roleAlias) {
        ((SysRoleAuthDao)this.baseMapper).removeByRoleAlias(roleAlias);
    }

    @Override
    public void removeByArrRoleAlias(String[] aryroleAlias) {
        for (String roleAlias : aryroleAlias) {
            ((SysRoleAuthDao)this.baseMapper).removeByRoleAlias(roleAlias);
        }
        this.removeMethodRoleAuth();
        this.removeUserMenu();
        this.removeDataPermission();
    }

    @Override
    public void create(SysRoleAuthParam sysRoleAuthParam) {
        SysRoleAuth sysRoleAuth;
        if (this.demoMode) {
            throw new ServerRejectException("\u6f14\u793a\u6a21\u5f0f\u4e0b\u65e0\u6cd5\u6267\u884c\u8be5\u64cd\u4f5c");
        }
        ((SysRoleAuthDao)this.baseMapper).removeMenuAuthByRoleAlias(sysRoleAuthParam.getRoleAlias());
        List<Map<String, String>> arrMenuAlias = sysRoleAuthParam.getArrMenuAlias();
        ArrayList<SysRoleAuth> sysRoleAuthList = new ArrayList<SysRoleAuth>();
        for (Map<String, String> menuAliasMap : arrMenuAlias) {
            for (String menuAlias : menuAliasMap.keySet()) {
                sysRoleAuth = new SysRoleAuth();
                sysRoleAuth.setRoleAlias(sysRoleAuthParam.getRoleAlias());
                sysRoleAuth.setId(UniqueIdUtil.getSuid());
                sysRoleAuth.setMenuAlias(menuAlias);
                Integer isOpen = null;
                try {
                    String isOpenStr = menuAliasMap.getOrDefault(menuAlias, null);
                    if (isOpenStr != null) {
                        isOpen = Integer.valueOf(isOpenStr);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                sysRoleAuth.setIsOpen(isOpen);
                sysRoleAuthList.add(sysRoleAuth);
            }
        }
        super.saveBatch(sysRoleAuthList);
        sysRoleAuthList.clear();
        List<String> arrMethodAlias = sysRoleAuthParam.getArrMethodAlias();
        Map<String, String> dataPermission = sysRoleAuthParam.getDataPermission();
        for (String methodAlias : arrMethodAlias) {
            sysRoleAuth = new SysRoleAuth();
            sysRoleAuth.setRoleAlias(sysRoleAuthParam.getRoleAlias());
            sysRoleAuth.setId(UniqueIdUtil.getSuid());
            sysRoleAuth.setMethodAlias(methodAlias);
            sysRoleAuth.setDataPermission(dataPermission.get(methodAlias));
            sysRoleAuthList.add(sysRoleAuth);
        }
        super.saveBatch(sysRoleAuthList);
        this.removeMethodRoleAuth();
        this.removeUserMenu();
        this.removeDataPermission();
    }

    @Override
    public List<HashMap<String, String>> getSysRoleAuthAll() {
        return ((SysRoleAuthDao)this.baseMapper).getSysRoleAuthAll();
    }

    @Override
    public void createCopy(String oldCode, String[] newCodes) {
        for (int i = 0; i < newCodes.length; ++i) {
            ((SysRoleAuthDao)this.baseMapper).removeByRoleAlias(newCodes[i]);
        }
        List<String> strList = this.getMenuAliasByRoleAlias(oldCode);
        for (int i = 0; i < newCodes.length; ++i) {
            for (String menuAlias : strList) {
                SysRoleAuth sysRoleAuth = new SysRoleAuth();
                sysRoleAuth.setId(UniqueIdUtil.getSuid());
                sysRoleAuth.setRoleAlias(newCodes[i]);
                sysRoleAuth.setMenuAlias(menuAlias);
                ((SysRoleAuthDao)this.baseMapper).insert((Object)sysRoleAuth);
            }
        }
        this.removeMethodRoleAuth();
        this.removeUserMenu();
    }

    @Override
    public void saveRoleMethods(SysRoleAuthParam sysRoleAuthParam) {
        if (this.demoMode) {
            throw new ServerRejectException("\u6f14\u793a\u6a21\u5f0f\u4e0b\u65e0\u6cd5\u6267\u884c\u8be5\u64cd\u4f5c");
        }
        SysRoleAuth sysRoleAuth = new SysRoleAuth();
        sysRoleAuth.setRoleAlias(sysRoleAuthParam.getRoleAlias());
        List<String> methodAliasByRoleAlias = this.getMethodAliasByRoleAlias(sysRoleAuth.getRoleAlias());
        List<String> arrMethodAlias = sysRoleAuthParam.getArrMethodAlias();
        Map<String, String> dataPermission = sysRoleAuthParam.getDataPermission();
        for (String methodAlias : arrMethodAlias) {
            sysRoleAuth.setId(UniqueIdUtil.getSuid());
            sysRoleAuth.setMethodAlias(methodAlias);
            sysRoleAuth.setDataPermission(dataPermission.get(methodAlias));
            if (methodAliasByRoleAlias.contains(methodAlias)) continue;
            this.create((Model)sysRoleAuth);
        }
        this.removeMethodRoleAuth();
        this.removeDataPermission();
    }

    @Override
    public void removeRoleMethods(String roleAlias, String[] methodAliasArr) {
        ((SysRoleAuthDao)this.baseMapper).removeRoleMethods(roleAlias, methodAliasArr);
        this.removeMethodRoleAuth();
        this.removeDataPermission();
    }

    @Override
    public List<SysRoleAuth> getSysRoleAuthByMenuAlias(String MenuAlias) {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("menuAlias", (Object)MenuAlias, QueryOP.EQUAL);
        return this.queryNoPage(queryFilter);
    }

    @Override
    public List<SysRoleAuth> getMethodsByRoleAlias(String roleAlias) {
        LambdaQueryWrapper query = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)query.eq(SysRoleAuth::getRoleAlias, (Object)roleAlias)).isNotNull(SysRoleAuth::getMethodAlias);
        return this.list((Wrapper)query);
    }

    @Override
    public List<SysRoleAuth> getMethodsByRoleAndMenu(String roleAlias, String menuAlias) {
        return ((SysRoleAuthDao)this.baseMapper).getMethodsByRoleAndMenu(roleAlias, menuAlias);
    }

    @Override
    public void saveRoleMenuMethods(AuthMethodSave authMethodSave) {
        if (this.demoMode) {
            throw new ServerRejectException("\u6f14\u793a\u6a21\u5f0f\u4e0b\u65e0\u6cd5\u6267\u884c\u8be5\u64cd\u4f5c");
        }
        List<SysRoleAuth> methodsByRoleAndMenu = this.getMethodsByRoleAndMenu(authMethodSave.getRoleAlias(), authMethodSave.getMenuAlias());
        if (BeanUtils.isNotEmpty(methodsByRoleAndMenu)) {
            ((SysRoleAuthDao)this.baseMapper).deleteBatchIds(methodsByRoleAndMenu.stream().map(SysRoleAuth::getId).collect(Collectors.toList()));
        }
        List<AuthMethodSave.Method> methodList = authMethodSave.getMethodList();
        ArrayList saveList = new ArrayList();
        methodList.forEach(e -> {
            SysRoleAuth sysRoleAuth = new SysRoleAuth();
            sysRoleAuth.setRoleAlias(authMethodSave.getRoleAlias());
            sysRoleAuth.setDataPermission(e.getDataPermission());
            sysRoleAuth.setMethodAlias(e.getAlias());
            saveList.add(sysRoleAuth);
        });
        if (BeanUtils.isNotEmpty(saveList)) {
            this.saveBatch(saveList);
        }
        this.removeMethodRoleAuth();
        this.removeDataPermission();
    }

    @Override
    public void removeByMethodsAlias(List<String> rmMethodsAlias) {
        LambdaQueryWrapper query = Wrappers.lambdaQuery();
        query.in(SysRoleAuth::getMethodAlias, rmMethodsAlias);
        this.remove((Wrapper)query);
        this.removeMethodRoleAuth();
        this.removeDataPermission();
    }

    @Override
    public List<String> getCurrentUserMethodAuth() {
        ArrayList<String> userMethod = new ArrayList();
        IUser currentUser = ContextUtil.getCurrentUser();
        Collection authorities = currentUser.getAuthorities();
        ArrayList<String> roles = new ArrayList<String>();
        if (BeanUtils.isNotEmpty((Object)authorities)) {
            for (SimpleGrantedAuthority simpleGrantedAuthority : authorities) {
                roles.add(simpleGrantedAuthority.getAuthority());
            }
        }
        if (BeanUtils.isEmpty(roles)) {
            return new ArrayList<String>();
        }
        userMethod = this.sysRoleAuthDao.getMethodByRoleAlias(roles);
        return userMethod;
    }

    @Override
    public List<HashMap<String, String>> getMethodDataFitlers() {
        return this.sysRoleAuthDao.getMethodDataFitlers();
    }
}

