/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.sys.persistence.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.core.type.TypeReference;
import com.hotent.base.exception.BaseException;
import com.hotent.base.id.IdGenerator;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.Base64;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.PinyinUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.ZipUtil;
import com.hotent.base.util.time.DateUtil;
import com.hotent.sys.persistence.dao.SysTagDao;
import com.hotent.sys.persistence.manager.SysMenuManager;
import com.hotent.sys.persistence.manager.SysTagManager;
import com.hotent.sys.persistence.manager.SysTypeManager;
import com.hotent.sys.persistence.model.SysMenu;
import com.hotent.sys.persistence.model.SysTag;
import com.hotent.sys.persistence.model.SysType;
import java.io.File;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="sysTagManager")
public class SysTagManagerImpl
extends BaseManagerImpl<SysTagDao, SysTag>
implements SysTagManager {
    @Resource
    SysTypeManager sysTypeManager;
    @Resource
    SysMenuManager sysMenuManager;
    @Resource
    IdGenerator idGenerator;

    @Override
    @Transactional
    public void removeByTypeId(String typeId) {
        if (StringUtil.isNotEmpty((String)typeId)) {
            List<SysType> sysTypes = this.sysTypeManager.getChildByTypeId(typeId);
            List<String> ids = sysTypes.stream().map(item -> item.getId()).collect(Collectors.toList());
            ids.add(typeId);
            this.sysTypeManager.removeByIds(ids);
            ids.forEach(id -> {
                QueryWrapper wrapper = new QueryWrapper();
                wrapper.eq((Object)"type_id_", id);
                ((SysTagDao)this.baseMapper).delete((Wrapper)wrapper);
            });
        }
    }

    @Override
    public List<SysTag> getTagsByTypeId(String typeId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"type_id_", (Object)typeId);
        return ((SysTagDao)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    public Integer countByName(String key, String typeId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"name_", (Object)key)).eq((Object)"type_id_", (Object)typeId);
        return ((SysTagDao)this.baseMapper).selectCount((Wrapper)queryWrapper);
    }

    @Override
    public Integer countByKey(String sysTagKey, String typeId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"key_", (Object)sysTagKey)).eq((Object)"type_id_", (Object)typeId);
        return ((SysTagDao)this.baseMapper).selectCount((Wrapper)queryWrapper);
    }

    @Override
    public void createWithCheck(SysTag sysTag) throws Exception {
        String typeId = "";
        SysType sysType = this.sysTypeManager.getByTypeKeyAndGroupKey("TAG", sysTag.getTypeKey());
        if (BeanUtils.isEmpty((Object)((Object)sysType))) {
            SysMenu menu = (SysMenu)((Object)this.sysMenuManager.getById((Serializable)((Object)sysTag.getTypeId())));
            if (BeanUtils.isEmpty((Object)((Object)menu))) {
                throw new RuntimeException("[" + sysTag.getTypeKey() + "]\u4e0d\u5b58\u5728");
            }
            typeId = menu.getId();
        } else {
            typeId = sysType.getId();
        }
        if (this.countByName(sysTag.getName(), typeId) > 0) {
            throw new RuntimeException("[" + sysTag.getName() + "]\u5df2\u5b58\u5728");
        }
        if (this.countByKey(sysTag.getKey(), typeId) > 0) {
            throw new RuntimeException("\u6807\u7b7ekey\uff1a[" + sysTag.getKey() + "]\u5df2\u5b58\u5728");
        }
        sysTag.setTypeId(typeId);
        if (StringUtil.isEmpty((String)sysTag.getKey())) {
            sysTag.setKey(PinyinUtil.getPinYinHeadChar((String)sysTag.getName()) + DateUtil.getCurrentTimeInMillis());
        }
        this.create((Model)sysTag);
    }

    @Override
    @Transactional
    public boolean importFile(String unZipFilePath, String typeId) {
        List<SysTag> primitive = this.getTagsByTypeId(typeId);
        try {
            String json = FileUtil.readFile((String)(unZipFilePath + File.separator + "sysTags.json"));
            List list = (List)JsonUtil.toBean((String)json, (TypeReference)new TypeReference<List<SysTag>>(){});
            Assert.isTrue((boolean)BeanUtils.isNotEmpty((Object)list), (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            ArrayList<SysTag> newTags = new ArrayList<SysTag>();
            for (Object o : list) {
                SysTag sysTag = (SysTag)((Object)JsonUtil.toBean((String)JsonUtil.toJson(o), SysTag.class));
                sysTag.setTypeId(typeId);
                sysTag.setId(this.idGenerator.getSuid());
                sysTag.setTenantId(null);
                newTags.add(sysTag);
            }
            if (BeanUtils.isNotEmpty(primitive)) {
                for (SysTag newTag : newTags) {
                    if (!this.isSysTagExists(newTag, primitive)) continue;
                    return false;
                }
            }
            for (SysTag newTag : newTags) {
                this.create((Model)newTag);
            }
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResult<String> importSysTag(String typeId, MultipartHttpServletRequest request) {
        MultipartFile file = request.getFile("file");
        String unZipFilePath = "";
        boolean isRepeat = true;
        try {
            String rootRealPath = (FileUtil.getIoTmpdir() + "/attachFiles/unZip/").replace("/", File.separator);
            unZipFilePath = ZipUtil.unZipFile((MultipartFile)file, (String)rootRealPath);
            isRepeat = this.importFile(unZipFilePath, typeId);
            if (!isRepeat) {
                CommonResult commonResult = new CommonResult(true, "confirmUpload", (Object)Base64.getBase64Replace((String)unZipFilePath));
                return commonResult;
            }
            CommonResult commonResult = new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
            return commonResult;
        }
        catch (Exception e) {
            CommonResult commonResult = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
            return commonResult;
        }
        finally {
            File zipFile;
            if (StringUtil.isNotEmpty((String)unZipFilePath) && isRepeat && (zipFile = new File(unZipFilePath)).exists()) {
                zipFile.delete();
            }
        }
    }

    @Override
    public CommonResult<String> importFileData(String unZipFilePath, String status, String typeId) {
        List<SysTag> primitive = this.getTagsByTypeId(typeId);
        try {
            String json = FileUtil.readFile((String)(Base64.getFromBase64Replace((String)unZipFilePath) + File.separator + "sysTags.json"));
            List list = (List)JsonUtil.toBean((String)json, List.class);
            Assert.isTrue((boolean)BeanUtils.isNotEmpty((Object)list), (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            ArrayList<SysTag> newTags = new ArrayList<SysTag>();
            for (Object o : list) {
                SysTag sysTag = (SysTag)((Object)JsonUtil.toBean((String)JsonUtil.toJson(o), SysTag.class));
                sysTag.setTypeId(typeId);
                sysTag.setId(this.idGenerator.getSuid());
                sysTag.setTenantId(null);
                newTags.add(sysTag);
            }
            if (BeanUtils.isEmpty(primitive)) {
                for (SysTag newTag : newTags) {
                    this.create((Model)newTag);
                }
            } else {
                for (SysTag newTag : newTags) {
                    String id = this.isSysTagExistsStr(newTag, primitive);
                    if (StringUtil.isNotEmpty((String)id)) {
                        if ("jump".equals(status) || !"cover".equals(status)) continue;
                        newTag.setId(id);
                        this.update((Model)newTag);
                        continue;
                    }
                    this.create((Model)newTag);
                }
            }
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage());
        }
        finally {
            try {
                File formDir;
                String unZipFilePathStr = Base64.getFromBase64((String)unZipFilePath);
                if (StringUtil.isNotEmpty((String)unZipFilePathStr) && (formDir = new File(unZipFilePathStr)).exists()) {
                    FileUtil.deleteDir((File)formDir);
                }
            }
            catch (UnsupportedEncodingException e) {
                this.log.error("\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u5931\u8d25");
            }
        }
        return new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
    }

    @Override
    public List<SysTag> getByAppId(String appId) {
        return ((SysTagDao)this.baseMapper).getSysTagsByAppId(appId);
    }

    @Override
    public List<SysType> getTagsByTypeAlias(List<String> typeAlias) {
        if (BeanUtils.isEmpty(typeAlias)) {
            return new ArrayList<SysType>();
        }
        LambdaQueryWrapper typeWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().in(SysType::getTypeKey, typeAlias);
        List sysTypes = this.sysTypeManager.list((Wrapper)typeWrapper);
        return sysTypes.stream().peek(sysType -> {
            List<SysTag> tags = this.getTagsByTypeId(sysType.getId());
            sysType.setTags(tags);
        }).collect(Collectors.toList());
    }

    @Override
    public void importCheck(List<SysType> types, Consumer<SysType> existConsumer) {
        for (SysType sysType : types) {
            SysType exist = this.sysTypeManager.getByTypeKeyAndGroupKey(sysType.getTypeGroupKey(), sysType.getTypeKey());
            if (exist == null) continue;
            existConsumer.accept(exist);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void importData(List<SysType> types, String status) {
        ArrayList<SysType> saveTypes = new ArrayList<SysType>();
        ArrayList saveTags = new ArrayList();
        for (SysType sysType : types) {
            SysType exist = this.sysTypeManager.getByTypeKeyAndGroupKey(sysType.getTypeGroupKey(), sysType.getTypeKey());
            if (exist == null) {
                sysType.setId(UniqueIdUtil.getSuid());
                saveTypes.add(sysType);
            }
            if (exist != null && "cover".equals(status)) {
                sysType.setId(exist.getId());
                saveTypes.add(sysType);
                LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysTag::getTypeId, (Object)exist.getId());
                this.remove((Wrapper)wrapper);
            }
            if (exist != null && !"cover".equals(status)) continue;
            List sysTags = sysType.getTags().stream().peek(tag -> {
                tag.setId(UniqueIdUtil.getSuid());
                tag.setTypeId(sysType.getId());
                tag.setTenantId(null);
            }).collect(Collectors.toList());
            saveTags.addAll(sysTags);
        }
        this.sysTypeManager.saveOrUpdateBatch(saveTypes);
        this.saveBatch(saveTags);
    }

    @Override
    public List<SysType> getTypeTags(String typeKey) {
        SysType sysType = this.sysTypeManager.getByTypeKeyAndGroupKey("TAG", typeKey);
        if (BeanUtils.isEmpty((Object)((Object)sysType))) {
            return new ArrayList<SysType>();
        }
        List<SysType> sysTypes = this.sysTypeManager.getByParentId(sysType.getId());
        List<String> typeKeys = sysTypes.stream().map(SysType::getTypeKey).collect(Collectors.toList());
        if (BeanUtils.isEmpty(typeKeys)) {
            new ArrayList();
        }
        return this.getTagsByTypeAlias(typeKeys);
    }

    private boolean isSysTagExists(SysTag sysTag, List<SysTag> list) {
        for (SysTag tag : list) {
            if (!sysTag.getName().equals(tag.getName())) continue;
            return true;
        }
        return false;
    }

    private String isSysTagExistsStr(SysTag sysTag, List<SysTag> list) {
        for (SysTag tag : list) {
            if (!sysTag.getName().equals(tag.getName())) continue;
            return tag.getId();
        }
        return null;
    }
}

