/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.sys.persistence.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.context.BaseContext;
import com.hotent.base.exception.MessagePassingException;
import com.hotent.base.exception.NotFoundException;
import com.hotent.base.exception.RequiredException;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.jms.JmsProducer;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.jms.model.JmsSysTypeChangeMessage;
import com.hotent.sys.constants.CategoryConstants;
import com.hotent.sys.persistence.dao.SysTypeDao;
import com.hotent.sys.persistence.manager.DataDictManager;
import com.hotent.sys.persistence.manager.SysAuthUserManager;
import com.hotent.sys.persistence.manager.SysCategoryManager;
import com.hotent.sys.persistence.manager.SysTypeManager;
import com.hotent.sys.persistence.model.DataDict;
import com.hotent.sys.persistence.model.SysCategory;
import com.hotent.sys.persistence.model.SysType;
import com.hotent.sys.vo.SysTypeTreeVO;
import com.hotent.uc.api.impl.util.ContextUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="sysTypeManager")
public class SysTypeManagerImpl
extends BaseManagerImpl<SysTypeDao, SysType>
implements SysTypeManager {
    @Resource
    DataDictManager dataDictManager;
    @Resource
    SysCategoryManager sysCategoryManager;
    @Resource
    JmsProducer jmsProducer;
    @Resource
    SysAuthUserManager sysAuthUserManager;
    @Resource
    BaseContext baseContext;
    @Resource
    UCFeignService ucFeignService;

    @Override
    public List<SysType> getByParentId(String parentId) {
        return ((SysTypeDao)this.baseMapper).getByParentId(parentId);
    }

    @Override
    public SysType getInitSysType(int isRoot, String parentId) {
        SysType sysType = new SysType();
        String typeId = UniqueIdUtil.getSuid();
        if (isRoot == 1) {
            SysCategory sysCategory = (SysCategory)this.sysCategoryManager.get((Serializable)((Object)parentId));
            sysType.setTypeKey(sysCategory.getGroupKey());
            sysType.setTypeGroupKey(sysCategory.getGroupKey());
            sysType.setParentId(parentId);
            sysType.setStruType(sysCategory.getType());
            sysType.setPath(parentId + "." + typeId + ".");
            sysType.setName(sysCategory.getName());
        } else {
            sysType = (SysType)this.get((Serializable)((Object)parentId));
            String path = sysType.getPath();
            sysType.setPath(path + typeId + ".");
        }
        sysType.setId(typeId);
        return sysType;
    }

    @Override
    public boolean isKeyExist(String id, String typeGroupKey, String typeKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("typeKey", typeKey);
        params.put("typeGroupKey", typeGroupKey);
        params.put("id", id);
        return ((SysTypeDao)this.baseMapper).isKeyExist(params) > 0;
    }

    @Override
    public List<SysType> getByGroupKey(String groupKey) {
        return ((SysTypeDao)this.baseMapper).getByGroupKey(groupKey);
    }

    @Override
    public void delByIds(String id) {
        ArrayNode matrixInTypeIds;
        ArrayList<String> delIds = new ArrayList<String>();
        if (BeanUtils.isEmpty((Object)id)) {
            return;
        }
        SysType sysType = (SysType)this.get((Serializable)((Object)id));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("path", sysType.getPath());
        List<SysType> sysTypes = ((SysTypeDao)this.baseMapper).getByPath(params);
        sysTypes.add(sysType);
        if ("jzfl".equals(sysType.getTypeGroupKey()) && (matrixInTypeIds = this.ucFeignService.getMatrixInTypeIds(sysTypes.stream().map(SysType::getId).collect(Collectors.toList()))) != null && matrixInTypeIds.size() > 0) {
            throw new MessagePassingException("\u8be5\u5206\u7c7b\u6709\u77e9\u9635\u65e0\u6cd5\u5220\u9664");
        }
        for (SysType sType : sysTypes) {
            String Id = sType.getId();
            this.remove((Serializable)((Object)Id));
            delIds.add(Id);
        }
        String currentTenantId = this.baseContext.getCurrentTenantId();
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addQueryField(new QueryField("TYPE_GROUP_KEY_", (Object)sysType.getTypeGroupKey()));
        queryFilter.addQueryField(new QueryField("TYPE_KEY_", (Object)"default"));
        List defaultSysTypeList = this.queryNoPage(queryFilter);
        if (CollectionUtils.isNotEmpty((Collection)defaultSysTypeList)) {
            SysType defaultSysType = (SysType)((Object)defaultSysTypeList.get(0));
            for (String delId : delIds) {
                this.jmsProducer.sendToTopic((Object)new JmsSysTypeChangeMessage(defaultSysType.getTypeGroupKey(), defaultSysType.getId(), defaultSysType.getName(), delId, Integer.valueOf(3), null, currentTenantId), "sysTypeChangeTopic");
            }
        }
    }

    private void chageTypeNodes(String newTypeId, List<ObjectNode> nodes, String oldTypeId) {
        String entityIds = "";
        if (CollectionUtils.isNotEmpty(nodes)) {
            for (int i = 0; i < nodes.size(); ++i) {
                entityIds = entityIds + nodes.get(i).get("id").asText();
                if (i >= nodes.size() - 1) continue;
                entityIds = entityIds + ",";
            }
            this.updateEntitySysType(newTypeId, entityIds, oldTypeId);
        }
    }

    @Override
    public List<SysType> getPrivByPartId(String parentId, String userId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("parentId", parentId);
        params.put("userId", userId);
        return ((SysTypeDao)this.baseMapper).getPrivByPartId(params);
    }

    @Override
    public void updSn(String typeId, int sn) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("typeId", typeId);
        params.put("sn", sn);
        ((SysTypeDao)this.baseMapper).updSn(params);
    }

    @Override
    public List<SysType> getChildByTypeKey(String typeKey) {
        SysType sysType = ((SysTypeDao)this.baseMapper).getByTypeKey(typeKey);
        if (sysType == null) {
            return Collections.emptyList();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("path", sysType.getPath());
        return ((SysTypeDao)this.baseMapper).getByPath(params);
    }

    @Override
    public SysType getByKey(String typeKey) {
        return ((SysTypeDao)this.baseMapper).getByTypeKey(typeKey);
    }

    @Override
    public String getXmlByKey(String groupKey) {
        List<SysType> sysTypes = this.getByGroupKey(groupKey);
        StringBuffer sb = new StringBuffer("<folder id='0' label='\u5168\u90e8'>");
        sb.append("</folder>");
        return sb.toString();
    }

    private void contructXml(List<SysType> sysTypes, String parentId, StringBuffer sb) {
        if (BeanUtils.isEmpty(sysTypes)) {
            return;
        }
        for (SysType type : sysTypes) {
            if (!parentId.equals(type.getParentId())) continue;
            sb.append("<folder id='" + type.getId() + "' label='" + type.getName() + "'>");
            this.contructXml(sysTypes, type.getId(), sb);
            sb.append("</folder>");
        }
    }

    @Override
    public SysType getByTypeKeyAndGroupKey(String groupKey, String typeKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("groupKey", groupKey);
        params.put("typeKey", typeKey);
        return ((SysTypeDao)this.baseMapper).getByTypeKeyAndGroupKey(params);
    }

    @Override
    @Transactional
    public List<SysType> getChildByTypeId(String typeId) {
        SysType sysType = (SysType)((Object)((SysTypeDao)this.baseMapper).selectById((Serializable)((Object)typeId)));
        if (sysType == null) {
            return Collections.emptyList();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("path", sysType.getPath());
        return ((SysTypeDao)this.baseMapper).getByPath(params);
    }

    @Override
    public Map<String, Object> editJson(String id, int isRoot, String parentId, int isPriNode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String parentName = "";
        SysType sysType = null;
        boolean isAdd = false;
        boolean isDict = false;
        if (StringUtil.isNotEmpty((String)id)) {
            sysType = (SysType)this.get((Serializable)((Object)id));
            parentId = sysType.getParentId();
            isDict = CategoryConstants.CAT_DIC.key().equals(sysType.getTypeGroupKey());
            if (!"0".equals(sysType.getOwnerId())) {
                isPriNode = 1;
            }
        } else {
            SysType sysTypeTemp = this.getInitSysType(isRoot, parentId);
            parentName = sysTypeTemp.getName();
            sysType = new SysType();
            sysType.setStruType(sysTypeTemp.getStruType());
            sysType.setTypeGroupKey(sysTypeTemp.getTypeGroupKey());
            isDict = CategoryConstants.CAT_DIC.key().equals(sysTypeTemp.getTypeGroupKey());
            isAdd = true;
        }
        map.put("sysType", (Object)sysType);
        map.put("isAdd", isAdd);
        map.put("isRoot", isRoot);
        map.put("isDict", isDict);
        map.put("parentId", parentId);
        map.put("parentName", parentName);
        map.put("isPriNode", isPriNode);
        map.put("isPriNode", isPriNode);
        return map;
    }

    @Override
    public CommonResult<String> save(SysType sysType, String parentId, int isRoot, int isPriNode, Integer isDefaultAuth) {
        boolean isKeyExist;
        String resultMsg = null;
        String id = sysType.getId();
        String typeKey = sysType.getTypeKey();
        String typeGroupKey = sysType.getTypeGroupKey();
        String curUserId = ContextUtil.getCurrentUserId();
        if (StringUtil.isEmpty((String)id)) {
            id = null;
        }
        if (isKeyExist = this.isKeyExist(id, typeGroupKey, typeKey)) {
            resultMsg = "\u8f93\u5165\u7684\u5206\u7c7bkey\u3010" + typeKey + "\u3011\u5df2\u5b58\u5728!";
            return new CommonResult(false, resultMsg);
        }
        try {
            if (StringUtil.isEmpty((String)id)) {
                SysType parentSysType;
                if (isRoot != 1 && BeanUtils.isNotEmpty((Object)((Object)(parentSysType = (SysType)this.get((Serializable)((Object)parentId)))))) {
                    parentSysType.setIsLeaf('N');
                    this.update((Model)parentSysType);
                }
                SysType sysTypeTemp = this.getInitSysType(isRoot, parentId);
                if (!typeGroupKey.equals(CategoryConstants.CAT_DIC.key())) {
                    sysType.setStruType(sysTypeTemp.getStruType());
                }
                if (isPriNode == 1) {
                    sysType.setOwnerId(curUserId);
                } else {
                    sysType.setOwnerId("0");
                }
                this.sysAuthUserManager.createDefault(sysTypeTemp.getId());
                sysType.setTypeGroupKey(typeGroupKey);
                sysType.setTypeKey(typeKey);
                sysType.setPath(sysTypeTemp.getPath());
                sysType.setParentId(parentId);
                sysType.setId(sysTypeTemp.getId());
                sysType.setDepth(1);
                sysType.setSn(0);
                sysType.setIsLeaf('Y');
                this.create((Model)sysType);
                resultMsg = "\u6dfb\u52a0\u5206\u7c7b\u6210\u529f";
                return new CommonResult(true, resultMsg);
            }
            SysType oldType = (SysType)this.get((Serializable)((Object)sysType.getId()));
            sysType.setSn(0);
            if (StringUtil.isEmpty((String)sysType.getTypeGroupKey())) {
                sysType.setTypeGroupKey(oldType.getTypeGroupKey());
            }
            if (sysType.getStruType() == null) {
                sysType.setStruType(oldType.getStruType());
            }
            this.update((Model)sysType);
            String currentTenantId = this.baseContext.getCurrentTenantId();
            this.jmsProducer.sendToTopic((Object)new JmsSysTypeChangeMessage(typeGroupKey, sysType.getId(), sysType.getName(), oldType.getId(), Integer.valueOf(1), null, currentTenantId), "sysTypeChangeTopic");
            resultMsg = "\u66f4\u65b0\u5206\u7c7b\u6210\u529f";
            return new CommonResult(true, resultMsg);
        }
        catch (Exception e) {
            return new CommonResult(false, "\u66f4\u65b0\u5931\u8d25");
        }
    }

    @Override
    public List<SysType> getDataByParentId(String catId) {
        SysCategory sysCategory = (SysCategory)this.sysCategoryManager.get((Serializable)((Object)catId.toString()));
        if (BeanUtils.isEmpty((Object)((Object)sysCategory))) {
            return new ArrayList<SysType>();
        }
        SysType sysType = new SysType();
        sysType.setId(sysCategory.getId());
        sysType.setName(sysCategory.getName());
        sysType.setParentId("0");
        sysType.setOpen("true");
        sysType.setPath(sysCategory.getId() + ".");
        sysType.setTypeKey(sysCategory.getGroupKey());
        List<SysType> list = this.getByGroupKey(sysCategory.getGroupKey());
        Set parentIds = list.stream().map(SysType::getParentId).collect(Collectors.toSet());
        list.stream().forEach(item -> {
            item.setOpen("true");
            item.setIsParent("false");
            if (parentIds.contains(item.getId())) {
                item.setIsParent("true");
            }
        });
        list.add(0, sysType);
        return list;
    }

    @Override
    public CommonResult<String> sort(String[] typeIds) {
        try {
            if (BeanUtils.isNotEmpty((Object)typeIds)) {
                for (int i = 0; i < typeIds.length; ++i) {
                    String typeId = typeIds[i];
                    int sn = i + 1;
                    this.updSn(typeId, sn);
                }
            }
        }
        catch (Exception e) {
            return new CommonResult(false, "\u6392\u5e8f\u5931\u8d25");
        }
        return new CommonResult(true, "\u6392\u5e8f\u5b8c\u6210");
    }

    @Override
    public List<SysType> getTypesByKey(String typeKey) {
        SysCategory sysCategory = this.sysCategoryManager.getByTypeKey(typeKey);
        ArrayList<SysType> listSysType = new ArrayList<SysType>();
        if (BeanUtils.isEmpty((Object)((Object)sysCategory))) {
            return listSysType;
        }
        SysType sysType = new SysType();
        sysType.setId(sysCategory.getId());
        sysType.setName(sysCategory.getName());
        sysType.setParentId("0");
        sysType.setOpen("true");
        sysType.setTypeKey(sysCategory.getGroupKey());
        List<SysType> list = this.getByGroupKey(sysCategory.getGroupKey());
        listSysType.addAll(list);
        listSysType.add(sysType);
        List rtnList = BeanUtils.listToTree(listSysType);
        return rtnList;
    }

    @Override
    public CommonResult<String> updateEntitySysType(String typeID, String entityIds) {
        return this.updateEntitySysType(typeID, entityIds, null);
    }

    @Override
    public CommonResult<String> updateEntitySysType(String typeID, String entityIds, String oldTypeId) {
        SysType type = (SysType)this.get((Serializable)((Object)typeID));
        if (StringUtil.isEmpty((String)entityIds)) {
            throw new RequiredException("\u8bf7\u4f20\u5165\u8981\u66f4\u65b0\u7684\u5b9e\u4f53id");
        }
        if (BeanUtils.isEmpty((Object)((Object)type))) {
            throw new NotFoundException("\u6839\u636e\u6240\u4f20\u5206\u7c7bID\u672a\u627e\u5230\u5206\u7c7b");
        }
        String currentTenantId = this.baseContext.getCurrentTenantId();
        this.jmsProducer.sendToTopic((Object)new JmsSysTypeChangeMessage(type.getTypeGroupKey(), type.getId(), type.getName(), oldTypeId, Integer.valueOf(3), entityIds, currentTenantId), "sysTypeChangeTopic");
        return new CommonResult("\u66f4\u65b0\u5206\u7c7b\u6210\u529f");
    }

    @Override
    public List<SysType> getTypeAndDicByKey(String typeKey) {
        SysCategory sysCategory = this.sysCategoryManager.getByTypeKey(typeKey);
        ArrayList<SysType> listSysType = new ArrayList<SysType>();
        if (BeanUtils.isEmpty((Object)((Object)sysCategory))) {
            return listSysType;
        }
        List<SysType> list = this.getByGroupKey(sysCategory.getGroupKey());
        listSysType.addAll(list);
        List rtnList = BeanUtils.listToTree(listSysType);
        List ids = list.stream().map(SysType::getId).collect(Collectors.toList());
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new QueryWrapper().lambda().in(DataDict::getParentId, ids);
        List dataDicts = this.dataDictManager.list((Wrapper)wrapper);
        HashMap<String, List> dictMap = new HashMap<String, List>();
        for (DataDict dataDict : dataDicts) {
            SysType sysType = new SysType();
            sysType.setId(dataDict.getId());
            sysType.setName(dataDict.getName());
            sysType.setParentId(dataDict.getParentId());
            sysType.setOpen("false");
            sysType.setTypeKey(dataDict.getKey());
            List sysTypes = dictMap.computeIfAbsent(dataDict.getParentId(), k -> new ArrayList());
            sysTypes.add(sysType);
        }
        for (SysType type : rtnList) {
            List types = (List)dictMap.get(type.getId());
            if (!BeanUtils.isNotEmpty((Object)types)) continue;
            List children = type.getChildren();
            children.addAll(types);
        }
        return rtnList;
    }

    @Override
    public List<SysTypeTreeVO> getByParentIdOrLikeName(String catId, String parentId, String typeName) throws InvocationTargetException, IllegalAccessException {
        ArrayList<SysTypeTreeVO> vos = new ArrayList<SysTypeTreeVO>();
        List<SysType> list = new ArrayList();
        SysCategory sysCategory = (SysCategory)this.sysCategoryManager.get((Serializable)((Object)catId));
        if (BeanUtils.isEmpty((Object)((Object)sysCategory))) {
            return vos;
        }
        if (StringUtil.isNotEmpty((String)typeName)) {
            list = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysType::getTypeGroupKey, (Object)sysCategory.getGroupKey())).like(SysType::getName, (Object)typeName));
            Map<String, List<SysType>> sysTypeMap = list.stream().collect(Collectors.groupingBy(SysType::getId));
            List<DataDict> listDicData = this.dataDictManager.queryDictLikeName(typeName);
            Map<String, List<DataDict>> dataDictMap = listDicData.stream().filter(d -> StringUtil.isNotEmpty((String)d.getParentId())).collect(Collectors.groupingBy(DataDict::getParentId));
            ArrayList<String> typeIds = new ArrayList<String>();
            for (Map.Entry<String, List<DataDict>> entry : dataDictMap.entrySet()) {
                if (sysTypeMap.containsKey(entry.getKey())) {
                    sysTypeMap.get(entry.getKey()).get(0).setChildren(entry.getValue());
                    continue;
                }
                typeIds.add(entry.getKey());
            }
            if (BeanUtils.isNotEmpty(typeIds)) {
                List sysTypes = ((SysTypeDao)this.baseMapper).selectList((Wrapper)new LambdaQueryWrapper().in(SysType::getId, typeIds));
                for (SysType sysType : sysTypes) {
                    sysType.setChildren(dataDictMap.get(sysType.getId()));
                    list.add(sysType);
                }
            }
        } else if (StringUtil.isNotEmpty((String)parentId)) {
            List byParentId = this.dataDictManager.list((Wrapper)new LambdaQueryWrapper().eq(DataDict::getParentId, (Object)parentId));
            for (DataDict dataDict : byParentId) {
                SysTypeTreeVO vo = new SysTypeTreeVO();
                BeanUtils.copyNotNullProperties((Object)vo, (Object)((Object)dataDict));
                vo.setTypeKey(dataDict.getKey());
                vos.add(vo);
            }
        } else {
            list = ((SysTypeDao)this.baseMapper).selectList((Wrapper)new LambdaQueryWrapper().eq(SysType::getParentId, (Object)catId));
        }
        for (SysType sysType : list) {
            SysTypeTreeVO vo = new SysTypeTreeVO();
            BeanUtils.copyNotNullProperties((Object)vo, (Object)((Object)sysType));
            vos.add(vo);
        }
        return vos;
    }

    @Override
    public List<SysType> getByIds(List<String> ids) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().in(SysType::getId, ids);
        return ((SysTypeDao)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<SysType> getTreeByTypeKey(String typeKey) {
        SysType type = (SysType)((Object)this.getOne((Wrapper)Wrappers.lambdaQuery().eq(SysType::getTypeKey, (Object)typeKey)));
        List list = this.list((Wrapper)Wrappers.lambdaQuery().like(SysType::getPath, (Object)type.getId()));
        return BeanUtils.listToTree((List)list);
    }
}

